/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.decals;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.decals.Decal;
import com.badlogic.gdx.graphics.g3d.decals.DecalMaterial;
import com.badlogic.gdx.graphics.g3d.decals.GroupStrategy;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import java.util.Comparator;

public class CameraGroupStrategy
implements GroupStrategy,
Disposable {
    private static final int GROUP_BLEND = 1;
    private static final int GROUP_OPAQUE = 0;
    Pool<Array<Decal>> arrayPool = new Pool<Array<Decal>>(16){

        @Override
        protected Array<Decal> newObject() {
            return new Array<Decal>();
        }
    };
    Camera camera;
    private final Comparator<Decal> cameraSorter;
    ObjectMap<DecalMaterial, Array<Decal>> materialGroups;
    ShaderProgram shader;
    Array<Array<Decal>> usedArrays = new Array();

    public CameraGroupStrategy(final Camera camera) {
        this(camera, new Comparator<Decal>(){

            @Override
            public int compare(Decal decal, Decal decal2) {
                float f = camera.position.dst(decal.position);
                return (int)Math.signum(camera.position.dst(decal2.position) - f);
            }
        });
    }

    public CameraGroupStrategy(Camera camera, Comparator<Decal> comparator) {
        this.materialGroups = new ObjectMap();
        this.camera = camera;
        this.cameraSorter = comparator;
        this.createDefaultShader();
    }

    private void createDefaultShader() {
        this.shader = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projectionViewMatrix;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projectionViewMatrix * a_position;\n}\n", "#ifdef GL_ES\nprecision mediump float;\n#endif\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}");
        if (this.shader.isCompiled()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("couldn't compile shader: ");
        stringBuilder.append(this.shader.getLog());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public void afterGroup(int n) {
        if (n == 1) {
            Gdx.gl.glDisable(3042);
        }
    }

    @Override
    public void afterGroups() {
        this.shader.end();
        Gdx.gl.glDisable(2929);
    }

    @Override
    public void beforeGroup(int n, Array<Decal> array) {
        if (n == 1) {
            Gdx.gl.glEnable(3042);
            array.sort(this.cameraSorter);
        } else {
            Array<Decal> array2;
            int n2 = array.size;
            for (n = 0; n < n2; ++n) {
                Decal decal = array.get(n);
                Array<Decal> array3 = this.materialGroups.get(decal.material);
                array2 = array3;
                if (array3 == null) {
                    array2 = this.arrayPool.obtain();
                    array2.clear();
                    this.usedArrays.add(array2);
                    this.materialGroups.put(decal.material, array2);
                }
                array2.add(decal);
            }
            array.clear();
            array2 = this.materialGroups.values().iterator();
            while (array2.hasNext()) {
                array.addAll((Array)array2.next());
            }
            this.materialGroups.clear();
            this.arrayPool.freeAll(this.usedArrays);
            this.usedArrays.clear();
        }
    }

    @Override
    public void beforeGroups() {
        Gdx.gl.glEnable(2929);
        this.shader.begin();
        this.shader.setUniformMatrix("u_projectionViewMatrix", this.camera.combined);
        this.shader.setUniformi("u_texture", 0);
    }

    @Override
    public int decideGroup(Decal decal) {
        return decal.getMaterial().isOpaque() ^ 1;
    }

    @Override
    public void dispose() {
        ShaderProgram shaderProgram = this.shader;
        if (shaderProgram != null) {
            shaderProgram.dispose();
        }
    }

    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public ShaderProgram getGroupShader(int n) {
        return this.shader;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }
}

