/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.attributes;

import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.NumberUtils;

public class BlendingAttribute
extends Attribute {
    public static final String Alias = "blended";
    public static final long Type = BlendingAttribute.register("blended");
    public boolean blended;
    public int destFunction;
    public float opacity;
    public int sourceFunction;

    public BlendingAttribute() {
        this(null);
    }

    public BlendingAttribute(float f) {
        this(true, f);
    }

    public BlendingAttribute(int n, int n2) {
        this(n, n2, 1.0f);
    }

    public BlendingAttribute(int n, int n2, float f) {
        this(true, n, n2, f);
    }

    public BlendingAttribute(BlendingAttribute blendingAttribute) {
        boolean bl = blendingAttribute == null || blendingAttribute.blended;
        int n = blendingAttribute == null ? 770 : blendingAttribute.sourceFunction;
        int n2 = blendingAttribute == null ? 771 : blendingAttribute.destFunction;
        float f = blendingAttribute == null ? 1.0f : blendingAttribute.opacity;
        this(bl, n, n2, f);
    }

    public BlendingAttribute(boolean bl, float f) {
        this(bl, 770, 771, f);
    }

    public BlendingAttribute(boolean bl, int n, int n2, float f) {
        super(Type);
        this.opacity = 1.0f;
        this.blended = bl;
        this.sourceFunction = n;
        this.destFunction = n2;
        this.opacity = f;
    }

    public static final boolean is(long l) {
        boolean bl = (Type & l) == l;
        return bl;
    }

    @Override
    public int compareTo(Attribute attribute) {
        if (this.type != attribute.type) {
            return (int)(this.type - attribute.type);
        }
        attribute = (BlendingAttribute)attribute;
        boolean bl = this.blended;
        boolean bl2 = ((BlendingAttribute)attribute).blended;
        int n = 1;
        int n2 = 1;
        if (bl != bl2) {
            n = bl ? n2 : -1;
            return n;
        }
        n2 = this.sourceFunction;
        int n3 = ((BlendingAttribute)attribute).sourceFunction;
        if (n2 != n3) {
            return n2 - n3;
        }
        n3 = this.destFunction;
        n2 = ((BlendingAttribute)attribute).destFunction;
        if (n3 != n2) {
            return n3 - n2;
        }
        if (MathUtils.isEqual(this.opacity, ((BlendingAttribute)attribute).opacity)) {
            n = 0;
        } else if (!(this.opacity < ((BlendingAttribute)attribute).opacity)) {
            n = -1;
        }
        return n;
    }

    @Override
    public BlendingAttribute copy() {
        return new BlendingAttribute(this);
    }

    @Override
    public int hashCode() {
        return (((super.hashCode() * 947 + this.blended) * 947 + this.sourceFunction) * 947 + this.destFunction) * 947 + NumberUtils.floatToRawIntBits(this.opacity);
    }
}

