/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.utils.Array;

public abstract class Attribute
implements Comparable<Attribute> {
    private static final Array<String> types = new Array();
    public final long type;
    private final int typeBit;

    protected Attribute(long l) {
        this.type = l;
        this.typeBit = Long.numberOfTrailingZeros(l);
    }

    public static final String getAttributeAlias(long l) {
        int n;
        int n2 = -1;
        do {
            n = n2++;
            if (l == 0L) break;
            n = n2;
            if (n2 >= 63) break;
            n = n2;
        } while ((l >> n2 & 1L) == 0L);
        String string2 = n >= 0 && n < Attribute.types.size ? types.get(n) : null;
        return string2;
    }

    public static final long getAttributeType(String string2) {
        for (int i = 0; i < Attribute.types.size; ++i) {
            if (types.get(i).compareTo(string2) != 0) continue;
            return 1L << i;
        }
        return 0L;
    }

    protected static final long register(String string2) {
        long l = Attribute.getAttributeType(string2);
        if (l > 0L) {
            return l;
        }
        types.add(string2);
        return 1L << Attribute.types.size - 1;
    }

    public abstract Attribute copy();

    protected boolean equals(Attribute attribute) {
        boolean bl = attribute.hashCode() == this.hashCode();
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        object = (Attribute)object;
        if (this.type != ((Attribute)object).type) {
            return false;
        }
        return this.equals((Attribute)object);
    }

    public int hashCode() {
        return this.typeBit * 7489;
    }

    public String toString() {
        return Attribute.getAttributeAlias(this.type);
    }
}

