/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class OrthographicCamera
extends Camera {
    private final Vector3 tmp = new Vector3();
    public float zoom = 1.0f;

    public OrthographicCamera() {
        this.near = 0.0f;
    }

    public OrthographicCamera(float f, float f2) {
        this.viewportWidth = f;
        this.viewportHeight = f2;
        this.near = 0.0f;
        this.update();
    }

    public void rotate(float f) {
        this.rotate(this.direction, f);
    }

    public void setToOrtho(boolean bl) {
        this.setToOrtho(bl, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setToOrtho(boolean bl, float f, float f2) {
        if (bl) {
            this.up.set(0.0f, -1.0f, 0.0f);
            this.direction.set(0.0f, 0.0f, 1.0f);
        } else {
            this.up.set(0.0f, 1.0f, 0.0f);
            this.direction.set(0.0f, 0.0f, -1.0f);
        }
        Vector3 vector3 = this.position;
        float f3 = this.zoom;
        vector3.set(f3 * f / 2.0f, f3 * f2 / 2.0f, 0.0f);
        this.viewportWidth = f;
        this.viewportHeight = f2;
        this.update();
    }

    public void translate(float f, float f2) {
        this.translate(f, f2, 0.0f);
    }

    public void translate(Vector2 vector2) {
        this.translate(vector2.x, vector2.y, 0.0f);
    }

    @Override
    public void update() {
        this.update(true);
    }

    @Override
    public void update(boolean bl) {
        this.projection.setToOrtho(this.zoom * -this.viewportWidth / 2.0f, this.zoom * (this.viewportWidth / 2.0f), this.zoom * -(this.viewportHeight / 2.0f), this.zoom * this.viewportHeight / 2.0f, this.near, this.far);
        this.view.setToLookAt(this.position, this.tmp.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection);
        Matrix4.mul(this.combined.val, this.view.val);
        if (bl) {
            this.invProjectionView.set(this.combined);
            Matrix4.inv(this.invProjectionView.val);
            this.frustum.update(this.invProjectionView);
        }
    }
}

