/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.utils.NumberUtils;

public class Color {
    public static final Color BLACK;
    public static final Color BLUE;
    public static final Color BROWN;
    public static final Color CHARTREUSE;
    public static final Color CLEAR;
    public static final Color CORAL;
    public static final Color CYAN;
    public static final Color DARK_GRAY;
    public static final Color FIREBRICK;
    public static final Color FOREST;
    public static final Color GOLD;
    public static final Color GOLDENROD;
    public static final Color GRAY;
    public static final Color GREEN;
    public static final Color LIGHT_GRAY;
    public static final Color LIME;
    public static final Color MAGENTA;
    public static final Color MAROON;
    public static final Color NAVY;
    public static final Color OLIVE;
    public static final Color ORANGE;
    public static final Color PINK;
    public static final Color PURPLE;
    public static final Color RED;
    public static final Color ROYAL;
    public static final Color SALMON;
    public static final Color SCARLET;
    public static final Color SKY;
    public static final Color SLATE;
    public static final Color TAN;
    public static final Color TEAL;
    public static final Color VIOLET;
    public static final Color WHITE;
    public static final float WHITE_FLOAT_BITS;
    public static final Color YELLOW;
    public float a;
    public float b;
    public float g;
    public float r;

    static {
        WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        LIGHT_GRAY = new Color(-1077952513);
        GRAY = new Color(0x7F7F7FFF);
        DARK_GRAY = new Color(0x3F3F3FFF);
        BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        WHITE_FLOAT_BITS = WHITE.toFloatBits();
        CLEAR = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
        NAVY = new Color(0.0f, 0.0f, 0.5f, 1.0f);
        ROYAL = new Color(1097458175);
        SLATE = new Color(1887473919);
        SKY = new Color(-2016482305);
        CYAN = new Color(0.0f, 1.0f, 1.0f, 1.0f);
        TEAL = new Color(0.0f, 0.5f, 0.5f, 1.0f);
        GREEN = new Color(0xFF00FF);
        CHARTREUSE = new Color(0x7FFF00FF);
        LIME = new Color(852308735);
        FOREST = new Color(579543807);
        OLIVE = new Color(1804477439);
        YELLOW = new Color(-65281);
        GOLD = new Color(-2686721);
        GOLDENROD = new Color(-626712321);
        ORANGE = new Color(-5963521);
        BROWN = new Color(-1958407169);
        TAN = new Color(-759919361);
        FIREBRICK = new Color(-1306385665);
        RED = new Color(-16776961);
        SCARLET = new Color(-13361921);
        CORAL = new Color(-8433409);
        SALMON = new Color(-92245249);
        PINK = new Color(-9849601);
        MAGENTA = new Color(1.0f, 0.0f, 1.0f, 1.0f);
        PURPLE = new Color(-1608453889);
        VIOLET = new Color(-293409025);
        MAROON = new Color(-1339006721);
    }

    public Color() {
    }

    public Color(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
        this.clamp();
    }

    public Color(int n) {
        Color.rgba8888ToColor(this, n);
    }

    public Color(Color color2) {
        this.set(color2);
    }

    public static void abgr8888ToColor(Color color2, float f) {
        int n = NumberUtils.floatToIntColor(f);
        color2.a = (float)((0xFF000000 & n) >>> 24) / 255.0f;
        color2.b = (float)((0xFF0000 & n) >>> 16) / 255.0f;
        color2.g = (float)((0xFF00 & n) >>> 8) / 255.0f;
        color2.r = (float)(n & 0xFF) / 255.0f;
    }

    public static int alpha(float f) {
        return (int)(f * 255.0f);
    }

    public static int argb8888(float f, float f2, float f3, float f4) {
        return (int)(f * 255.0f) << 24 | (int)(f2 * 255.0f) << 16 | (int)(f3 * 255.0f) << 8 | (int)(f4 * 255.0f);
    }

    public static int argb8888(Color color2) {
        int n = (int)(color2.a * 255.0f);
        int n2 = (int)(color2.r * 255.0f);
        int n3 = (int)(color2.g * 255.0f);
        return (int)(color2.b * 255.0f) | (n << 24 | n2 << 16 | n3 << 8);
    }

    public static void argb8888ToColor(Color color2, int n) {
        color2.a = (float)((0xFF000000 & n) >>> 24) / 255.0f;
        color2.r = (float)((0xFF0000 & n) >>> 16) / 255.0f;
        color2.g = (float)((0xFF00 & n) >>> 8) / 255.0f;
        color2.b = (float)(n & 0xFF) / 255.0f;
    }

    public static int luminanceAlpha(float f, float f2) {
        return (int)(f * 255.0f) << 8 | (int)(f2 * 255.0f);
    }

    public static int rgb565(float f, float f2, float f3) {
        return (int)(f * 31.0f) << 11 | (int)(f2 * 63.0f) << 5 | (int)(f3 * 31.0f);
    }

    public static int rgb565(Color color2) {
        int n = (int)(color2.r * 31.0f);
        int n2 = (int)(color2.g * 63.0f);
        return (int)(color2.b * 31.0f) | (n << 11 | n2 << 5);
    }

    public static void rgb565ToColor(Color color2, int n) {
        color2.r = (float)((0xF800 & n) >>> 11) / 31.0f;
        color2.g = (float)((n & 0x7E0) >>> 5) / 63.0f;
        color2.b = (float)((n & 0x1F) >>> 0) / 31.0f;
    }

    public static int rgb888(float f, float f2, float f3) {
        return (int)(f * 255.0f) << 16 | (int)(f2 * 255.0f) << 8 | (int)(f3 * 255.0f);
    }

    public static int rgb888(Color color2) {
        int n = (int)(color2.r * 255.0f);
        int n2 = (int)(color2.g * 255.0f);
        return (int)(color2.b * 255.0f) | (n << 16 | n2 << 8);
    }

    public static void rgb888ToColor(Color color2, int n) {
        color2.r = (float)((0xFF0000 & n) >>> 16) / 255.0f;
        color2.g = (float)((0xFF00 & n) >>> 8) / 255.0f;
        color2.b = (float)(n & 0xFF) / 255.0f;
    }

    public static int rgba4444(float f, float f2, float f3, float f4) {
        return (int)(f * 15.0f) << 12 | (int)(f2 * 15.0f) << 8 | (int)(f3 * 15.0f) << 4 | (int)(f4 * 15.0f);
    }

    public static int rgba4444(Color color2) {
        int n = (int)(color2.r * 15.0f);
        int n2 = (int)(color2.g * 15.0f);
        int n3 = (int)(color2.b * 15.0f);
        return (int)(color2.a * 15.0f) | (n << 12 | n2 << 8 | n3 << 4);
    }

    public static void rgba4444ToColor(Color color2, int n) {
        color2.r = (float)((0xF000 & n) >>> 12) / 15.0f;
        color2.g = (float)((n & 0xF00) >>> 8) / 15.0f;
        color2.b = (float)((n & 0xF0) >>> 4) / 15.0f;
        color2.a = (float)(n & 0xF) / 15.0f;
    }

    public static int rgba8888(float f, float f2, float f3, float f4) {
        return (int)(f * 255.0f) << 24 | (int)(f2 * 255.0f) << 16 | (int)(f3 * 255.0f) << 8 | (int)(f4 * 255.0f);
    }

    public static int rgba8888(Color color2) {
        int n = (int)(color2.r * 255.0f);
        int n2 = (int)(color2.g * 255.0f);
        int n3 = (int)(color2.b * 255.0f);
        return (int)(color2.a * 255.0f) | (n << 24 | n2 << 16 | n3 << 8);
    }

    public static void rgba8888ToColor(Color color2, int n) {
        color2.r = (float)((0xFF000000 & n) >>> 24) / 255.0f;
        color2.g = (float)((0xFF0000 & n) >>> 16) / 255.0f;
        color2.b = (float)((0xFF00 & n) >>> 8) / 255.0f;
        color2.a = (float)(n & 0xFF) / 255.0f;
    }

    public static float toFloatBits(float f, float f2, float f3, float f4) {
        int n = (int)(f4 * 255.0f);
        int n2 = (int)(f3 * 255.0f);
        int n3 = (int)(f2 * 255.0f);
        return NumberUtils.intToFloatColor((int)(f * 255.0f) | (n3 << 8 | (n2 << 16 | n << 24)));
    }

    public static float toFloatBits(int n, int n2, int n3, int n4) {
        return NumberUtils.intToFloatColor(n | (n2 << 8 | (n3 << 16 | n4 << 24)));
    }

    public static int toIntBits(int n, int n2, int n3, int n4) {
        return n | (n2 << 8 | (n3 << 16 | n4 << 24));
    }

    public static Color valueOf(String string2) {
        String string3 = string2;
        if (string2.charAt(0) == '#') {
            string3 = string2.substring(1);
        }
        int n = Integer.valueOf(string3.substring(0, 2), 16);
        int n2 = Integer.valueOf(string3.substring(2, 4), 16);
        int n3 = Integer.valueOf(string3.substring(4, 6), 16);
        int n4 = string3.length() != 8 ? 255 : Integer.valueOf(string3.substring(6, 8), 16);
        return new Color((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, (float)n4 / 255.0f);
    }

    public Color add(float f, float f2, float f3, float f4) {
        this.r += f;
        this.g += f2;
        this.b += f3;
        this.a += f4;
        return this.clamp();
    }

    public Color add(Color color2) {
        this.r += color2.r;
        this.g += color2.g;
        this.b += color2.b;
        this.a += color2.a;
        return this.clamp();
    }

    public Color clamp() {
        float f = this.r;
        if (f < 0.0f) {
            this.r = 0.0f;
        } else if (f > 1.0f) {
            this.r = 1.0f;
        }
        f = this.g;
        if (f < 0.0f) {
            this.g = 0.0f;
        } else if (f > 1.0f) {
            this.g = 1.0f;
        }
        f = this.b;
        if (f < 0.0f) {
            this.b = 0.0f;
        } else if (f > 1.0f) {
            this.b = 1.0f;
        }
        f = this.a;
        if (f < 0.0f) {
            this.a = 0.0f;
        } else if (f > 1.0f) {
            this.a = 1.0f;
        }
        return this;
    }

    public Color cpy() {
        return new Color(this);
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (Color)object;
            if (this.toIntBits() != ((Color)object).toIntBits()) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public Color fromHsv(float f, float f2, float f3) {
        f = (f / 60.0f + 6.0f) % 6.0f;
        int n = (int)f;
        float f4 = f - (float)n;
        f = (1.0f - f2) * f3;
        float f5 = (1.0f - f2 * f4) * f3;
        f2 = (1.0f - f2 * (1.0f - f4)) * f3;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            this.r = f3;
                            this.g = f;
                            this.b = f5;
                        } else {
                            this.r = f2;
                            this.g = f;
                            this.b = f3;
                        }
                    } else {
                        this.r = f;
                        this.g = f5;
                        this.b = f3;
                    }
                } else {
                    this.r = f;
                    this.g = f3;
                    this.b = f2;
                }
            } else {
                this.r = f5;
                this.g = f3;
                this.b = f;
            }
        } else {
            this.r = f3;
            this.g = f2;
            this.b = f;
        }
        return this.clamp();
    }

    public Color fromHsv(float[] fArray) {
        return this.fromHsv(fArray[0], fArray[1], fArray[2]);
    }

    public int hashCode() {
        float f = this.r;
        int n = 0;
        int n2 = f != 0.0f ? NumberUtils.floatToIntBits(f) : 0;
        f = this.g;
        int n3 = f != 0.0f ? NumberUtils.floatToIntBits(f) : 0;
        f = this.b;
        int n4 = f != 0.0f ? NumberUtils.floatToIntBits(f) : 0;
        f = this.a;
        if (f != 0.0f) {
            n = NumberUtils.floatToIntBits(f);
        }
        return ((n2 * 31 + n3) * 31 + n4) * 31 + n;
    }

    public Color lerp(float f, float f2, float f3, float f4, float f5) {
        float f6 = this.r;
        this.r = f6 + (f - f6) * f5;
        f = this.g;
        this.g = f + (f2 - f) * f5;
        f = this.b;
        this.b = f + (f3 - f) * f5;
        f = this.a;
        this.a = f + f5 * (f4 - f);
        return this.clamp();
    }

    public Color lerp(Color color2, float f) {
        float f2 = this.r;
        this.r = f2 + (color2.r - f2) * f;
        f2 = this.g;
        this.g = f2 + (color2.g - f2) * f;
        f2 = this.b;
        this.b = f2 + (color2.b - f2) * f;
        f2 = this.a;
        this.a = f2 + f * (color2.a - f2);
        return this.clamp();
    }

    public Color mul(float f) {
        this.r *= f;
        this.g *= f;
        this.b *= f;
        this.a *= f;
        return this.clamp();
    }

    public Color mul(float f, float f2, float f3, float f4) {
        this.r *= f;
        this.g *= f2;
        this.b *= f3;
        this.a *= f4;
        return this.clamp();
    }

    public Color mul(Color color2) {
        this.r *= color2.r;
        this.g *= color2.g;
        this.b *= color2.b;
        this.a *= color2.a;
        return this.clamp();
    }

    public Color premultiplyAlpha() {
        float f = this.r;
        float f2 = this.a;
        this.r = f * f2;
        this.g *= f2;
        this.b *= f2;
        return this;
    }

    public Color set(float f, float f2, float f3, float f4) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.a = f4;
        return this.clamp();
    }

    public Color set(int n) {
        Color.rgba8888ToColor(this, n);
        return this;
    }

    public Color set(Color color2) {
        this.r = color2.r;
        this.g = color2.g;
        this.b = color2.b;
        this.a = color2.a;
        return this;
    }

    public Color sub(float f, float f2, float f3, float f4) {
        this.r -= f;
        this.g -= f2;
        this.b -= f3;
        this.a -= f4;
        return this.clamp();
    }

    public Color sub(Color color2) {
        this.r -= color2.r;
        this.g -= color2.g;
        this.b -= color2.b;
        this.a -= color2.a;
        return this.clamp();
    }

    public float toFloatBits() {
        return NumberUtils.intToFloatColor((int)(this.a * 255.0f) << 24 | (int)(this.b * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.r * 255.0f));
    }

    public float[] toHsv(float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4 = Math.max(Math.max(this.r, this.g), this.b);
        float f5 = f4 - (f3 = Math.min(Math.min(this.r, this.g), this.b));
        fArray[0] = f5 == 0.0f ? 0.0f : (f4 == (f2 = this.r) ? ((this.g - this.b) * 60.0f / f5 + 360.0f) % 360.0f : (f4 == (f = this.g) ? (this.b - f2) * 60.0f / f5 + 120.0f : (f2 - f) * 60.0f / f5 + 240.0f));
        fArray[1] = f4 > 0.0f ? 1.0f - f3 / f4 : 0.0f;
        fArray[2] = f4;
        return fArray;
    }

    public int toIntBits() {
        return (int)(this.a * 255.0f) << 24 | (int)(this.b * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.r * 255.0f);
    }

    public String toString() {
        String string2 = Integer.toHexString((int)(this.r * 255.0f) << 24 | (int)(this.g * 255.0f) << 16 | (int)(this.b * 255.0f) << 8 | (int)(this.a * 255.0f));
        while (string2.length() < 8) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("0");
            stringBuilder.append(string2);
            string2 = stringBuilder.toString();
        }
        return string2;
    }
}

