/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.files;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class FileHandle {
    protected File file;
    protected Files.FileType type;

    protected FileHandle() {
    }

    public FileHandle(File file) {
        this.file = file;
        this.type = Files.FileType.Absolute;
    }

    protected FileHandle(File file, Files.FileType fileType) {
        this.file = file;
        this.type = fileType;
    }

    public FileHandle(String string2) {
        this.file = new File(string2);
        this.type = Files.FileType.Absolute;
    }

    protected FileHandle(String string2, Files.FileType fileType) {
        this.type = fileType;
        this.file = new File(string2);
    }

    private static void copyDirectory(FileHandle fileHandle3, FileHandle fileHandle2) {
        fileHandle2.mkdirs();
        for (FileHandle fileHandle3 : fileHandle3.list()) {
            FileHandle fileHandle4 = fileHandle2.child(fileHandle3.name());
            if (fileHandle3.isDirectory()) {
                FileHandle.copyDirectory(fileHandle3, fileHandle4);
                continue;
            }
            FileHandle.copyFile(fileHandle3, fileHandle4);
        }
    }

    private static void copyFile(FileHandle fileHandle, FileHandle fileHandle2) {
        try {
            fileHandle2.write(fileHandle.read(), false);
            return;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error copying source file: ");
            stringBuilder.append(fileHandle.file);
            stringBuilder.append(" (");
            stringBuilder.append((Object)fileHandle.type);
            stringBuilder.append(")\nTo destination: ");
            stringBuilder.append(fileHandle2.file);
            stringBuilder.append(" (");
            stringBuilder.append((Object)fileHandle2.type);
            stringBuilder.append(")");
            throw new GdxRuntimeException(stringBuilder.toString(), exception);
        }
    }

    private static boolean deleteDirectory(File file) {
        FileHandle.emptyDirectory(file, false);
        return file.delete();
    }

    private static void emptyDirectory(File fileArray, boolean bl) {
        if (fileArray.exists() && (fileArray = fileArray.listFiles()) != null) {
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                if (!fileArray[i].isDirectory()) {
                    fileArray[i].delete();
                    continue;
                }
                if (bl) {
                    FileHandle.emptyDirectory(fileArray[i], true);
                    continue;
                }
                FileHandle.deleteDirectory(fileArray[i]);
            }
        }
    }

    private int estimateLength() {
        int n = (int)this.length();
        if (n == 0) {
            n = 512;
        }
        return n;
    }

    public static FileHandle tempDirectory(String object) {
        try {
            object = File.createTempFile((String)object, null);
            if (((File)object).delete()) {
                if (((File)object).mkdir()) {
                    return new FileHandle((File)object);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unable to create temp directory: ");
                stringBuilder.append(object);
                IOException iOException = new IOException(stringBuilder.toString());
                throw iOException;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unable to delete temp file: ");
            stringBuilder.append(object);
            IOException iOException = new IOException(stringBuilder.toString());
            throw iOException;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Unable to create temp file.", iOException);
        }
    }

    public static FileHandle tempFile(String object) {
        try {
            object = new FileHandle(File.createTempFile((String)object, null));
            return object;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Unable to create temp file.", iOException);
        }
    }

    public FileHandle child(String string2) {
        if (this.file.getPath().length() == 0) {
            return new FileHandle(new File(string2), this.type);
        }
        return new FileHandle(new File(this.file, string2), this.type);
    }

    public void copyTo(FileHandle fileHandle) {
        block9: {
            block8: {
                block7: {
                    if (!this.isDirectory()) {
                        FileHandle fileHandle2 = fileHandle;
                        if (fileHandle.isDirectory()) {
                            fileHandle2 = fileHandle.child(this.name());
                        }
                        FileHandle.copyFile(this, fileHandle2);
                        return;
                    }
                    if (!fileHandle.exists()) break block7;
                    if (!fileHandle.isDirectory()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Destination exists but is not a directory: ");
                        stringBuilder.append(fileHandle);
                        throw new GdxRuntimeException(stringBuilder.toString());
                    }
                    break block8;
                }
                fileHandle.mkdirs();
                if (!fileHandle.isDirectory()) break block9;
            }
            FileHandle.copyDirectory(this, fileHandle.child(this.name()));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Destination directory cannot be created: ");
        stringBuilder.append(fileHandle);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public boolean delete() {
        if (this.type != Files.FileType.Classpath) {
            if (this.type != Files.FileType.Internal) {
                return this.file().delete();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot delete an internal file: ");
            stringBuilder.append(this.file);
            throw new GdxRuntimeException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot delete a classpath file: ");
        stringBuilder.append(this.file);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public boolean deleteDirectory() {
        if (this.type != Files.FileType.Classpath) {
            if (this.type != Files.FileType.Internal) {
                return FileHandle.deleteDirectory(this.file());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot delete an internal file: ");
            stringBuilder.append(this.file);
            throw new GdxRuntimeException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot delete a classpath file: ");
        stringBuilder.append(this.file);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public void emptyDirectory() {
        this.emptyDirectory(false);
    }

    public void emptyDirectory(boolean bl) {
        if (this.type != Files.FileType.Classpath) {
            if (this.type != Files.FileType.Internal) {
                FileHandle.emptyDirectory(this.file(), bl);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot delete an internal file: ");
            stringBuilder.append(this.file);
            throw new GdxRuntimeException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot delete a classpath file: ");
        stringBuilder.append(this.file);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof FileHandle;
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        object = (FileHandle)object;
        bl = bl2;
        if (this.type == ((FileHandle)object).type) {
            bl = bl2;
            if (this.path().equals(((FileHandle)object).path())) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean exists() {
        int n = 1.$SwitchMap$com$badlogic$gdx$Files$FileType[this.type.ordinal()];
        boolean bl = true;
        if (n != 1) {
            if (n != 2) {
                return this.file().exists();
            }
        } else if (this.file().exists()) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/");
        stringBuilder.append(this.file.getPath().replace('\\', '/'));
        if (FileHandle.class.getResource(stringBuilder.toString()) == null) {
            bl = false;
        }
        return bl;
    }

    public String extension() {
        String string2 = this.file.getName();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string2.substring(n + 1);
    }

    public File file() {
        if (this.type == Files.FileType.External) {
            return new File(Gdx.files.getExternalStoragePath(), this.file.getPath());
        }
        return this.file;
    }

    public int hashCode() {
        return (37 + this.type.hashCode()) * 67 + this.path().hashCode();
    }

    public boolean isDirectory() {
        if (this.type == Files.FileType.Classpath) {
            return false;
        }
        return this.file().isDirectory();
    }

    public long lastModified() {
        return this.file().lastModified();
    }

    public long length() {
        int n;
        if (this.type != Files.FileType.Classpath && (this.type != Files.FileType.Internal || this.file.exists())) {
            return this.file().length();
        }
        InputStream inputStream = this.read();
        try {
            n = inputStream.available();
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(inputStream);
            throw throwable;
        }
        catch (Exception exception) {
            StreamUtils.closeQuietly(inputStream);
            return 0L;
        }
        long l = n;
        StreamUtils.closeQuietly(inputStream);
        return l;
    }

    public FileHandle[] list() {
        if (this.type != Files.FileType.Classpath) {
            String[] stringArray = this.file().list();
            if (stringArray == null) {
                return new FileHandle[0];
            }
            FileHandle[] fileHandleArray = new FileHandle[stringArray.length];
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                fileHandleArray[i] = this.child(stringArray[i]);
            }
            return fileHandleArray;
        }
        Serializable serializable = new StringBuilder();
        serializable.append("Cannot list a classpath directory: ");
        serializable.append(this.file);
        serializable = new GdxRuntimeException(serializable.toString());
        throw serializable;
    }

    public FileHandle[] list(FileFilter fileHandleArray) {
        if (this.type != Files.FileType.Classpath) {
            String[] stringArray = this.file().list();
            if (stringArray == null) {
                return new FileHandle[0];
            }
            FileHandle[] fileHandleArray2 = new FileHandle[stringArray.length];
            int n = stringArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                FileHandle fileHandle = this.child(stringArray[i]);
                if (!fileHandleArray.accept(fileHandle.file())) continue;
                fileHandleArray2[n2] = fileHandle;
                ++n2;
            }
            if (n2 < stringArray.length) {
                fileHandleArray = new FileHandle[n2];
                System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
            } else {
                fileHandleArray = fileHandleArray2;
            }
            return fileHandleArray;
        }
        fileHandleArray = new StringBuilder();
        fileHandleArray.append("Cannot list a classpath directory: ");
        fileHandleArray.append(this.file);
        fileHandleArray = new GdxRuntimeException(fileHandleArray.toString());
        throw fileHandleArray;
    }

    public FileHandle[] list(FilenameFilter fileHandleArray) {
        if (this.type != Files.FileType.Classpath) {
            File file = this.file();
            String[] stringArray = file.list();
            if (stringArray == null) {
                return new FileHandle[0];
            }
            FileHandle[] fileHandleArray2 = new FileHandle[stringArray.length];
            int n = stringArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!fileHandleArray.accept(file, string2)) continue;
                fileHandleArray2[n2] = this.child(string2);
                ++n2;
            }
            if (n2 < stringArray.length) {
                fileHandleArray = new FileHandle[n2];
                System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
            } else {
                fileHandleArray = fileHandleArray2;
            }
            return fileHandleArray;
        }
        fileHandleArray = new StringBuilder();
        fileHandleArray.append("Cannot list a classpath directory: ");
        fileHandleArray.append(this.file);
        fileHandleArray = new GdxRuntimeException(fileHandleArray.toString());
        throw fileHandleArray;
    }

    public FileHandle[] list(String fileHandleArray) {
        if (this.type != Files.FileType.Classpath) {
            String[] stringArray = this.file().list();
            if (stringArray == null) {
                return new FileHandle[0];
            }
            FileHandle[] fileHandleArray2 = new FileHandle[stringArray.length];
            int n = stringArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!string2.endsWith((String)fileHandleArray)) continue;
                fileHandleArray2[n2] = this.child(string2);
                ++n2;
            }
            if (n2 < stringArray.length) {
                fileHandleArray = new FileHandle[n2];
                System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
            } else {
                fileHandleArray = fileHandleArray2;
            }
            return fileHandleArray;
        }
        fileHandleArray = new StringBuilder();
        fileHandleArray.append("Cannot list a classpath directory: ");
        fileHandleArray.append(this.file);
        fileHandleArray = new GdxRuntimeException(fileHandleArray.toString());
        throw fileHandleArray;
    }

    public ByteBuffer map() {
        return this.map(FileChannel.MapMode.READ_ONLY);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer map(FileChannel.MapMode object) {
        void var1_4;
        Object object2;
        block8: {
            Object object3;
            CharSequence charSequence;
            GdxRuntimeException gdxRuntimeException;
            block9: {
                Object object4;
                if (this.type == Files.FileType.Classpath) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Cannot map a classpath file: ");
                    ((StringBuilder)object).append(this);
                    throw new GdxRuntimeException(((StringBuilder)object).toString());
                }
                gdxRuntimeException = null;
                object2 = object4 = null;
                try {
                    object2 = object4;
                    File file = this.file;
                    object2 = object4;
                    charSequence = object == FileChannel.MapMode.READ_ONLY ? "r" : "rw";
                    object2 = object4;
                    object3 = new RandomAccessFile(file, (String)charSequence);
                }
                catch (Throwable throwable) {
                    break block8;
                }
                catch (Exception exception) {
                    object = gdxRuntimeException;
                    break block9;
                }
                try {
                    object = ((RandomAccessFile)object3).getChannel().map((FileChannel.MapMode)object, 0L, this.file.length());
                    ((ByteBuffer)object).order(ByteOrder.nativeOrder());
                }
                catch (Throwable throwable) {
                    object2 = object3;
                    break block8;
                }
                catch (Exception exception) {
                    object = object3;
                    object3 = exception;
                    break block9;
                }
                StreamUtils.closeQuietly((Closeable)object3);
                return object;
            }
            object2 = object;
            {
                object2 = object;
                object2 = object;
                charSequence = new StringBuilder();
                object2 = object;
                ((StringBuilder)charSequence).append("Error memory mapping file: ");
                object2 = object;
                ((StringBuilder)charSequence).append(this);
                object2 = object;
                ((StringBuilder)charSequence).append(" (");
                object2 = object;
                ((StringBuilder)charSequence).append((Object)this.type);
                object2 = object;
                ((StringBuilder)charSequence).append(")");
                object2 = object;
                gdxRuntimeException = new GdxRuntimeException(((StringBuilder)charSequence).toString(), (Throwable)object3);
                object2 = object;
                throw gdxRuntimeException;
            }
        }
        StreamUtils.closeQuietly(object2);
        throw var1_4;
    }

    public void mkdirs() {
        if (this.type != Files.FileType.Classpath) {
            if (this.type != Files.FileType.Internal) {
                this.file().mkdirs();
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot mkdirs with an internal file: ");
            stringBuilder.append(this.file);
            throw new GdxRuntimeException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot mkdirs with a classpath file: ");
        stringBuilder.append(this.file);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public void moveTo(FileHandle object) {
        int n = 1.$SwitchMap$com$badlogic$gdx$Files$FileType[this.type.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if ((n == 3 || n == 4) && this.file().renameTo(((FileHandle)object).file())) {
                    return;
                }
                this.copyTo((FileHandle)object);
                this.delete();
                if (this.exists() && this.isDirectory()) {
                    this.deleteDirectory();
                }
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot move a classpath file: ");
            ((StringBuilder)object).append(this.file);
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Cannot move an internal file: ");
        ((StringBuilder)object).append(this.file);
        throw new GdxRuntimeException(((StringBuilder)object).toString());
    }

    public String name() {
        return this.file.getName();
    }

    public String nameWithoutExtension() {
        String string2 = this.file.getName();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public FileHandle parent() {
        File file;
        File file2 = file = this.file.getParentFile();
        if (file == null) {
            file2 = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new FileHandle(file2, this.type);
    }

    public String path() {
        return this.file.getPath().replace('\\', '/');
    }

    public String pathWithoutExtension() {
        String string2 = this.file.getPath().replace('\\', '/');
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public BufferedInputStream read(int n) {
        return new BufferedInputStream(this.read(), n);
    }

    public InputStream read() {
        if (this.type != Files.FileType.Classpath && (this.type != Files.FileType.Internal || this.file().exists()) && (this.type != Files.FileType.Local || this.file().exists())) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.file());
                return fileInputStream;
            }
            catch (Exception exception) {
                if (this.file().isDirectory()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Cannot open a stream to a directory: ");
                    stringBuilder.append(this.file);
                    stringBuilder.append(" (");
                    stringBuilder.append((Object)this.type);
                    stringBuilder.append(")");
                    throw new GdxRuntimeException(stringBuilder.toString(), exception);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Error reading file: ");
                stringBuilder.append(this.file);
                stringBuilder.append(" (");
                stringBuilder.append((Object)this.type);
                stringBuilder.append(")");
                throw new GdxRuntimeException(stringBuilder.toString(), exception);
            }
        }
        Object object = new StringBuilder();
        ((StringBuilder)object).append("/");
        ((StringBuilder)object).append(this.file.getPath().replace('\\', '/'));
        object = FileHandle.class.getResourceAsStream(((StringBuilder)object).toString());
        if (object != null) {
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("File not found: ");
        ((StringBuilder)object).append(this.file);
        ((StringBuilder)object).append(" (");
        ((StringBuilder)object).append((Object)this.type);
        ((StringBuilder)object).append(")");
        throw new GdxRuntimeException(((StringBuilder)object).toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readBytes(byte[] byArray, int n, int n2) {
        Throwable throwable2222222;
        InputStream inputStream = this.read();
        int n3 = 0;
        while (true) {
            int n4;
            block5: {
                n4 = inputStream.read(byArray, n + n3, n2 - n3);
                if (n4 > 0) break block5;
                {
                    catch (Throwable throwable2222222) {
                        break;
                    }
                    catch (IOException iOException) {}
                    {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Error reading file: ");
                        stringBuilder.append(this);
                        GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(stringBuilder.toString(), iOException);
                        throw gdxRuntimeException;
                    }
                }
                StreamUtils.closeQuietly(inputStream);
                return n3 - n;
            }
            n3 += n4;
        }
        StreamUtils.closeQuietly(inputStream);
        throw throwable2222222;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readBytes() {
        Throwable throwable2222222;
        InputStream inputStream;
        block4: {
            inputStream = this.read();
            byte[] byArray = StreamUtils.copyStreamToByteArray(inputStream, this.estimateLength());
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (IOException iOException) {}
                {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Error reading file: ");
                    stringBuilder.append(this);
                    GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(stringBuilder.toString(), iOException);
                    throw gdxRuntimeException;
                }
            }
            StreamUtils.closeQuietly(inputStream);
            return byArray;
        }
        StreamUtils.closeQuietly(inputStream);
        throw throwable2222222;
    }

    public String readString() {
        return this.readString(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readString(String var1_1) {
        var2_3 = new StringBuilder(this.estimateLength());
        var3_4 = null;
        var4_6 = null;
        if (var1_1 != null) ** GOTO lbl12
        var5_7 = var4_6;
        var6_8 = var3_4;
        try {
            block6: {
                var5_7 = var4_6;
                var6_8 = var3_4;
                var1_1 = new InputStreamReader(this.read());
                break block6;
lbl12:
                // 1 sources

                var5_7 = var4_6;
                var6_8 = var3_4;
                var1_1 = new InputStreamReader(this.read(), (String)var1_1);
            }
            var5_7 = var1_1;
            var6_8 = var1_1;
            var4_6 = new char[256];
lbl19:
            // 2 sources

            while (true) {
                var5_7 = var1_1;
                var6_8 = var1_1;
                var7_9 = var1_1.read((char[])var4_6);
                if (var7_9 != -1) ** GOTO lbl42
                ** GOTO lbl40
                break;
            }
        }
        catch (IOException var3_5) {
            var5_7 = var6_8;
            var5_7 = var6_8;
            var5_7 = var6_8;
            var4_6 = new StringBuilder();
            var5_7 = var6_8;
            var4_6.append("Error reading layout file: ");
            var5_7 = var6_8;
            var4_6.append(this);
            var5_7 = var6_8;
            var1_1 = new GdxRuntimeException(var4_6.toString(), var3_5);
            var5_7 = var6_8;
            throw var1_1;
lbl40:
            // 1 sources

            StreamUtils.closeQuietly((Closeable)var1_1);
            return var2_3.toString();
lbl42:
            // 1 sources

            var5_7 = var1_1;
            var6_8 = var1_1;
            {
                var2_3.append((char[])var4_6, 0, var7_9);
                ** continue;
            }
            catch (Throwable var1_2) {}
        }
        StreamUtils.closeQuietly(var5_7);
        throw var1_2;
    }

    public BufferedReader reader(int n) {
        return new BufferedReader(new InputStreamReader(this.read()), n);
    }

    public BufferedReader reader(int n, String object) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.read(), (String)object);
            object = new BufferedReader(inputStreamReader, n);
            return object;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error reading file: ");
            stringBuilder.append(this);
            throw new GdxRuntimeException(stringBuilder.toString(), unsupportedEncodingException);
        }
    }

    public Reader reader() {
        return new InputStreamReader(this.read());
    }

    public Reader reader(String object) {
        Object object2 = this.read();
        try {
            object = new InputStreamReader((InputStream)object2, (String)object);
            return object;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StreamUtils.closeQuietly((Closeable)object2);
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Error reading file: ");
            ((StringBuilder)object2).append(this);
            throw new GdxRuntimeException(((StringBuilder)object2).toString(), unsupportedEncodingException);
        }
    }

    public FileHandle sibling(String string2) {
        if (this.file.getPath().length() != 0) {
            return new FileHandle(new File(this.file.getParent(), string2), this.type);
        }
        throw new GdxRuntimeException("Cannot get the sibling of the root.");
    }

    public String toString() {
        return this.file.getPath().replace('\\', '/');
    }

    public Files.FileType type() {
        return this.type;
    }

    public OutputStream write(boolean bl) {
        if (this.type != Files.FileType.Classpath) {
            if (this.type != Files.FileType.Internal) {
                this.parent().mkdirs();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file(), bl);
                    return fileOutputStream;
                }
                catch (Exception exception) {
                    if (this.file().isDirectory()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Cannot open a stream to a directory: ");
                        stringBuilder.append(this.file);
                        stringBuilder.append(" (");
                        stringBuilder.append((Object)this.type);
                        stringBuilder.append(")");
                        throw new GdxRuntimeException(stringBuilder.toString(), exception);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Error writing file: ");
                    stringBuilder.append(this.file);
                    stringBuilder.append(" (");
                    stringBuilder.append((Object)this.type);
                    stringBuilder.append(")");
                    throw new GdxRuntimeException(stringBuilder.toString(), exception);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot write to an internal file: ");
            stringBuilder.append(this.file);
            throw new GdxRuntimeException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot write to a classpath file: ");
        stringBuilder.append(this.file);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public OutputStream write(boolean bl, int n) {
        return new BufferedOutputStream(this.write(bl), n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(InputStream inputStream, boolean bl) {
        Throwable throwable2222222;
        OutputStream outputStream;
        block4: {
            OutputStream outputStream2;
            OutputStream outputStream3 = null;
            outputStream = null;
            outputStream = outputStream2 = this.write(bl);
            outputStream3 = outputStream2;
            StreamUtils.copyStream(inputStream, outputStream2);
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (Exception exception) {}
                outputStream = outputStream3;
                {
                    outputStream = outputStream3;
                    outputStream = outputStream3;
                    StringBuilder stringBuilder = new StringBuilder();
                    outputStream = outputStream3;
                    stringBuilder.append("Error stream writing to file: ");
                    outputStream = outputStream3;
                    stringBuilder.append(this.file);
                    outputStream = outputStream3;
                    stringBuilder.append(" (");
                    outputStream = outputStream3;
                    stringBuilder.append((Object)this.type);
                    outputStream = outputStream3;
                    stringBuilder.append(")");
                    outputStream = outputStream3;
                    GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(stringBuilder.toString(), exception);
                    outputStream = outputStream3;
                    throw gdxRuntimeException;
                }
            }
            StreamUtils.closeQuietly(inputStream);
            StreamUtils.closeQuietly(outputStream2);
            return;
        }
        StreamUtils.closeQuietly(inputStream);
        StreamUtils.closeQuietly(outputStream);
        throw throwable2222222;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeBytes(byte[] object, int n, int n2, boolean bl) {
        Throwable throwable2222222;
        OutputStream outputStream;
        block4: {
            outputStream = this.write(bl);
            outputStream.write((byte[])object, n, n2);
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (IOException iOException) {}
                {
                    object = new StringBuilder;
                    ((StringBuilder)object)();
                    ((StringBuilder)object).append("Error writing file: ");
                    ((StringBuilder)object).append(this.file);
                    ((StringBuilder)object).append(" (");
                    ((StringBuilder)object).append((Object)this.type);
                    ((StringBuilder)object).append(")");
                    GdxRuntimeException gdxRuntimeException = new GdxRuntimeException(((StringBuilder)object).toString(), iOException);
                    throw gdxRuntimeException;
                }
            }
            StreamUtils.closeQuietly(outputStream);
            return;
        }
        StreamUtils.closeQuietly(outputStream);
        throw throwable2222222;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeBytes(byte[] object, boolean bl) {
        Throwable throwable2222222;
        OutputStream outputStream;
        block4: {
            outputStream = this.write(bl);
            outputStream.write((byte[])object);
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (IOException iOException) {}
                {
                    object = new GdxRuntimeException;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Error writing file: ");
                    stringBuilder.append(this.file);
                    stringBuilder.append(" (");
                    stringBuilder.append((Object)this.type);
                    stringBuilder.append(")");
                    object(stringBuilder.toString(), iOException);
                    throw object;
                }
            }
            StreamUtils.closeQuietly(outputStream);
            return;
        }
        StreamUtils.closeQuietly(outputStream);
        throw throwable2222222;
    }

    public void writeString(String string2, boolean bl) {
        this.writeString(string2, bl, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeString(String string2, boolean bl, String object) {
        Throwable throwable2222222;
        Object object2;
        block4: {
            Object object3 = null;
            object2 = null;
            object2 = object = this.writer(bl, (String)object);
            object3 = object;
            ((Writer)object).write(string2);
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (Exception exception) {}
                object2 = object3;
                {
                    object2 = object3;
                    object2 = object3;
                    StringBuilder stringBuilder = new StringBuilder();
                    object2 = object3;
                    stringBuilder.append("Error writing file: ");
                    object2 = object3;
                    stringBuilder.append(this.file);
                    object2 = object3;
                    stringBuilder.append(" (");
                    object2 = object3;
                    stringBuilder.append((Object)this.type);
                    object2 = object3;
                    stringBuilder.append(")");
                    object2 = object3;
                    object = new GdxRuntimeException(stringBuilder.toString(), exception);
                    object2 = object3;
                    throw object;
                }
            }
            StreamUtils.closeQuietly((Closeable)object);
            return;
        }
        StreamUtils.closeQuietly(object2);
        throw throwable2222222;
    }

    public Writer writer(boolean bl) {
        return this.writer(bl, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Writer writer(boolean bl, String object) {
        if (this.type != Files.FileType.Classpath) {
            if (this.type != Files.FileType.Internal) {
                Object object2;
                this.parent().mkdirs();
                try {
                    object2 = new FileOutputStream(this.file(), bl);
                    if (object != null) return new OutputStreamWriter((OutputStream)object2, (String)object);
                }
                catch (IOException iOException) {
                    if (this.file().isDirectory()) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Cannot open a stream to a directory: ");
                        ((StringBuilder)object2).append(this.file);
                        ((StringBuilder)object2).append(" (");
                        ((StringBuilder)object2).append((Object)this.type);
                        ((StringBuilder)object2).append(")");
                        throw new GdxRuntimeException(((StringBuilder)object2).toString(), iOException);
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Error writing file: ");
                    ((StringBuilder)object2).append(this.file);
                    ((StringBuilder)object2).append(" (");
                    ((StringBuilder)object2).append((Object)this.type);
                    ((StringBuilder)object2).append(")");
                    throw new GdxRuntimeException(((StringBuilder)object2).toString(), iOException);
                }
                return new OutputStreamWriter((OutputStream)object2);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot write to an internal file: ");
            ((StringBuilder)object).append(this.file);
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Cannot write to a classpath file: ");
        ((StringBuilder)object).append(this.file);
        throw new GdxRuntimeException(((StringBuilder)object).toString());
    }
}

