/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.os.Build;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidAudioDevice;
import com.badlogic.gdx.backends.android.AndroidAudioRecorder;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidMusic;
import com.badlogic.gdx.backends.android.AndroidSound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AndroidAudio
implements Audio {
    private final AudioManager manager;
    protected final List<AndroidMusic> musics = new ArrayList<AndroidMusic>();
    private final SoundPool soundPool;

    public AndroidAudio(Context context, AndroidApplicationConfiguration androidApplicationConfiguration) {
        if (!androidApplicationConfiguration.disableAudio) {
            if (Build.VERSION.SDK_INT >= 21) {
                AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(14).setContentType(4).build();
                this.soundPool = new SoundPool.Builder().setAudioAttributes(audioAttributes).setMaxStreams(androidApplicationConfiguration.maxSimultaneousSounds).build();
            } else {
                this.soundPool = new SoundPool(androidApplicationConfiguration.maxSimultaneousSounds, 3, 0);
            }
            this.manager = (AudioManager)context.getSystemService("audio");
            if (context instanceof Activity) {
                ((Activity)context).setVolumeControlStream(3);
            }
        } else {
            this.soundPool = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            Object object = new ArrayList(this.musics);
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                ((AndroidMusic)object.next()).dispose();
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        this.soundPool.release();
    }

    @Override
    public AudioDevice newAudioDevice(int n, boolean bl) {
        if (this.soundPool != null) {
            return new AndroidAudioDevice(n, bl);
        }
        throw new GdxRuntimeException("Android audio is not enabled by the application config.");
    }

    @Override
    public AudioRecorder newAudioRecorder(int n, boolean bl) {
        if (this.soundPool != null) {
            return new AndroidAudioRecorder(n, bl);
        }
        throw new GdxRuntimeException("Android audio is not enabled by the application config.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Music newMusic(FileHandle fileHandle) {
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        Object object = (AndroidFileHandle)fileHandle;
        Object object2 = new MediaPlayer();
        if (((FileHandle)object).type() == Files.FileType.Internal) {
            try {
                object = ((AndroidFileHandle)object).getAssetFileDescriptor();
                object2.setDataSource(object.getFileDescriptor(), object.getStartOffset(), object.getLength());
                object.close();
                object2.prepare();
                object = new AndroidMusic(this, (MediaPlayer)object2);
                object2 = this.musics;
                synchronized (object2) {
                    this.musics.add((AndroidMusic)object);
                }
            }
            catch (Exception exception) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Error loading audio file: ");
                ((StringBuilder)object).append(fileHandle);
                ((StringBuilder)object).append("\nNote: Internal audio files must be placed in the assets directory.");
                throw new GdxRuntimeException(((StringBuilder)object).toString(), exception);
            }
            return object;
        }
        try {
            object2.setDataSource(((AndroidFileHandle)object).file().getPath());
            object2.prepare();
            object = new AndroidMusic(this, (MediaPlayer)object2);
            object2 = this.musics;
            synchronized (object2) {
                this.musics.add((AndroidMusic)object);
            }
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Error loading audio file: ");
            ((StringBuilder)object).append(fileHandle);
            throw new GdxRuntimeException(((StringBuilder)object).toString(), exception);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Music newMusic(FileDescriptor object) {
        AndroidMusic androidMusic;
        if (this.soundPool == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            mediaPlayer.setDataSource((FileDescriptor)object);
            mediaPlayer.prepare();
            androidMusic = new AndroidMusic(this, mediaPlayer);
            object = this.musics;
            synchronized (object) {
                this.musics.add(androidMusic);
            }
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error loading audio from FileDescriptor", exception);
        }
        return androidMusic;
    }

    @Override
    public Sound newSound(FileHandle fileHandle) {
        if (this.soundPool != null) {
            Object object = (AndroidFileHandle)fileHandle;
            if (((FileHandle)object).type() == Files.FileType.Internal) {
                try {
                    object = ((AndroidFileHandle)object).getAssetFileDescriptor();
                    AndroidSound androidSound = new AndroidSound(this.soundPool, this.manager, this.soundPool.load((AssetFileDescriptor)object, 1));
                    object.close();
                    return androidSound;
                }
                catch (IOException iOException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Error loading audio file: ");
                    stringBuilder.append(fileHandle);
                    stringBuilder.append("\nNote: Internal audio files must be placed in the assets directory.");
                    throw new GdxRuntimeException(stringBuilder.toString(), iOException);
                }
            }
            try {
                object = new AndroidSound(this.soundPool, this.manager, this.soundPool.load(((AndroidFileHandle)object).file().getPath(), 1));
                return object;
            }
            catch (Exception exception) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Error loading audio file: ");
                ((StringBuilder)object).append(fileHandle);
                throw new GdxRuntimeException(((StringBuilder)object).toString(), exception);
            }
        }
        throw new GdxRuntimeException("Android audio is not enabled by the application config.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pause() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            for (AndroidMusic androidMusic : this.musics) {
                if (androidMusic.isPlaying()) {
                    androidMusic.pause();
                    androidMusic.wasPlaying = true;
                    continue;
                }
                androidMusic.wasPlaying = false;
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        this.soundPool.autoPause();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void resume() {
        if (this.soundPool == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        // MONITORENTER : list
        for (int i = 0; i < this.musics.size(); ++i) {
            if (!this.musics.get((int)i).wasPlaying) continue;
            this.musics.get(i).play();
        }
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : list
                throw throwable;
            }
        }
        this.soundPool.autoResume();
    }
}

