/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.utils.Array;

public class TextureLoader
extends AsynchronousAssetLoader<Texture, TextureParameter> {
    TextureLoaderInfo info = new TextureLoaderInfo();

    public TextureLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String string2, FileHandle fileHandle, TextureParameter textureParameter) {
        return null;
    }

    @Override
    public void loadAsync(AssetManager object, String object2, FileHandle fileHandle, TextureParameter textureParameter) {
        this.info.filename = object2;
        if (textureParameter != null && textureParameter.textureData != null) {
            this.info.data = textureParameter.textureData;
            this.info.texture = textureParameter.texture;
        } else {
            boolean bl = false;
            object2 = this.info;
            object = null;
            ((TextureLoaderInfo)object2).texture = null;
            if (textureParameter != null) {
                object = textureParameter.format;
                bl = textureParameter.genMipMaps;
                this.info.texture = textureParameter.texture;
            }
            this.info.data = TextureData.Factory.loadFromFile(fileHandle, (Pixmap.Format)((Object)object), bl);
        }
        if (!this.info.data.isPrepared()) {
            this.info.data.prepare();
        }
    }

    @Override
    public Texture loadSync(AssetManager object, String string2, FileHandle fileHandle, TextureParameter textureParameter) {
        object = this.info;
        if (object == null) {
            return null;
        }
        object = ((TextureLoaderInfo)object).texture;
        if (object != null) {
            ((Texture)object).load(this.info.data);
        } else {
            object = new Texture(this.info.data);
        }
        if (textureParameter != null) {
            ((GLTexture)object).setFilter(textureParameter.minFilter, textureParameter.magFilter);
            ((GLTexture)object).setWrap(textureParameter.wrapU, textureParameter.wrapV);
        }
        return object;
    }

    public static class TextureLoaderInfo {
        TextureData data;
        String filename;
        Texture texture;
    }

    public static class TextureParameter
    extends AssetLoaderParameters<Texture> {
        public Pixmap.Format format = null;
        public boolean genMipMaps = false;
        public Texture.TextureFilter magFilter;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public Texture texture = null;
        public TextureData textureData = null;
        public Texture.TextureWrap wrapU;
        public Texture.TextureWrap wrapV;

        public TextureParameter() {
            this.magFilter = Texture.TextureFilter.Nearest;
            this.wrapU = Texture.TextureWrap.ClampToEdge;
            this.wrapV = Texture.TextureWrap.ClampToEdge;
        }
    }
}

