/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class BitmapFontLoader
extends AsynchronousAssetLoader<BitmapFont, BitmapFontParameter> {
    BitmapFont.BitmapFontData data;

    public BitmapFontLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Array<AssetDescriptor> getDependencies(String array, FileHandle fileHandle, BitmapFontParameter bitmapFontParameter) {
        array = new Array();
        if (bitmapFontParameter != null && bitmapFontParameter.bitmapFontData != null) {
            this.data = bitmapFontParameter.bitmapFontData;
            return array;
        }
        int n = 0;
        boolean bl = bitmapFontParameter != null && bitmapFontParameter.flip;
        this.data = new BitmapFont.BitmapFontData(fileHandle, bl);
        int n2 = n;
        if (bitmapFontParameter != null) {
            n2 = n;
            if (bitmapFontParameter.atlasName != null) {
                array.add(new AssetDescriptor<TextureAtlas>(bitmapFontParameter.atlasName, TextureAtlas.class));
                return array;
            }
        }
        while (n2 < this.data.getImagePaths().length) {
            fileHandle = this.resolve(this.data.getImagePath(n2));
            TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
            if (bitmapFontParameter != null) {
                textureParameter.genMipMaps = bitmapFontParameter.genMipMaps;
                textureParameter.minFilter = bitmapFontParameter.minFilter;
                textureParameter.magFilter = bitmapFontParameter.magFilter;
            }
            array.add(new AssetDescriptor<Texture>(fileHandle, Texture.class, textureParameter));
            ++n2;
        }
        return array;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string2, FileHandle fileHandle, BitmapFontParameter bitmapFontParameter) {
    }

    @Override
    public BitmapFont loadSync(AssetManager object, String object2, FileHandle fileHandle, BitmapFontParameter bitmapFontParameter) {
        if (bitmapFontParameter != null && bitmapFontParameter.atlasName != null) {
            object2 = ((AssetManager)object).get(bitmapFontParameter.atlasName, TextureAtlas.class);
            object = fileHandle.sibling(this.data.imagePaths[0]).nameWithoutExtension().toString();
            if ((object2 = ((TextureAtlas)object2).findRegion((String)object)) != null) {
                return new BitmapFont(fileHandle, (TextureRegion)object2);
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Could not find font region ");
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append(" in atlas ");
            ((StringBuilder)object2).append(bitmapFontParameter.atlasName);
            throw new GdxRuntimeException(((StringBuilder)object2).toString());
        }
        int n = this.data.getImagePaths().length;
        object2 = new Array<TextureRegion>(n);
        for (int i = 0; i < n; ++i) {
            ((Array)object2).add((TextureRegion)new TextureRegion(((AssetManager)object).get(this.data.getImagePath(i), Texture.class)));
        }
        return new BitmapFont(this.data, (Array<TextureRegion>)object2, true);
    }

    public static class BitmapFontParameter
    extends AssetLoaderParameters<BitmapFont> {
        public String atlasName = null;
        public BitmapFont.BitmapFontData bitmapFontData = null;
        public boolean flip = false;
        public boolean genMipMaps = false;
        public Texture.TextureFilter magFilter;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;

        public BitmapFontParameter() {
            this.magFilter = Texture.TextureFilter.Nearest;
        }
    }
}

