/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.rangecoder;

import com.badlogic.gdx.utils.compression.rangecoder.Decoder;
import com.badlogic.gdx.utils.compression.rangecoder.Encoder;
import java.io.IOException;

public class BitTreeEncoder {
    short[] Models;
    int NumBitLevels;

    public BitTreeEncoder(int n) {
        this.NumBitLevels = n;
        this.Models = new short[1 << n];
    }

    public static void ReverseEncode(short[] sArray, int n, Encoder encoder, int n2, int n3) throws IOException {
        int n4 = 1;
        for (int i = 0; i < n2; ++i) {
            int n5 = n3 & 1;
            encoder.Encode(sArray, n + n4, n5);
            n4 = n4 << 1 | n5;
            n3 >>= 1;
        }
    }

    public static int ReverseGetPrice(short[] sArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 1;
        int n6 = n3;
        n3 = n5;
        while (n2 != 0) {
            n5 = n6 & 1;
            n6 >>>= 1;
            n4 += Encoder.GetPrice(sArray[n + n3], n5);
            n3 = n3 << 1 | n5;
            --n2;
        }
        return n4;
    }

    public void Encode(Encoder encoder, int n) throws IOException {
        int n2 = this.NumBitLevels;
        int n3 = 1;
        while (n2 != 0) {
            int n4 = n >>> --n2 & 1;
            encoder.Encode(this.Models, n3, n4);
            n3 = n3 << 1 | n4;
        }
    }

    public int GetPrice(int n) {
        int n2 = this.NumBitLevels;
        int n3 = 0;
        int n4 = 1;
        while (n2 != 0) {
            int n5 = n >>> --n2 & 1;
            n3 += Encoder.GetPrice(this.Models[n4], n5);
            n4 = (n4 << 1) + n5;
        }
        return n3;
    }

    public void Init() {
        Decoder.InitBitModels(this.Models);
    }

    public void ReverseEncode(Encoder encoder, int n) throws IOException {
        int n2 = 1;
        for (int i = 0; i < this.NumBitLevels; ++i) {
            int n3 = n & 1;
            encoder.Encode(this.Models, n2, n3);
            n2 = n2 << 1 | n3;
            n >>= 1;
        }
    }

    public int ReverseGetPrice(int n) {
        int n2 = 0;
        int n3 = 1;
        int n4 = n;
        n = n3;
        for (int i = this.NumBitLevels; i != 0; --i) {
            n3 = n4 & 1;
            n4 >>>= 1;
            n2 += Encoder.GetPrice(this.Models[n], n3);
            n = n << 1 | n3;
        }
        return n2;
    }
}

