/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.async;

import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.async.AsyncResult;
import com.badlogic.gdx.utils.async.AsyncTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AsyncExecutor
implements Disposable {
    private final ExecutorService executor;

    public AsyncExecutor(int n) {
        this(n, "AsynchExecutor-Thread");
    }

    public AsyncExecutor(int n, final String string2) {
        this.executor = Executors.newFixedThreadPool(n, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable, string2);
                ((Thread)runnable).setDaemon(true);
                return runnable;
            }
        });
    }

    @Override
    public void dispose() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new GdxRuntimeException("Couldn't shutdown loading thread", interruptedException);
        }
    }

    public <T> AsyncResult<T> submit(final AsyncTask<T> asyncTask) {
        if (!this.executor.isShutdown()) {
            return new AsyncResult(this.executor.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return asyncTask.call();
                }
            }));
        }
        throw new GdxRuntimeException("Cannot run tasks on an executor that has been shutdown (disposed)");
    }
}

