/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class ShortArray {
    public short[] items;
    public boolean ordered;
    public int size;

    public ShortArray() {
        this(true, 16);
    }

    public ShortArray(int n) {
        this(true, n);
    }

    public ShortArray(ShortArray shortArray) {
        this.ordered = shortArray.ordered;
        int n = this.size = shortArray.size;
        this.items = new short[n];
        System.arraycopy(shortArray.items, 0, this.items, 0, n);
    }

    public ShortArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new short[n];
    }

    public ShortArray(boolean bl, short[] sArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(sArray, n, this.items, 0, n2);
    }

    public ShortArray(short[] sArray) {
        this(true, sArray, 0, sArray.length);
    }

    public static ShortArray with(short ... sArray) {
        return new ShortArray(sArray);
    }

    public void add(int n) {
        short[] sArray = this.items;
        int n2 = this.size;
        short[] sArray2 = sArray;
        if (n2 == sArray.length) {
            sArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
        }
        n2 = this.size;
        this.size = n2 + 1;
        sArray2[n2] = (short)n;
    }

    public void add(short s) {
        short[] sArray = this.items;
        int n = this.size;
        short[] sArray2 = sArray;
        if (n == sArray.length) {
            sArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        this.size = n + 1;
        sArray2[n] = s;
    }

    public void add(short s, short s2) {
        short[] sArray = this.items;
        int n = this.size;
        short[] sArray2 = sArray;
        if (n + 1 >= sArray.length) {
            sArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        sArray2[n] = s;
        sArray2[n + 1] = s2;
        this.size = n + 2;
    }

    public void add(short s, short s2, short s3) {
        short[] sArray = this.items;
        int n = this.size;
        short[] sArray2 = sArray;
        if (n + 2 >= sArray.length) {
            sArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        sArray2[n] = s;
        sArray2[n + 1] = s2;
        sArray2[n + 2] = s3;
        this.size = n + 3;
    }

    public void add(short s, short s2, short s3, short s4) {
        short[] sArray = this.items;
        int n = this.size;
        short[] sArray2 = sArray;
        if (n + 3 >= sArray.length) {
            sArray2 = this.resize(Math.max(8, (int)((float)n * 1.8f)));
        }
        n = this.size;
        sArray2[n] = s;
        sArray2[n + 1] = s2;
        sArray2[n + 2] = s3;
        sArray2[n + 3] = s4;
        this.size = n + 4;
    }

    public void addAll(ShortArray shortArray) {
        this.addAll(shortArray.items, 0, shortArray.size);
    }

    public void addAll(ShortArray shortArray, int n, int n2) {
        if (n + n2 <= shortArray.size) {
            this.addAll(shortArray.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(shortArray.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(short ... sArray) {
        this.addAll(sArray, 0, sArray.length);
    }

    public void addAll(short[] sArray, int n, int n2) {
        short[] sArray2 = this.items;
        int n3 = this.size + n2;
        short[] sArray3 = sArray2;
        if (n3 > sArray2.length) {
            sArray3 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(sArray, n, sArray3, this.size, n2);
        this.size += n2;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(short s) {
        short[] sArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (sArray[i] != s) continue;
            return true;
        }
        return false;
    }

    public short[] ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) > this.items.length) {
                this.resize(Math.max(8, n));
            }
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof ShortArray)) {
            return false;
        }
        Object object2 = (ShortArray)object;
        if (!((ShortArray)object2).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((ShortArray)object2).size) {
            return false;
        }
        object = this.items;
        object2 = ((ShortArray)object2).items;
        for (int i = 0; i < n; ++i) {
            if (object[i] == object2[i]) continue;
            return false;
        }
        return true;
    }

    public short first() {
        if (this.size != 0) {
            return this.items[0];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public short get(int n) {
        if (n < this.size) {
            return this.items[n];
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        short[] sArray = this.items;
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + sArray[i];
        }
        return n2;
    }

    public void incr(int n, short s) {
        if (n < this.size) {
            short[] sArray = this.items;
            sArray[n] = (short)(sArray[n] + s);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int indexOf(short s) {
        short[] sArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (sArray[i] != s) continue;
            return i;
        }
        return -1;
    }

    public void insert(int n, short s) {
        int n2 = this.size;
        if (n <= n2) {
            short[] sArray;
            short[] sArray2 = sArray = this.items;
            if (n2 == sArray.length) {
                sArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            if (this.ordered) {
                System.arraycopy(sArray2, n, sArray2, n + 1, this.size - n);
            } else {
                sArray2[this.size] = sArray2[n];
            }
            ++this.size;
            sArray2[n] = s;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be > size: ");
        stringBuilder.append(n);
        stringBuilder.append(" > ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public int lastIndexOf(char c) {
        short[] sArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (sArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public void mul(int n, short s) {
        if (n < this.size) {
            short[] sArray = this.items;
            sArray[n] = (short)(sArray[n] * s);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public short peek() {
        return this.items[this.size - 1];
    }

    public short pop() {
        int n;
        short[] sArray = this.items;
        this.size = n = this.size - 1;
        return sArray[n];
    }

    public short random() {
        int n = this.size;
        if (n == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, n - 1)];
    }

    public boolean removeAll(ShortArray shortArray) {
        int n = this.size;
        short[] sArray = this.items;
        int n2 = shortArray.size;
        boolean bl = false;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            short s = shortArray.get(i);
            int n5 = 0;
            while (true) {
                n4 = n3;
                if (n5 >= n3) break;
                if (s == sArray[n5]) {
                    this.removeIndex(n5);
                    n4 = n3 - 1;
                    break;
                }
                ++n5;
            }
            n3 = n4;
        }
        if (n3 != n) {
            bl = true;
        }
        return bl;
    }

    public short removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            short[] sArray = this.items;
            short s = sArray[n];
            this.size = n2 - 1;
            if (this.ordered) {
                System.arraycopy(sArray, n + 1, sArray, n, this.size - n);
            } else {
                sArray[n] = sArray[this.size];
            }
            return s;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n2 < n3) {
            if (n <= n2) {
                int n4 = n2 - n + 1;
                int n5 = n3 - n4;
                if (this.ordered) {
                    short[] sArray = this.items;
                    n2 = n4 + n;
                    System.arraycopy(sArray, n2, sArray, n, n3 - n2);
                } else {
                    n2 = Math.max(n5, n2 + 1);
                    short[] sArray = this.items;
                    System.arraycopy(sArray, n2, sArray, n, n3 - n2);
                }
                this.size = n5;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("start can't be > end: ");
            stringBuilder.append(n);
            stringBuilder.append(" > ");
            stringBuilder.append(n2);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("end can't be >= size: ");
        stringBuilder.append(n2);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean removeValue(short s) {
        short[] sArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (sArray[i] != s) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    protected short[] resize(int n) {
        short[] sArray = new short[n];
        System.arraycopy(this.items, 0, sArray, 0, Math.min(this.size, sArray.length));
        this.items = sArray;
        return sArray;
    }

    public void reverse() {
        short[] sArray = this.items;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            short s = sArray[i];
            sArray[i] = sArray[n3];
            sArray[n3] = s;
        }
    }

    public void set(int n, short s) {
        if (n < this.size) {
            this.items[n] = s;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public short[] setSize(int n) {
        if (n >= 0) {
            if (n > this.items.length) {
                this.resize(Math.max(8, n));
            }
            this.size = n;
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("newSize must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public short[] shrink() {
        int n = this.items.length;
        int n2 = this.size;
        if (n != n2) {
            this.resize(n2);
        }
        return this.items;
    }

    public void shuffle() {
        short[] sArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            short s = sArray[i];
            sArray[i] = sArray[n];
            sArray[n] = s;
        }
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void swap(int n, int n2) {
        int n3 = this.size;
        if (n < n3) {
            if (n2 < n3) {
                short[] sArray = this.items;
                n3 = sArray[n];
                sArray[n] = sArray[n2];
                sArray[n2] = (short)n3;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("second can't be >= size: ");
            stringBuilder.append(n2);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("first can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public short[] toArray() {
        int n = this.size;
        short[] sArray = new short[n];
        System.arraycopy(this.items, 0, sArray, 0, n);
        return sArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        short[] sArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(sArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(sArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        if (this.size == 0) {
            return "";
        }
        short[] sArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(sArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(sArray[i]);
        }
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }
}

