/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Pool;

public class PooledLinkedList<T> {
    private Item<T> curr;
    private Item<T> head;
    private Item<T> iter;
    private final Pool<Item<T>> pool;
    private int size = 0;
    private Item<T> tail;

    public PooledLinkedList(int n) {
        this.pool = new Pool<Item<T>>(16, n){

            @Override
            protected Item<T> newObject() {
                return new Item();
            }
        };
    }

    public void add(T object) {
        Item<T> item = this.pool.obtain();
        item.payload = object;
        item.next = null;
        item.prev = null;
        if (this.head == null) {
            this.head = item;
            this.tail = item;
            ++this.size;
            return;
        }
        object = this.tail;
        item.prev = object;
        ((Item)object).next = item;
        this.tail = item;
        ++this.size;
    }

    public void addFirst(T object) {
        Item<T> item = this.pool.obtain();
        item.payload = object;
        object = this.head;
        item.next = object;
        item.prev = null;
        if (object != null) {
            ((Item)object).prev = item;
        } else {
            this.tail = item;
        }
        this.head = item;
        ++this.size;
    }

    public void clear() {
        this.iter();
        while (this.next() != null) {
            this.remove();
        }
    }

    public void iter() {
        this.iter = this.head;
    }

    public void iterReverse() {
        this.iter = this.tail;
    }

    public T next() {
        Item<T> item = this.iter;
        if (item == null) {
            return null;
        }
        Object t = item.payload;
        item = this.iter;
        this.curr = item;
        this.iter = item.next;
        return t;
    }

    public T previous() {
        Item<T> item = this.iter;
        if (item == null) {
            return null;
        }
        item = item.payload;
        Item<T> item2 = this.iter;
        this.curr = item2;
        this.iter = item2.prev;
        return (T)item;
    }

    public void remove() {
        Item<T> item = this.curr;
        if (item == null) {
            return;
        }
        --this.size;
        Item item2 = item.next;
        Item item3 = this.curr.prev;
        this.pool.free(this.curr);
        this.curr = null;
        if (this.size == 0) {
            this.head = null;
            this.tail = null;
            return;
        }
        if (item == this.head) {
            item2.prev = null;
            this.head = item2;
            return;
        }
        if (item == this.tail) {
            item3.next = null;
            this.tail = item3;
            return;
        }
        item3.next = item2;
        item2.prev = item3;
    }

    public T removeLast() {
        Item<T> item = this.tail;
        if (item == null) {
            return null;
        }
        Object t = item.payload;
        --this.size;
        item = this.tail.prev;
        this.pool.free(this.tail);
        if (this.size == 0) {
            this.head = null;
            this.tail = null;
        } else {
            this.tail = item;
            this.tail.next = null;
        }
        return t;
    }

    public int size() {
        return this.size;
    }

    static final class Item<T> {
        public Item<T> next;
        public T payload;
        public Item<T> prev;

        Item() {
        }
    }
}

