/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class JsonWriter
extends Writer {
    private JsonObject current;
    private boolean named;
    private OutputType outputType;
    private boolean quoteLongValues = false;
    private final Array<JsonObject> stack = new Array();
    final Writer writer;

    public JsonWriter(Writer writer) {
        this.outputType = OutputType.json;
        this.writer = writer;
    }

    private void requireCommaOrName() throws IOException {
        block8: {
            block7: {
                block6: {
                    JsonObject jsonObject = this.current;
                    if (jsonObject == null) {
                        return;
                    }
                    if (!jsonObject.array) break block6;
                    if (!this.current.needsComma) {
                        this.current.needsComma = true;
                    } else {
                        this.writer.write(44);
                    }
                    break block7;
                }
                if (!this.named) break block8;
                this.named = false;
            }
            return;
        }
        throw new IllegalStateException("Name must be set.");
    }

    public JsonWriter array() throws IOException {
        JsonObject jsonObject;
        this.requireCommaOrName();
        Array<JsonObject> array = this.stack;
        this.current = jsonObject = new JsonObject(true);
        array.add(jsonObject);
        return this;
    }

    public JsonWriter array(String string2) throws IOException {
        return this.name(string2).array();
    }

    @Override
    public void close() throws IOException {
        while (this.stack.size > 0) {
            this.pop();
        }
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public JsonWriter json(String string2) throws IOException {
        this.requireCommaOrName();
        this.writer.write(string2);
        return this;
    }

    public JsonWriter json(String string2, String string3) throws IOException {
        return this.name(string2).json(string3);
    }

    public JsonWriter name(String string2) throws IOException {
        JsonObject jsonObject = this.current;
        if (jsonObject != null && !jsonObject.array) {
            if (!this.current.needsComma) {
                this.current.needsComma = true;
            } else {
                this.writer.write(44);
            }
            this.writer.write(this.outputType.quoteName(string2));
            this.writer.write(58);
            this.named = true;
            return this;
        }
        throw new IllegalStateException("Current item must be an object.");
    }

    public JsonWriter object() throws IOException {
        JsonObject jsonObject;
        this.requireCommaOrName();
        Array<JsonObject> array = this.stack;
        this.current = jsonObject = new JsonObject(false);
        array.add(jsonObject);
        return this;
    }

    public JsonWriter object(String string2) throws IOException {
        return this.name(string2).object();
    }

    public JsonWriter pop() throws IOException {
        if (!this.named) {
            this.stack.pop().close();
            JsonObject jsonObject = this.stack.size == 0 ? null : this.stack.peek();
            this.current = jsonObject;
            return this;
        }
        throw new IllegalStateException("Expected an object, array, or value since a name was set.");
    }

    public JsonWriter set(String string2, Object object) throws IOException {
        return this.name(string2).value(object);
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public void setQuoteLongValues(boolean bl) {
        this.quoteLongValues = bl;
    }

    public JsonWriter value(Object object) throws IOException {
        Object object2;
        if (this.quoteLongValues && (object instanceof Long || object instanceof Double || object instanceof BigDecimal || object instanceof BigInteger)) {
            object2 = object.toString();
        } else {
            object2 = object;
            if (object instanceof Number) {
                Number number = (Number)object;
                long l = number.longValue();
                object2 = object;
                if (number.doubleValue() == (double)l) {
                    object2 = l;
                }
            }
        }
        this.requireCommaOrName();
        this.writer.write(this.outputType.quoteValue(object2));
        return this;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.writer.write(cArray, n, n2);
    }

    private class JsonObject {
        final boolean array;
        boolean needsComma;

        JsonObject(boolean bl) throws IOException {
            this.array = bl;
            JsonWriter.this = ((JsonWriter)JsonWriter.this).writer;
            int n = bl ? 91 : 123;
            JsonWriter.this.write(n);
        }

        void close() throws IOException {
            Writer writer = JsonWriter.this.writer;
            int n = this.array ? 93 : 125;
            writer.write(n);
        }
    }

    public static enum OutputType {
        json,
        javascript,
        minimal;

        private static Pattern javascriptPattern;
        private static Pattern minimalNamePattern;
        private static Pattern minimalValuePattern;

        static {
            javascriptPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
            minimalNamePattern = Pattern.compile("^[^\":,}/ ][^:]*$");
            minimalValuePattern = Pattern.compile("^[^\":,{\\[\\]/ ][^}\\],]*$");
        }

        public String quoteName(String charSequence) {
            StringBuilder stringBuilder;
            block4: {
                block3: {
                    block2: {
                        stringBuilder = new StringBuilder((String)charSequence);
                        stringBuilder.replace('\\', "\\\\").replace('\r', "\\r").replace('\n', "\\n").replace('\t', "\\t");
                        int n = 1.$SwitchMap$com$badlogic$gdx$utils$JsonWriter$OutputType[this.ordinal()];
                        if (n == 1) break block2;
                        if (n == 2) break block3;
                        break block4;
                    }
                    if (!((String)charSequence).contains("//") && !((String)charSequence).contains("/*") && minimalNamePattern.matcher(stringBuilder).matches()) {
                        return stringBuilder.toString();
                    }
                }
                if (javascriptPattern.matcher(stringBuilder).matches()) {
                    return stringBuilder.toString();
                }
            }
            charSequence = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)charSequence).append('\"');
            ((java.lang.StringBuilder)charSequence).append(stringBuilder.replace('\"', "\\\"").toString());
            ((java.lang.StringBuilder)charSequence).append('\"');
            return ((java.lang.StringBuilder)charSequence).toString();
        }

        public String quoteValue(Object object) {
            if (object == null) {
                return "null";
            }
            CharSequence charSequence = object.toString();
            if (!(object instanceof Number) && !(object instanceof Boolean)) {
                int n;
                object = new StringBuilder((String)charSequence);
                ((StringBuilder)object).replace('\\', "\\\\").replace('\r', "\\r").replace('\n', "\\n").replace('\t', "\\t");
                if (!(this != minimal || ((String)charSequence).equals("true") || ((String)charSequence).equals("false") || ((String)charSequence).equals("null") || ((String)charSequence).contains("//") || ((String)charSequence).contains("/*") || (n = ((StringBuilder)object).length()) <= 0 || ((StringBuilder)object).charAt(n - 1) == ' ' || !minimalValuePattern.matcher((CharSequence)object).matches())) {
                    return ((StringBuilder)object).toString();
                }
                charSequence = new java.lang.StringBuilder();
                ((java.lang.StringBuilder)charSequence).append('\"');
                ((java.lang.StringBuilder)charSequence).append(((StringBuilder)object).replace('\"', "\\\"").toString());
                ((java.lang.StringBuilder)charSequence).append('\"');
                return ((java.lang.StringBuilder)charSequence).toString();
            }
            return charSequence;
        }
    }
}

