/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IdentityMap<K, V>
implements Iterable<ObjectMap.Entry<K, V>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    private Entries entries1;
    private Entries entries2;
    private int hashShift;
    K[] keyTable;
    private Keys keys1;
    private Keys keys2;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;
    V[] valueTable;
    private Values values1;
    private Values values2;

    public IdentityMap() {
        this(51, 0.8f);
    }

    public IdentityMap(int n) {
        this(n, 0.8f);
    }

    public IdentityMap(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new Object[this.capacity + this.stashCapacity];
                    this.valueTable = new Object[this.keyTable.length];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public IdentityMap(IdentityMap identityMap) {
        this((int)Math.floor((float)identityMap.capacity * identityMap.loadFactor), identityMap.loadFactor);
        this.stashSize = identityMap.stashSize;
        Object[] objectArray = identityMap.keyTable;
        System.arraycopy(objectArray, 0, this.keyTable, 0, objectArray.length);
        objectArray = identityMap.valueTable;
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        this.size = identityMap.size;
    }

    private boolean containsKeyStash(K k) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (KArray[i] != k) continue;
            return true;
        }
        return false;
    }

    private V getStash(K k, V v) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (KArray[i] != k) continue;
            return this.valueTable[i];
        }
        return v;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(K k, V v, int n, K k2, int n2, K k3, int n3, K k4) {
        int n4;
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n5 = this.mask;
        int n6 = this.pushIterations;
        int n7 = n;
        n = 0;
        V v2 = v;
        K k5 = k;
        do {
            if ((n4 = MathUtils.random(2)) != 0) {
                if (n4 != 1) {
                    v = VArray[n3];
                    KArray[n3] = k5;
                    VArray[n3] = v2;
                    k = k4;
                } else {
                    v = VArray[n2];
                    KArray[n2] = k5;
                    VArray[n2] = v2;
                    k = k3;
                }
            } else {
                v = VArray[n7];
                KArray[n7] = k5;
                VArray[n7] = v2;
                k = k2;
            }
            n3 = System.identityHashCode(k);
            n7 = n3 & n5;
            k2 = KArray[n7];
            if (k2 == null) {
                KArray[n7] = k;
                VArray[n7] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = this.hash2(n3);
            k3 = KArray[n2];
            if (k3 == null) {
                KArray[n2] = k;
                VArray[n2] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            k4 = KArray[n3 = this.hash3(n3)];
            if (k4 == null) {
                KArray[n3] = k;
                VArray[n3] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = n + 1;
            k5 = k;
            v2 = v;
            n = n4;
        } while (n4 != n6);
        this.putStash(k, v);
    }

    private void putResize(K k, V v) {
        Object object = this.keyTable;
        int n = System.identityHashCode(k);
        int n2 = n & this.mask;
        K k2 = object[n2];
        if (k2 == null) {
            object[n2] = k;
            this.valueTable[n2] = v;
            int n3 = this.size;
            this.size = n3 + 1;
            if (n3 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        Object object2 = this.keyTable;
        int n4 = this.hash2(n);
        object = object2[n4];
        if (object == null) {
            object2[n4] = k;
            this.valueTable[n4] = v;
            n4 = this.size;
            this.size = n4 + 1;
            if (n4 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        K[] KArray = this.keyTable;
        object2 = KArray[n = this.hash3(n)];
        if (object2 == null) {
            KArray[n] = k;
            this.valueTable[n] = v;
            n4 = this.size;
            this.size = n4 + 1;
            if (n4 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, v, n2, k2, n4, object, n, object2);
    }

    private void putStash(K k, V v) {
        int n = this.stashSize;
        if (n == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.putResize(k, v);
            return;
        }
        int n2 = this.capacity + n;
        this.keyTable[n2] = k;
        this.valueTable[n2] = v;
        this.stashSize = n + 1;
        ++this.size;
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n4 = this.stashCapacity;
        this.keyTable = new Object[n + n4];
        this.valueTable = new Object[n + n4];
        n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                K k = KArray[n];
                if (k == null) continue;
                this.putResize(k, VArray[n]);
            }
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            KArray[n2] = null;
            VArray[n2] = null;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(K k) {
        int n = this.mask;
        int n2 = System.identityHashCode(k);
        if (k != this.keyTable[n & n2] && k != this.keyTable[n = this.hash2(n2)] && k != this.keyTable[n2 = this.hash3(n2)]) {
            return this.containsKeyStash(k);
        }
        return true;
    }

    public boolean containsValue(Object KArray, boolean bl) {
        V[] VArray = this.valueTable;
        if (KArray == null) {
            KArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (true) {
                int n2 = n - 1;
                if (n > 0) {
                    if (KArray[n2] != null && VArray[n2] == null) {
                        return true;
                    }
                    n = n2;
                    continue;
                }
                break;
            }
        } else if (bl) {
            int n = this.capacity + this.stashSize;
            while (true) {
                int n3 = n - 1;
                if (n > 0) {
                    if (VArray[n3] == KArray) {
                        return true;
                    }
                    n = n3;
                    continue;
                }
                break;
            }
        } else {
            int n = this.capacity + this.stashSize;
            while (true) {
                int n4 = n - 1;
                if (n <= 0) break;
                if (KArray.equals(VArray[n4])) {
                    return true;
                }
                n = n4;
            }
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries<K, V> entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            Entries entries = this.entries1;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        this.entries2.reset();
        Entries entries = this.entries2;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IdentityMap)) {
            return false;
        }
        IdentityMap identityMap = (IdentityMap)object;
        if (identityMap.size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            V v;
            object = KArray[i];
            if (object == null || !((v = VArray[i]) == null ? identityMap.get(object, ObjectMap.dummy) != null : !v.equals(identityMap.get(object)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object KArray) {
        if (KArray == this) {
            return true;
        }
        if (!(KArray instanceof IdentityMap)) {
            return false;
        }
        IdentityMap identityMap = (IdentityMap)KArray;
        if (identityMap.size != this.size) {
            return false;
        }
        KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            K k = KArray[i];
            if (k == null || VArray[i] == identityMap.get(k, ObjectMap.dummy)) continue;
            return false;
        }
        return true;
    }

    public K findKey(Object KArray, boolean bl) {
        V[] VArray = this.valueTable;
        if (KArray == null) {
            KArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (true) {
                int n2 = n - 1;
                if (n > 0) {
                    if (KArray[n2] != null && VArray[n2] == null) {
                        return KArray[n2];
                    }
                    n = n2;
                    continue;
                }
                break;
            }
        } else if (bl) {
            int n = this.capacity + this.stashSize;
            while (true) {
                int n3 = n - 1;
                if (n > 0) {
                    if (VArray[n3] == KArray) {
                        return this.keyTable[n3];
                    }
                    n = n3;
                    continue;
                }
                break;
            }
        } else {
            int n = this.capacity + this.stashSize;
            while (true) {
                int n4 = n - 1;
                if (n <= 0) break;
                if (KArray.equals(VArray[n4])) {
                    return this.keyTable[n4];
                }
                n = n4;
            }
        }
        return null;
    }

    public V get(K k) {
        int n;
        int n2 = System.identityHashCode(k);
        int n3 = n = this.mask & n2;
        if (k != this.keyTable[n]) {
            n3 = n = this.hash2(n2);
            if (k != this.keyTable[n]) {
                n3 = n = this.hash3(n2);
                if (k != this.keyTable[n]) {
                    return this.getStash(k, null);
                }
            }
        }
        return this.valueTable[n3];
    }

    public V get(K k, V v) {
        int n;
        int n2 = System.identityHashCode(k);
        int n3 = n = this.mask & n2;
        if (k != this.keyTable[n]) {
            n3 = n = this.hash2(n2);
            if (k != this.keyTable[n]) {
                n3 = n = this.hash3(n2);
                if (k != this.keyTable[n]) {
                    return this.getStash(k, v);
                }
            }
        }
        return this.valueTable[n3];
    }

    public int hashCode() {
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        int n3 = 0;
        for (int i = 0; i < n + n2; ++i) {
            Object object = KArray[i];
            int n4 = n3;
            if (object != null) {
                n3 += object.hashCode() * 31;
                object = VArray[i];
                n4 = n3;
                if (object != null) {
                    n4 = n3 + object.hashCode();
                }
            }
            n3 = n4;
        }
        return n3;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<ObjectMap.Entry<K, V>> iterator() {
        return this.entries();
    }

    public Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            Keys keys = this.keys1;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        this.keys2.reset();
        Keys keys = this.keys2;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public V put(K object, V v) {
        if (object != null) {
            K[] KArray = this.keyTable;
            int n = System.identityHashCode(object);
            int n2 = n & this.mask;
            K k = KArray[n2];
            if (k == object) {
                object = this.valueTable;
                K k2 = object[n2];
                object[n2] = v;
                return (V)k2;
            }
            int n3 = this.hash2(n);
            Object object2 = KArray[n3];
            if (object2 == object) {
                object2 = this.valueTable;
                object = object2[n3];
                object2[n3] = v;
                return (V)object;
            }
            int n4 = this.hash3(n);
            K k3 = KArray[n4];
            if (k3 == object) {
                object = this.valueTable;
                object2 = object[n4];
                object[n4] = v;
                return (V)object2;
            }
            int n5 = this.capacity;
            int n6 = this.stashSize;
            for (n = n5; n < n6 + n5; ++n) {
                if (KArray[n] != object) continue;
                object = this.valueTable;
                object2 = object[n];
                object[n] = v;
                return (V)object2;
            }
            if (k == null) {
                KArray[n2] = object;
                this.valueTable[n2] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return null;
            }
            if (object2 == null) {
                KArray[n3] = object;
                this.valueTable[n3] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return null;
            }
            if (k3 == null) {
                KArray[n4] = object;
                this.valueTable[n4] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return null;
            }
            this.push(object, v, n2, k, n3, object2, n4, k3);
            return null;
        }
        object = new IllegalArgumentException("key cannot be null.");
        throw object;
    }

    public V remove(K object) {
        Object object2 = this.keyTable;
        int n = System.identityHashCode(object);
        int n2 = this.mask & n;
        if (object2[n2] == object) {
            object2[n2] = null;
            object = this.valueTable;
            object2 = object[n2];
            object[n2] = null;
            --this.size;
            return (V)object2;
        }
        object2 = this.keyTable;
        n2 = this.hash2(n);
        if (object2[n2] == object) {
            object2[n2] = null;
            object2 = this.valueTable;
            object = object2[n2];
            object2[n2] = null;
            --this.size;
            return (V)object;
        }
        object2 = this.keyTable;
        if (object2[n = this.hash3(n)] == object) {
            object2[n] = null;
            object2 = this.valueTable;
            object = object2[n];
            object2[n] = null;
            --this.size;
            return (V)object;
        }
        return this.removeStash(object);
    }

    V removeStash(K object) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (KArray[i] != object) continue;
            object = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return (V)object;
        }
        return null;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            Object[] objectArray = this.keyTable;
            objectArray[n] = objectArray[n2];
            objectArray = this.valueTable;
            objectArray[n] = objectArray[n2];
            objectArray[n2] = null;
        } else {
            this.valueTable[n] = null;
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        K k;
        int n;
        int n2;
        V[] VArray;
        K[] KArray;
        StringBuilder stringBuilder;
        block4: {
            if (this.size == 0) {
                return "[]";
            }
            stringBuilder = new StringBuilder(32);
            stringBuilder.append('[');
            KArray = this.keyTable;
            VArray = this.valueTable;
            int n3 = KArray.length;
            while (true) {
                n = n2 = n3 - 1;
                if (n3 <= 0) break block4;
                k = KArray[n2];
                if (k != null) break;
                n3 = n2;
            }
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
            n = n2;
        }
        while (true) {
            n2 = n - 1;
            if (n <= 0) break;
            k = KArray[n2];
            if (k != null) {
                stringBuilder.append(", ");
                stringBuilder.append(k);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n2]);
            }
            n = n2;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Values<V> values() {
        if (Collections.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            Values values = this.values1;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        this.values2.reset();
        Values values = this.values2;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries<K, V>
    extends MapIterator<K, V, ObjectMap.Entry<K, V>> {
        private ObjectMap.Entry<K, V> entry = new ObjectMap.Entry();

        public Entries(IdentityMap<K, V> identityMap) {
            super(identityMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<ObjectMap.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public ObjectMap.Entry<K, V> next() {
            if (this.hasNext) {
                if (this.valid) {
                    K[] KArray = this.map.keyTable;
                    this.entry.key = KArray[this.nextIndex];
                    this.entry.value = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }
    }

    public static class Keys<K>
    extends MapIterator<K, Object, K> {
        public Keys(IdentityMap<K, ?> identityMap) {
            super(identityMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }

        @Override
        public K next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object k = this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return k;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public Array<K> toArray() {
            Array<K> array = new Array<K>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    private static abstract class MapIterator<K, V, I>
    implements Iterable<I>,
    Iterator<I> {
        int currentIndex;
        public boolean hasNext;
        final IdentityMap<K, V> map;
        int nextIndex;
        boolean valid = true;

        public MapIterator(IdentityMap<K, V> identityMap) {
            this.map = identityMap;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                K[] KArray = this.map.keyTable;
                int n = this.map.capacity;
                int n2 = this.map.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (KArray[this.nextIndex] == null);
                this.hasNext = true;
            }
        }

        @Override
        public void remove() {
            int n = this.currentIndex;
            if (n >= 0) {
                if (n >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = null;
                    this.map.valueTable[this.currentIndex] = null;
                }
                this.currentIndex = -1;
                IdentityMap<K, V> identityMap = this.map;
                --identityMap.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }
    }

    public static class Values<V>
    extends MapIterator<Object, V, V> {
        public Values(IdentityMap<?, V> identityMap) {
            super(identityMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public V next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object v = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return v;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public Array<V> toArray() {
            Array<V> array = new Array<V>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public void toArray(Array<V> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
        }
    }
}

