/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;

public class BooleanArray {
    public boolean[] items;
    public boolean ordered;
    public int size;

    public BooleanArray() {
        this(true, 16);
    }

    public BooleanArray(int n) {
        this(true, n);
    }

    public BooleanArray(BooleanArray booleanArray) {
        this.ordered = booleanArray.ordered;
        int n = this.size = booleanArray.size;
        this.items = new boolean[n];
        System.arraycopy(booleanArray.items, 0, this.items, 0, n);
    }

    public BooleanArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new boolean[n];
    }

    public BooleanArray(boolean bl, boolean[] blArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(blArray, n, this.items, 0, n2);
    }

    public BooleanArray(boolean[] blArray) {
        this(true, blArray, 0, blArray.length);
    }

    public static BooleanArray with(boolean ... blArray) {
        return new BooleanArray(blArray);
    }

    public void add(boolean bl) {
        boolean[] blArray = this.items;
        int n = this.size;
        boolean[] blArray2 = blArray;
        if (n == blArray.length) {
            blArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        this.size = n + 1;
        blArray2[n] = bl;
    }

    public void add(boolean bl, boolean bl2) {
        boolean[] blArray = this.items;
        int n = this.size;
        boolean[] blArray2 = blArray;
        if (n + 1 >= blArray.length) {
            blArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        blArray2[n] = bl;
        blArray2[n + 1] = bl2;
        this.size = n + 2;
    }

    public void add(boolean bl, boolean bl2, boolean bl3) {
        boolean[] blArray = this.items;
        int n = this.size;
        boolean[] blArray2 = blArray;
        if (n + 2 >= blArray.length) {
            blArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        blArray2[n] = bl;
        blArray2[n + 1] = bl2;
        blArray2[n + 2] = bl3;
        this.size = n + 3;
    }

    public void add(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean[] blArray = this.items;
        int n = this.size;
        boolean[] blArray2 = blArray;
        if (n + 3 >= blArray.length) {
            blArray2 = this.resize(Math.max(8, (int)((float)n * 1.8f)));
        }
        n = this.size;
        blArray2[n] = bl;
        blArray2[n + 1] = bl2;
        blArray2[n + 2] = bl3;
        blArray2[n + 3] = bl4;
        this.size = n + 4;
    }

    public void addAll(BooleanArray booleanArray) {
        this.addAll(booleanArray.items, 0, booleanArray.size);
    }

    public void addAll(BooleanArray booleanArray, int n, int n2) {
        if (n + n2 <= booleanArray.size) {
            this.addAll(booleanArray.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(booleanArray.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(boolean ... blArray) {
        this.addAll(blArray, 0, blArray.length);
    }

    public void addAll(boolean[] blArray, int n, int n2) {
        boolean[] blArray2 = this.items;
        int n3 = this.size + n2;
        boolean[] blArray3 = blArray2;
        if (n3 > blArray2.length) {
            blArray3 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(blArray, n, blArray3, this.size, n2);
        this.size += n2;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean[] ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) > this.items.length) {
                this.resize(Math.max(8, n));
            }
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof BooleanArray)) {
            return false;
        }
        Object object2 = (BooleanArray)object;
        if (!((BooleanArray)object2).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((BooleanArray)object2).size) {
            return false;
        }
        object = this.items;
        object2 = ((BooleanArray)object2).items;
        for (int i = 0; i < n; ++i) {
            if (object[i] == object2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean first() {
        if (this.size != 0) {
            return this.items[0];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public boolean get(int n) {
        if (n < this.size) {
            return this.items[n];
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        boolean[] blArray = this.items;
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = blArray[i] ? 1231 : 1237;
            n2 = n2 * 31 + n3;
        }
        return n2;
    }

    public void insert(int n, boolean bl) {
        int n2 = this.size;
        if (n <= n2) {
            boolean[] blArray;
            boolean[] blArray2 = blArray = this.items;
            if (n2 == blArray.length) {
                blArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            if (this.ordered) {
                System.arraycopy(blArray2, n, blArray2, n + 1, this.size - n);
            } else {
                blArray2[this.size] = blArray2[n];
            }
            ++this.size;
            blArray2[n] = bl;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be > size: ");
        stringBuilder.append(n);
        stringBuilder.append(" > ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public boolean peek() {
        return this.items[this.size - 1];
    }

    public boolean pop() {
        int n;
        boolean[] blArray = this.items;
        this.size = n = this.size - 1;
        return blArray[n];
    }

    public boolean random() {
        int n = this.size;
        if (n == 0) {
            return false;
        }
        return this.items[MathUtils.random(0, n - 1)];
    }

    public boolean removeAll(BooleanArray booleanArray) {
        int n = this.size;
        boolean[] blArray = this.items;
        int n2 = booleanArray.size;
        boolean bl = false;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            boolean bl2 = booleanArray.get(i);
            int n5 = 0;
            while (true) {
                n4 = n3;
                if (n5 >= n3) break;
                if (bl2 == blArray[n5]) {
                    this.removeIndex(n5);
                    n4 = n3 - 1;
                    break;
                }
                ++n5;
            }
            n3 = n4;
        }
        if (n3 != n) {
            bl = true;
        }
        return bl;
    }

    public boolean removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            boolean[] blArray = this.items;
            boolean bl = blArray[n];
            this.size = n2 - 1;
            if (this.ordered) {
                System.arraycopy(blArray, n + 1, blArray, n, this.size - n);
            } else {
                blArray[n] = blArray[this.size];
            }
            return bl;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n2 < n3) {
            if (n <= n2) {
                int n4 = n2 - n + 1;
                int n5 = n3 - n4;
                if (this.ordered) {
                    boolean[] blArray = this.items;
                    n2 = n4 + n;
                    System.arraycopy(blArray, n2, blArray, n, n3 - n2);
                } else {
                    n2 = Math.max(n5, n2 + 1);
                    boolean[] blArray = this.items;
                    System.arraycopy(blArray, n2, blArray, n, n3 - n2);
                }
                this.size = n5;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("start can't be > end: ");
            stringBuilder.append(n);
            stringBuilder.append(" > ");
            stringBuilder.append(n2);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("end can't be >= size: ");
        stringBuilder.append(n2);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    protected boolean[] resize(int n) {
        boolean[] blArray = new boolean[n];
        System.arraycopy(this.items, 0, blArray, 0, Math.min(this.size, blArray.length));
        this.items = blArray;
        return blArray;
    }

    public void reverse() {
        boolean[] blArray = this.items;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            boolean bl = blArray[i];
            blArray[i] = blArray[n3];
            blArray[n3] = bl;
        }
    }

    public void set(int n, boolean bl) {
        if (n < this.size) {
            this.items[n] = bl;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean[] setSize(int n) {
        if (n >= 0) {
            if (n > this.items.length) {
                this.resize(Math.max(8, n));
            }
            this.size = n;
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("newSize must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean[] shrink() {
        int n = this.items.length;
        int n2 = this.size;
        if (n != n2) {
            this.resize(n2);
        }
        return this.items;
    }

    public void shuffle() {
        boolean[] blArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            boolean bl = blArray[i];
            blArray[i] = blArray[n];
            blArray[n] = bl;
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.size;
        if (n < n3) {
            if (n2 < n3) {
                boolean[] blArray = this.items;
                boolean bl = blArray[n];
                blArray[n] = blArray[n2];
                blArray[n2] = bl;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("second can't be >= size: ");
            stringBuilder.append(n2);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("first can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean[] toArray() {
        int n = this.size;
        boolean[] blArray = new boolean[n];
        System.arraycopy(this.items, 0, blArray, 0, n);
        return blArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        boolean[] blArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(blArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(blArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        if (this.size == 0) {
            return "";
        }
        boolean[] blArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(blArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(blArray[i]);
        }
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }
}

