/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.ObjectMap;

public class Dialog
extends Window {
    Table buttonTable;
    boolean cancelHide;
    Table contentTable;
    FocusListener focusListener;
    protected InputListener ignoreTouchDown;
    Actor previousKeyboardFocus;
    Actor previousScrollFocus;
    private Skin skin;
    ObjectMap<Actor, Object> values = new ObjectMap();

    public Dialog(String string2, Skin skin) {
        super(string2, skin.get(Window.WindowStyle.class));
        this.ignoreTouchDown = new InputListener(){

            @Override
            public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                inputEvent.cancel();
                return false;
            }
        };
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public Dialog(String string2, Skin skin, String string3) {
        super(string2, skin.get(string3, Window.WindowStyle.class));
        this.ignoreTouchDown = new /* invalid duplicate definition of identical inner class */;
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public Dialog(String string2, Window.WindowStyle windowStyle) {
        super(string2, windowStyle);
        this.ignoreTouchDown = new /* invalid duplicate definition of identical inner class */;
        this.initialize();
    }

    private void initialize() {
        Table table;
        this.setModal(true);
        this.defaults().space(6.0f);
        this.contentTable = table = new Table(this.skin);
        this.add(table).expand().fill();
        this.row();
        this.buttonTable = table = new Table(this.skin);
        this.add(table).fillX();
        this.contentTable.defaults().space(6.0f);
        this.buttonTable.defaults().space(6.0f);
        this.buttonTable.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent object, Actor actor) {
                object = actor;
                if (!Dialog.this.values.containsKey(actor)) {
                    return;
                }
                while (((Actor)object).getParent() != Dialog.this.buttonTable) {
                    object = ((Actor)object).getParent();
                }
                actor = Dialog.this;
                ((Dialog)actor).result(((Dialog)actor).values.get((Actor)object));
                if (!Dialog.this.cancelHide) {
                    Dialog.this.hide();
                }
                Dialog.this.cancelHide = false;
            }
        });
        this.focusListener = new FocusListener(){

            private void focusChanged(FocusListener.FocusEvent focusEvent) {
                Object object = Dialog.this.getStage();
                if (Dialog.this.isModal && object != null && ((Stage)object).getRoot().getChildren().size > 0 && ((Stage)object).getRoot().getChildren().peek() == Dialog.this && (object = focusEvent.getRelatedActor()) != null && !((Actor)object).isDescendantOf(Dialog.this) && !object.equals(Dialog.this.previousKeyboardFocus) && !object.equals(Dialog.this.previousScrollFocus)) {
                    focusEvent.cancel();
                }
            }

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent focusEvent, Actor actor, boolean bl) {
                if (!bl) {
                    this.focusChanged(focusEvent);
                }
            }

            @Override
            public void scrollFocusChanged(FocusListener.FocusEvent focusEvent, Actor actor, boolean bl) {
                if (!bl) {
                    this.focusChanged(focusEvent);
                }
            }
        };
    }

    public Dialog button(Button button) {
        return this.button(button, null);
    }

    public Dialog button(Button button, Object object) {
        this.buttonTable.add(button);
        this.setObject(button, object);
        return this;
    }

    public Dialog button(String string2) {
        return this.button(string2, null);
    }

    public Dialog button(String string2, Object object) {
        Skin skin = this.skin;
        if (skin != null) {
            return this.button(string2, object, skin.get(TextButton.TextButtonStyle.class));
        }
        throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
    }

    public Dialog button(String string2, Object object, TextButton.TextButtonStyle textButtonStyle) {
        return this.button(new TextButton(string2, textButtonStyle), object);
    }

    public void cancel() {
        this.cancelHide = true;
    }

    public Table getButtonTable() {
        return this.buttonTable;
    }

    public Table getContentTable() {
        return this.contentTable;
    }

    public void hide() {
        this.hide(Actions.fadeOut(0.4f, Interpolation.fade));
    }

    public void hide(Action action) {
        Stage stage = this.getStage();
        if (stage != null) {
            this.removeListener(this.focusListener);
            Actor actor = this.previousKeyboardFocus;
            if (actor != null && actor.getStage() == null) {
                this.previousKeyboardFocus = null;
            }
            if ((actor = stage.getKeyboardFocus()) == null || actor.isDescendantOf(this)) {
                stage.setKeyboardFocus(this.previousKeyboardFocus);
            }
            if ((actor = this.previousScrollFocus) != null && actor.getStage() == null) {
                this.previousScrollFocus = null;
            }
            if ((actor = stage.getScrollFocus()) == null || actor.isDescendantOf(this)) {
                stage.setScrollFocus(this.previousScrollFocus);
            }
        }
        if (action != null) {
            this.addCaptureListener(this.ignoreTouchDown);
            this.addAction(Actions.sequence(action, (Action)Actions.removeListener(this.ignoreTouchDown, true), (Action)Actions.removeActor()));
        } else {
            this.remove();
        }
    }

    public Dialog key(final int n, final Object object) {
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent inputEvent, int n2) {
                if (n == n2) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            Dialog.this.result(object);
                            if (!Dialog.this.cancelHide) {
                                Dialog.this.hide();
                            }
                            Dialog.this.cancelHide = false;
                        }
                    });
                }
                return false;
            }
        });
        return this;
    }

    protected void result(Object object) {
    }

    public void setObject(Actor actor, Object object) {
        this.values.put(actor, object);
    }

    @Override
    protected void setStage(Stage stage) {
        if (stage == null) {
            this.addListener(this.focusListener);
        } else {
            this.removeListener(this.focusListener);
        }
        super.setStage(stage);
    }

    public Dialog show(Stage stage) {
        this.show(stage, Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.fadeIn(0.4f, Interpolation.fade)));
        this.setPosition(Math.round((stage.getWidth() - this.getWidth()) / 2.0f), Math.round((stage.getHeight() - this.getHeight()) / 2.0f));
        return this;
    }

    public Dialog show(Stage stage, Action action) {
        this.clearActions();
        this.removeCaptureListener(this.ignoreTouchDown);
        this.previousKeyboardFocus = null;
        Actor actor = stage.getKeyboardFocus();
        if (actor != null && !actor.isDescendantOf(this)) {
            this.previousKeyboardFocus = actor;
        }
        this.previousScrollFocus = null;
        actor = stage.getScrollFocus();
        if (actor != null && !actor.isDescendantOf(this)) {
            this.previousScrollFocus = actor;
        }
        stage.addActor(this);
        this.pack();
        stage.cancelTouchFocus();
        stage.setKeyboardFocus(this);
        stage.setScrollFocus(this);
        if (action != null) {
            this.addAction(action);
        }
        return this;
    }

    public Dialog text(Label label) {
        this.contentTable.add(label);
        return this;
    }

    public Dialog text(String string2) {
        Skin skin = this.skin;
        if (skin != null) {
            return this.text(string2, skin.get(Label.LabelStyle.class));
        }
        throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
    }

    public Dialog text(String string2, Label.LabelStyle labelStyle) {
        return this.text(new Label((CharSequence)string2, labelStyle));
    }
}

