/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;

public class CheckBox
extends TextButton {
    private Image image;
    private Cell imageCell;
    private CheckBoxStyle style;

    public CheckBox(String object, CheckBoxStyle object2) {
        super((String)object, (TextButton.TextButtonStyle)object2);
        this.clearChildren();
        object = this.getLabel();
        this.image = object2 = new Image(((CheckBoxStyle)object2).checkboxOff, Scaling.none);
        this.imageCell = this.add(object2);
        this.add(object);
        ((Label)object).setAlignment(8);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public CheckBox(String string2, Skin skin) {
        this(string2, skin.get(CheckBoxStyle.class));
    }

    public CheckBox(String string2, Skin skin, String string3) {
        this(string2, skin.get(string3, CheckBoxStyle.class));
    }

    @Override
    public void draw(Batch batch, float f) {
        Drawable drawable2 = this.isDisabled() ? (this.isChecked && this.style.checkboxOnDisabled != null ? this.style.checkboxOnDisabled : this.style.checkboxOffDisabled) : null;
        Drawable drawable3 = drawable2;
        if (drawable2 == null) {
            boolean bl = this.isOver() && !this.isDisabled();
            drawable3 = this.isChecked && this.style.checkboxOn != null ? (bl && this.style.checkboxOnOver != null ? this.style.checkboxOnOver : this.style.checkboxOn) : (bl && this.style.checkboxOver != null ? this.style.checkboxOver : this.style.checkboxOff);
        }
        this.image.setDrawable(drawable3);
        super.draw(batch, f);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.imageCell;
    }

    @Override
    public CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Button.ButtonStyle buttonStyle) {
        if (buttonStyle instanceof CheckBoxStyle) {
            super.setStyle(buttonStyle);
            this.style = (CheckBoxStyle)buttonStyle;
            return;
        }
        throw new IllegalArgumentException("style must be a CheckBoxStyle.");
    }

    public static class CheckBoxStyle
    extends TextButton.TextButtonStyle {
        public Drawable checkboxOff;
        public Drawable checkboxOffDisabled;
        public Drawable checkboxOn;
        public Drawable checkboxOnDisabled;
        public Drawable checkboxOnOver;
        public Drawable checkboxOver;

        public CheckBoxStyle() {
        }

        public CheckBoxStyle(CheckBoxStyle checkBoxStyle) {
            super(checkBoxStyle);
            this.checkboxOff = checkBoxStyle.checkboxOff;
            this.checkboxOn = checkBoxStyle.checkboxOn;
            this.checkboxOver = checkBoxStyle.checkboxOver;
            this.checkboxOffDisabled = checkBoxStyle.checkboxOffDisabled;
            this.checkboxOnDisabled = checkBoxStyle.checkboxOnDisabled;
        }

        public CheckBoxStyle(Drawable drawable2, Drawable drawable3, BitmapFont bitmapFont, Color color2) {
            this.checkboxOff = drawable2;
            this.checkboxOn = drawable3;
            this.font = bitmapFont;
            this.fontColor = color2;
        }
    }
}

