/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public class ParallelAction
extends Action {
    Array<Action> actions = new Array(4);
    private boolean complete;

    public ParallelAction() {
    }

    public ParallelAction(Action action) {
        this.addAction(action);
    }

    public ParallelAction(Action action, Action action2) {
        this.addAction(action);
        this.addAction(action2);
    }

    public ParallelAction(Action action, Action action2, Action action3) {
        this.addAction(action);
        this.addAction(action2);
        this.addAction(action3);
    }

    public ParallelAction(Action action, Action action2, Action action3, Action action4) {
        this.addAction(action);
        this.addAction(action2);
        this.addAction(action3);
        this.addAction(action4);
    }

    public ParallelAction(Action action, Action action2, Action action3, Action action4, Action action5) {
        this.addAction(action);
        this.addAction(action2);
        this.addAction(action3);
        this.addAction(action4);
        this.addAction(action5);
    }

    @Override
    public boolean act(float f) {
        boolean bl;
        if (this.complete) {
            return true;
        }
        this.complete = true;
        Pool pool = this.getPool();
        this.setPool(null);
        Array<Action> array = this.actions;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            if (this.actor == null) break;
            Object object = array.get(i);
            if (((Action)object).getActor() != null && !((Action)object).act(f)) {
                this.complete = false;
            }
            if ((object = this.actor) != null) continue;
            this.setPool(pool);
            return true;
        }
        try {
            bl = this.complete;
        }
        catch (Throwable throwable) {
            this.setPool(pool);
            throw throwable;
        }
        this.setPool(pool);
        return bl;
    }

    public void addAction(Action action) {
        this.actions.add(action);
        if (this.actor != null) {
            action.setActor(this.actor);
        }
    }

    public Array<Action> getActions() {
        return this.actions;
    }

    @Override
    public void reset() {
        super.reset();
        this.actions.clear();
    }

    @Override
    public void restart() {
        this.complete = false;
        Array<Action> array = this.actions;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            array.get(i).restart();
        }
    }

    @Override
    public void setActor(Actor actor) {
        Array<Action> array = this.actions;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            array.get(i).setActor(actor);
        }
        super.setActor(actor);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(super.toString());
        stringBuilder.append('(');
        Array<Action> array = this.actions;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(array.get(i));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

