/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import java.io.Serializable;

public class GridPoint2
implements Serializable {
    private static final long serialVersionUID = -4019969926331717380L;
    public int x;
    public int y;

    public GridPoint2() {
    }

    public GridPoint2(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public GridPoint2(GridPoint2 gridPoint2) {
        this.x = gridPoint2.x;
        this.y = gridPoint2.y;
    }

    public GridPoint2 add(int n, int n2) {
        this.x += n;
        this.y += n2;
        return this;
    }

    public GridPoint2 add(GridPoint2 gridPoint2) {
        this.x += gridPoint2.x;
        this.y += gridPoint2.y;
        return this;
    }

    public GridPoint2 cpy() {
        return new GridPoint2(this);
    }

    public float dst(int n, int n2) {
        return (float)Math.sqrt((n -= this.x) * n + (n2 -= this.y) * n2);
    }

    public float dst(GridPoint2 gridPoint2) {
        int n = gridPoint2.x - this.x;
        int n2 = gridPoint2.y - this.y;
        return (float)Math.sqrt(n * n + n2 * n2);
    }

    public float dst2(int n, int n2) {
        return (n -= this.x) * n + (n2 -= this.y) * n2;
    }

    public float dst2(GridPoint2 gridPoint2) {
        int n = gridPoint2.x - this.x;
        int n2 = gridPoint2.y - this.y;
        return n * n + n2 * n2;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            object = (GridPoint2)object;
            if (this.x != ((GridPoint2)object).x || this.y != ((GridPoint2)object).y) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return (this.x + 53) * 53 + this.y;
    }

    public GridPoint2 set(int n, int n2) {
        this.x = n;
        this.y = n2;
        return this;
    }

    public GridPoint2 set(GridPoint2 gridPoint2) {
        this.x = gridPoint2.x;
        this.y = gridPoint2.y;
        return this;
    }

    public GridPoint2 sub(int n, int n2) {
        this.x -= n;
        this.y -= n2;
        return this;
    }

    public GridPoint2 sub(GridPoint2 gridPoint2) {
        this.x -= gridPoint2.x;
        this.y -= gridPoint2.y;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.x);
        stringBuilder.append(", ");
        stringBuilder.append(this.y);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

