/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;

public class HexagonalTiledMapRenderer
extends BatchTiledMapRenderer {
    private float hexSideLength = 0.0f;
    private boolean staggerAxisX = true;
    private boolean staggerIndexEven = false;

    public HexagonalTiledMapRenderer(TiledMap tiledMap) {
        super(tiledMap);
        this.init(tiledMap);
    }

    public HexagonalTiledMapRenderer(TiledMap tiledMap, float f) {
        super(tiledMap, f);
        this.init(tiledMap);
    }

    public HexagonalTiledMapRenderer(TiledMap tiledMap, float f, Batch batch) {
        super(tiledMap, f, batch);
        this.init(tiledMap);
    }

    public HexagonalTiledMapRenderer(TiledMap tiledMap, Batch batch) {
        super(tiledMap, batch);
        this.init(tiledMap);
    }

    private void init(TiledMap tiledMap) {
        Object object = tiledMap.getProperties().get("staggeraxis", String.class);
        if (object != null) {
            this.staggerAxisX = ((String)object).equals("x");
        }
        if ((object = tiledMap.getProperties().get("staggerindex", String.class)) != null) {
            this.staggerIndexEven = ((String)object).equals("even");
        }
        this.hexSideLength = (object = tiledMap.getProperties().get("hexsidelength", Integer.class)) != null ? (float)((Integer)object).intValue() : (this.staggerAxisX ? ((object = tiledMap.getProperties().get("tilewidth", Integer.class)) != null ? (float)((Integer)object).intValue() * 0.5f : ((TiledMapTileLayer)tiledMap.getLayers().get(0)).getTileWidth() * 0.5f) : ((object = tiledMap.getProperties().get("tileheight", Integer.class)) != null ? (float)((Integer)object).intValue() * 0.5f : ((TiledMapTileLayer)tiledMap.getLayers().get(0)).getTileHeight() * 0.5f));
    }

    private void renderCell(TiledMapTileLayer.Cell object, float f, float f2, float f3) {
        TiledMapTile tiledMapTile;
        if (object != null && (tiledMapTile = ((TiledMapTileLayer.Cell)object).getTile()) != null) {
            if (tiledMapTile instanceof AnimatedTiledMapTile) {
                return;
            }
            boolean bl = ((TiledMapTileLayer.Cell)object).getFlipHorizontally();
            boolean bl2 = ((TiledMapTileLayer.Cell)object).getFlipVertically();
            int n = ((TiledMapTileLayer.Cell)object).getRotation();
            object = tiledMapTile.getTextureRegion();
            float f4 = f2 + tiledMapTile.getOffsetY() * this.unitScale;
            float f5 = (float)((TextureRegion)object).getRegionWidth() * this.unitScale + (f += tiledMapTile.getOffsetX() * this.unitScale);
            float f6 = (float)((TextureRegion)object).getRegionHeight() * this.unitScale + f4;
            float f7 = ((TextureRegion)object).getU();
            float f8 = ((TextureRegion)object).getV2();
            float f9 = ((TextureRegion)object).getU2();
            f2 = ((TextureRegion)object).getV();
            this.vertices[0] = f;
            this.vertices[1] = f4;
            this.vertices[2] = f3;
            this.vertices[3] = f7;
            this.vertices[4] = f8;
            this.vertices[5] = f;
            this.vertices[6] = f6;
            this.vertices[7] = f3;
            this.vertices[8] = f7;
            this.vertices[9] = f2;
            this.vertices[10] = f5;
            this.vertices[11] = f6;
            this.vertices[12] = f3;
            this.vertices[13] = f9;
            this.vertices[14] = f2;
            this.vertices[15] = f5;
            this.vertices[16] = f4;
            this.vertices[17] = f3;
            this.vertices[18] = f9;
            this.vertices[19] = f8;
            if (bl) {
                f = this.vertices[3];
                this.vertices[3] = this.vertices[13];
                this.vertices[13] = f;
                f = this.vertices[8];
                this.vertices[8] = this.vertices[18];
                this.vertices[18] = f;
            }
            if (bl2) {
                f = this.vertices[4];
                this.vertices[4] = this.vertices[14];
                this.vertices[14] = f;
                f = this.vertices[9];
                this.vertices[9] = this.vertices[19];
                this.vertices[19] = f;
            }
            if (n == 2) {
                f = this.vertices[3];
                this.vertices[3] = this.vertices[13];
                this.vertices[13] = f;
                f = this.vertices[8];
                this.vertices[8] = this.vertices[18];
                this.vertices[18] = f;
                f = this.vertices[4];
                this.vertices[4] = this.vertices[14];
                this.vertices[14] = f;
                f = this.vertices[9];
                this.vertices[9] = this.vertices[19];
                this.vertices[19] = f;
            }
            this.batch.draw(((TextureRegion)object).getTexture(), this.vertices, 0, 20);
        }
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer tiledMapTileLayer) {
        TiledMapTileLayer tiledMapTileLayer2 = tiledMapTileLayer;
        Color color2 = this.batch.getColor();
        float f = Color.toFloatBits(color2.r, color2.g, color2.b, color2.a * tiledMapTileLayer.getOpacity());
        int n = tiledMapTileLayer.getWidth();
        int n2 = tiledMapTileLayer.getHeight();
        float f2 = tiledMapTileLayer.getTileWidth() * this.unitScale;
        float f3 = tiledMapTileLayer.getTileHeight() * this.unitScale;
        float f4 = tiledMapTileLayer.getRenderOffsetX() * this.unitScale;
        float f5 = -tiledMapTileLayer.getRenderOffsetY() * this.unitScale;
        float f6 = this.hexSideLength * this.unitScale;
        boolean bl = this.staggerAxisX;
        boolean bl2 = false;
        if (bl) {
            float f7 = (f2 - f6) / 2.0f;
            f2 = (f2 + f6) / 2.0f;
            f6 = 0.5f * f3;
            int n3 = Math.max(0, (int)((this.viewBounds.y - f6 - f4) / f3));
            int n4 = Math.min(n2, (int)((this.viewBounds.y + this.viewBounds.height + f3 - f4) / f3));
            n2 = Math.max(0, (int)((this.viewBounds.x - f7 - f5) / f2));
            int n5 = Math.min(n, (int)((this.viewBounds.x + this.viewBounds.width + f2 - f5) / f2));
            bl = this.staggerIndexEven;
            int n6 = n2 % 2;
            if (n6 == 0) {
                bl2 = true;
            }
            n = bl == bl2 ? n2 + 1 : n2;
            bl = this.staggerIndexEven;
            bl2 = n6 == 0;
            if (bl != bl2) {
                ++n2;
            }
            --n4;
            while (n4 >= n3) {
                for (n6 = n; n6 < n5; n6 += 2) {
                    this.renderCell(tiledMapTileLayer2.getCell(n6, n4), (float)n6 * f2 + f4, (float)n4 * f3 + f6 + f5, f);
                }
                for (n6 = n2; n6 < n5; n6 += 2) {
                    this.renderCell(tiledMapTileLayer2.getCell(n6, n4), (float)n6 * f2 + f4, (float)n4 * f3 + f5, f);
                }
                --n4;
            }
        } else {
            float f8 = (f3 - f6) / 2.0f;
            f6 = (f3 + f6) / 2.0f;
            float f9 = 0.5f * f2;
            int n7 = Math.max(0, (int)((this.viewBounds.y - f8 - f4) / f6));
            n2 = Math.min(n2, (int)((this.viewBounds.y + this.viewBounds.height + f6 - f4) / f6));
            int n8 = Math.max(0, (int)((this.viewBounds.x - f9 - f5) / f2));
            int n9 = Math.min(n, (int)((this.viewBounds.x + this.viewBounds.width + f2 - f5) / f2));
            for (n = n2 - 1; n >= n7; --n) {
                bl2 = n % 2 == 0;
                f3 = bl2 == this.staggerIndexEven ? f9 : 0.0f;
                for (n2 = n8; n2 < n9; ++n2) {
                    this.renderCell(tiledMapTileLayer.getCell(n2, n), (float)n2 * f2 + f3 + f4, (float)n * f6 + f5, f);
                }
            }
        }
    }
}

