/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.profiling.GLInterceptor;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GL20Interceptor
extends GLInterceptor
implements GL20 {
    protected final GL20 gl20;

    protected GL20Interceptor(GLProfiler gLProfiler, GL20 gL20) {
        super(gLProfiler);
        this.gl20 = gL20;
    }

    private void check() {
        int n = this.gl20.glGetError();
        while (n != 0) {
            this.glProfiler.getListener().onError(n);
            n = this.gl20.glGetError();
        }
    }

    @Override
    public void glActiveTexture(int n) {
        ++this.calls;
        this.gl20.glActiveTexture(n);
        this.check();
    }

    @Override
    public void glAttachShader(int n, int n2) {
        ++this.calls;
        this.gl20.glAttachShader(n, n2);
        this.check();
    }

    @Override
    public void glBindAttribLocation(int n, int n2, String string2) {
        ++this.calls;
        this.gl20.glBindAttribLocation(n, n2, string2);
        this.check();
    }

    @Override
    public void glBindBuffer(int n, int n2) {
        ++this.calls;
        this.gl20.glBindBuffer(n, n2);
        this.check();
    }

    @Override
    public void glBindFramebuffer(int n, int n2) {
        ++this.calls;
        this.gl20.glBindFramebuffer(n, n2);
        this.check();
    }

    @Override
    public void glBindRenderbuffer(int n, int n2) {
        ++this.calls;
        this.gl20.glBindRenderbuffer(n, n2);
        this.check();
    }

    @Override
    public void glBindTexture(int n, int n2) {
        ++this.textureBindings;
        ++this.calls;
        this.gl20.glBindTexture(n, n2);
        this.check();
    }

    @Override
    public void glBlendColor(float f, float f2, float f3, float f4) {
        ++this.calls;
        this.gl20.glBlendColor(f, f2, f3, f4);
        this.check();
    }

    @Override
    public void glBlendEquation(int n) {
        ++this.calls;
        this.gl20.glBlendEquation(n);
        this.check();
    }

    @Override
    public void glBlendEquationSeparate(int n, int n2) {
        ++this.calls;
        this.gl20.glBlendEquationSeparate(n, n2);
        this.check();
    }

    @Override
    public void glBlendFunc(int n, int n2) {
        ++this.calls;
        this.gl20.glBlendFunc(n, n2);
        this.check();
    }

    @Override
    public void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl20.glBlendFuncSeparate(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glBufferData(int n, int n2, Buffer buffer, int n3) {
        ++this.calls;
        this.gl20.glBufferData(n, n2, buffer, n3);
        this.check();
    }

    @Override
    public void glBufferSubData(int n, int n2, int n3, Buffer buffer) {
        ++this.calls;
        this.gl20.glBufferSubData(n, n2, n3, buffer);
        this.check();
    }

    @Override
    public int glCheckFramebufferStatus(int n) {
        ++this.calls;
        n = this.gl20.glCheckFramebufferStatus(n);
        this.check();
        return n;
    }

    @Override
    public void glClear(int n) {
        ++this.calls;
        this.gl20.glClear(n);
        this.check();
    }

    @Override
    public void glClearColor(float f, float f2, float f3, float f4) {
        ++this.calls;
        this.gl20.glClearColor(f, f2, f3, f4);
        this.check();
    }

    @Override
    public void glClearDepthf(float f) {
        ++this.calls;
        this.gl20.glClearDepthf(f);
        this.check();
    }

    @Override
    public void glClearStencil(int n) {
        ++this.calls;
        this.gl20.glClearStencil(n);
        this.check();
    }

    @Override
    public void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ++this.calls;
        this.gl20.glColorMask(bl, bl2, bl3, bl4);
        this.check();
    }

    @Override
    public void glCompileShader(int n) {
        ++this.calls;
        this.gl20.glCompileShader(n);
        this.check();
    }

    @Override
    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        ++this.calls;
        this.gl20.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, buffer);
        this.check();
    }

    @Override
    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        ++this.calls;
        this.gl20.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.check();
    }

    @Override
    public void glCopyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ++this.calls;
        this.gl20.glCopyTexImage2D(n, n2, n3, n4, n5, n6, n7, n8);
        this.check();
    }

    @Override
    public void glCopyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ++this.calls;
        this.gl20.glCopyTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8);
        this.check();
    }

    @Override
    public int glCreateProgram() {
        ++this.calls;
        int n = this.gl20.glCreateProgram();
        this.check();
        return n;
    }

    @Override
    public int glCreateShader(int n) {
        ++this.calls;
        n = this.gl20.glCreateShader(n);
        this.check();
        return n;
    }

    @Override
    public void glCullFace(int n) {
        ++this.calls;
        this.gl20.glCullFace(n);
        this.check();
    }

    @Override
    public void glDeleteBuffer(int n) {
        ++this.calls;
        this.gl20.glDeleteBuffer(n);
        this.check();
    }

    @Override
    public void glDeleteBuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glDeleteBuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteFramebuffer(int n) {
        ++this.calls;
        this.gl20.glDeleteFramebuffer(n);
        this.check();
    }

    @Override
    public void glDeleteFramebuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glDeleteFramebuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteProgram(int n) {
        ++this.calls;
        this.gl20.glDeleteProgram(n);
        this.check();
    }

    @Override
    public void glDeleteRenderbuffer(int n) {
        ++this.calls;
        this.gl20.glDeleteRenderbuffer(n);
        this.check();
    }

    @Override
    public void glDeleteRenderbuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glDeleteRenderbuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteShader(int n) {
        ++this.calls;
        this.gl20.glDeleteShader(n);
        this.check();
    }

    @Override
    public void glDeleteTexture(int n) {
        ++this.calls;
        this.gl20.glDeleteTexture(n);
        this.check();
    }

    @Override
    public void glDeleteTextures(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glDeleteTextures(n, intBuffer);
        this.check();
    }

    @Override
    public void glDepthFunc(int n) {
        ++this.calls;
        this.gl20.glDepthFunc(n);
        this.check();
    }

    @Override
    public void glDepthMask(boolean bl) {
        ++this.calls;
        this.gl20.glDepthMask(bl);
        this.check();
    }

    @Override
    public void glDepthRangef(float f, float f2) {
        ++this.calls;
        this.gl20.glDepthRangef(f, f2);
        this.check();
    }

    @Override
    public void glDetachShader(int n, int n2) {
        ++this.calls;
        this.gl20.glDetachShader(n, n2);
        this.check();
    }

    @Override
    public void glDisable(int n) {
        ++this.calls;
        this.gl20.glDisable(n);
        this.check();
    }

    @Override
    public void glDisableVertexAttribArray(int n) {
        ++this.calls;
        this.gl20.glDisableVertexAttribArray(n);
        this.check();
    }

    @Override
    public void glDrawArrays(int n, int n2, int n3) {
        this.vertexCount.put(n3);
        ++this.drawCalls;
        ++this.calls;
        this.gl20.glDrawArrays(n, n2, n3);
        this.check();
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, int n4) {
        this.vertexCount.put(n2);
        ++this.drawCalls;
        ++this.calls;
        this.gl20.glDrawElements(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, Buffer buffer) {
        this.vertexCount.put(n2);
        ++this.drawCalls;
        ++this.calls;
        this.gl20.glDrawElements(n, n2, n3, buffer);
        this.check();
    }

    @Override
    public void glEnable(int n) {
        ++this.calls;
        this.gl20.glEnable(n);
        this.check();
    }

    @Override
    public void glEnableVertexAttribArray(int n) {
        ++this.calls;
        this.gl20.glEnableVertexAttribArray(n);
        this.check();
    }

    @Override
    public void glFinish() {
        ++this.calls;
        this.gl20.glFinish();
        this.check();
    }

    @Override
    public void glFlush() {
        ++this.calls;
        this.gl20.glFlush();
        this.check();
    }

    @Override
    public void glFramebufferRenderbuffer(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl20.glFramebufferRenderbuffer(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glFramebufferTexture2D(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl20.glFramebufferTexture2D(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glFrontFace(int n) {
        ++this.calls;
        this.gl20.glFrontFace(n);
        this.check();
    }

    @Override
    public int glGenBuffer() {
        ++this.calls;
        int n = this.gl20.glGenBuffer();
        this.check();
        return n;
    }

    @Override
    public void glGenBuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGenBuffers(n, intBuffer);
        this.check();
    }

    @Override
    public int glGenFramebuffer() {
        ++this.calls;
        int n = this.gl20.glGenFramebuffer();
        this.check();
        return n;
    }

    @Override
    public void glGenFramebuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGenFramebuffers(n, intBuffer);
        this.check();
    }

    @Override
    public int glGenRenderbuffer() {
        ++this.calls;
        int n = this.gl20.glGenRenderbuffer();
        this.check();
        return n;
    }

    @Override
    public void glGenRenderbuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGenRenderbuffers(n, intBuffer);
        this.check();
    }

    @Override
    public int glGenTexture() {
        ++this.calls;
        int n = this.gl20.glGenTexture();
        this.check();
        return n;
    }

    @Override
    public void glGenTextures(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGenTextures(n, intBuffer);
        this.check();
    }

    @Override
    public void glGenerateMipmap(int n) {
        ++this.calls;
        this.gl20.glGenerateMipmap(n);
        this.check();
    }

    @Override
    public String glGetActiveAttrib(int n, int n2, IntBuffer object, Buffer buffer) {
        ++this.calls;
        object = this.gl20.glGetActiveAttrib(n, n2, (IntBuffer)object, buffer);
        this.check();
        return object;
    }

    @Override
    public String glGetActiveUniform(int n, int n2, IntBuffer object, Buffer buffer) {
        ++this.calls;
        object = this.gl20.glGetActiveUniform(n, n2, (IntBuffer)object, buffer);
        this.check();
        return object;
    }

    @Override
    public void glGetAttachedShaders(int n, int n2, Buffer buffer, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetAttachedShaders(n, n2, buffer, intBuffer);
        this.check();
    }

    @Override
    public int glGetAttribLocation(int n, String string2) {
        ++this.calls;
        n = this.gl20.glGetAttribLocation(n, string2);
        this.check();
        return n;
    }

    @Override
    public void glGetBooleanv(int n, Buffer buffer) {
        ++this.calls;
        this.gl20.glGetBooleanv(n, buffer);
        this.check();
    }

    @Override
    public void glGetBufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetBufferParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public int glGetError() {
        ++this.calls;
        return this.gl20.glGetError();
    }

    @Override
    public void glGetFloatv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glGetFloatv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glGetFramebufferAttachmentParameteriv(int n, int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetFramebufferAttachmentParameteriv(n, n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glGetIntegerv(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetIntegerv(n, intBuffer);
        this.check();
    }

    @Override
    public String glGetProgramInfoLog(int n) {
        ++this.calls;
        String string2 = this.gl20.glGetProgramInfoLog(n);
        this.check();
        return string2;
    }

    @Override
    public void glGetProgramiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetProgramiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetRenderbufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetRenderbufferParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public String glGetShaderInfoLog(int n) {
        ++this.calls;
        String string2 = this.gl20.glGetShaderInfoLog(n);
        this.check();
        return string2;
    }

    @Override
    public void glGetShaderPrecisionFormat(int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ++this.calls;
        this.gl20.glGetShaderPrecisionFormat(n, n2, intBuffer, intBuffer2);
        this.check();
    }

    @Override
    public void glGetShaderiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetShaderiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public String glGetString(int n) {
        ++this.calls;
        String string2 = this.gl20.glGetString(n);
        this.check();
        return string2;
    }

    @Override
    public void glGetTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glGetTexParameterfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glGetTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetTexParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public int glGetUniformLocation(int n, String string2) {
        ++this.calls;
        n = this.gl20.glGetUniformLocation(n, string2);
        this.check();
        return n;
    }

    @Override
    public void glGetUniformfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glGetUniformfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glGetUniformiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetUniformiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetVertexAttribPointerv(int n, int n2, Buffer buffer) {
        ++this.calls;
        this.gl20.glGetVertexAttribPointerv(n, n2, buffer);
        this.check();
    }

    @Override
    public void glGetVertexAttribfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glGetVertexAttribfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glGetVertexAttribiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glGetVertexAttribiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glHint(int n, int n2) {
        ++this.calls;
        this.gl20.glHint(n, n2);
        this.check();
    }

    @Override
    public boolean glIsBuffer(int n) {
        ++this.calls;
        boolean bl = this.gl20.glIsBuffer(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsEnabled(int n) {
        ++this.calls;
        boolean bl = this.gl20.glIsEnabled(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsFramebuffer(int n) {
        ++this.calls;
        boolean bl = this.gl20.glIsFramebuffer(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsProgram(int n) {
        ++this.calls;
        boolean bl = this.gl20.glIsProgram(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsRenderbuffer(int n) {
        ++this.calls;
        boolean bl = this.gl20.glIsRenderbuffer(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsShader(int n) {
        ++this.calls;
        boolean bl = this.gl20.glIsShader(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsTexture(int n) {
        ++this.calls;
        boolean bl = this.gl20.glIsTexture(n);
        this.check();
        return bl;
    }

    @Override
    public void glLineWidth(float f) {
        ++this.calls;
        this.gl20.glLineWidth(f);
        this.check();
    }

    @Override
    public void glLinkProgram(int n) {
        ++this.calls;
        this.gl20.glLinkProgram(n);
        this.check();
    }

    @Override
    public void glPixelStorei(int n, int n2) {
        ++this.calls;
        this.gl20.glPixelStorei(n, n2);
        this.check();
    }

    @Override
    public void glPolygonOffset(float f, float f2) {
        ++this.calls;
        this.gl20.glPolygonOffset(f, f2);
        this.check();
    }

    @Override
    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        ++this.calls;
        this.gl20.glReadPixels(n, n2, n3, n4, n5, n6, buffer);
        this.check();
    }

    @Override
    public void glReleaseShaderCompiler() {
        ++this.calls;
        this.gl20.glReleaseShaderCompiler();
        this.check();
    }

    @Override
    public void glRenderbufferStorage(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl20.glRenderbufferStorage(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glSampleCoverage(float f, boolean bl) {
        ++this.calls;
        this.gl20.glSampleCoverage(f, bl);
        this.check();
    }

    @Override
    public void glScissor(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl20.glScissor(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glShaderBinary(int n, IntBuffer intBuffer, int n2, Buffer buffer, int n3) {
        ++this.calls;
        this.gl20.glShaderBinary(n, intBuffer, n2, buffer, n3);
        this.check();
    }

    @Override
    public void glShaderSource(int n, String string2) {
        ++this.calls;
        this.gl20.glShaderSource(n, string2);
        this.check();
    }

    @Override
    public void glStencilFunc(int n, int n2, int n3) {
        ++this.calls;
        this.gl20.glStencilFunc(n, n2, n3);
        this.check();
    }

    @Override
    public void glStencilFuncSeparate(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl20.glStencilFuncSeparate(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glStencilMask(int n) {
        ++this.calls;
        this.gl20.glStencilMask(n);
        this.check();
    }

    @Override
    public void glStencilMaskSeparate(int n, int n2) {
        ++this.calls;
        this.gl20.glStencilMaskSeparate(n, n2);
        this.check();
    }

    @Override
    public void glStencilOp(int n, int n2, int n3) {
        ++this.calls;
        this.gl20.glStencilOp(n, n2, n3);
        this.check();
    }

    @Override
    public void glStencilOpSeparate(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl20.glStencilOpSeparate(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        ++this.calls;
        this.gl20.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.check();
    }

    @Override
    public void glTexParameterf(int n, int n2, float f) {
        ++this.calls;
        this.gl20.glTexParameterf(n, n2, f);
        this.check();
    }

    @Override
    public void glTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glTexParameterfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glTexParameteri(int n, int n2, int n3) {
        ++this.calls;
        this.gl20.glTexParameteri(n, n2, n3);
        this.check();
    }

    @Override
    public void glTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glTexParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        ++this.calls;
        this.gl20.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.check();
    }

    @Override
    public void glUniform1f(int n, float f) {
        ++this.calls;
        this.gl20.glUniform1f(n, f);
        this.check();
    }

    @Override
    public void glUniform1fv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glUniform1fv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glUniform1fv(int n, int n2, float[] fArray, int n3) {
        ++this.calls;
        this.gl20.glUniform1fv(n, n2, fArray, n3);
        this.check();
    }

    @Override
    public void glUniform1i(int n, int n2) {
        ++this.calls;
        this.gl20.glUniform1i(n, n2);
        this.check();
    }

    @Override
    public void glUniform1iv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glUniform1iv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform1iv(int n, int n2, int[] nArray, int n3) {
        ++this.calls;
        this.gl20.glUniform1iv(n, n2, nArray, n3);
        this.check();
    }

    @Override
    public void glUniform2f(int n, float f, float f2) {
        ++this.calls;
        this.gl20.glUniform2f(n, f, f2);
        this.check();
    }

    @Override
    public void glUniform2fv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glUniform2fv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glUniform2fv(int n, int n2, float[] fArray, int n3) {
        ++this.calls;
        this.gl20.glUniform2fv(n, n2, fArray, n3);
        this.check();
    }

    @Override
    public void glUniform2i(int n, int n2, int n3) {
        ++this.calls;
        this.gl20.glUniform2i(n, n2, n3);
        this.check();
    }

    @Override
    public void glUniform2iv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glUniform2iv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform2iv(int n, int n2, int[] nArray, int n3) {
        ++this.calls;
        this.gl20.glUniform2iv(n, n2, nArray, n3);
        this.check();
    }

    @Override
    public void glUniform3f(int n, float f, float f2, float f3) {
        ++this.calls;
        this.gl20.glUniform3f(n, f, f2, f3);
        this.check();
    }

    @Override
    public void glUniform3fv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glUniform3fv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glUniform3fv(int n, int n2, float[] fArray, int n3) {
        ++this.calls;
        this.gl20.glUniform3fv(n, n2, fArray, n3);
        this.check();
    }

    @Override
    public void glUniform3i(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl20.glUniform3i(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glUniform3iv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glUniform3iv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform3iv(int n, int n2, int[] nArray, int n3) {
        ++this.calls;
        this.gl20.glUniform3iv(n, n2, nArray, n3);
        this.check();
    }

    @Override
    public void glUniform4f(int n, float f, float f2, float f3, float f4) {
        ++this.calls;
        this.gl20.glUniform4f(n, f, f2, f3, f4);
        this.check();
    }

    @Override
    public void glUniform4fv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glUniform4fv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glUniform4fv(int n, int n2, float[] fArray, int n3) {
        ++this.calls;
        this.gl20.glUniform4fv(n, n2, fArray, n3);
        this.check();
    }

    @Override
    public void glUniform4i(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl20.glUniform4i(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glUniform4iv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl20.glUniform4iv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform4iv(int n, int n2, int[] nArray, int n3) {
        ++this.calls;
        this.gl20.glUniform4iv(n, n2, nArray, n3);
        this.check();
    }

    @Override
    public void glUniformMatrix2fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glUniformMatrix2fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix2fv(int n, int n2, boolean bl, float[] fArray, int n3) {
        ++this.calls;
        this.gl20.glUniformMatrix2fv(n, n2, bl, fArray, n3);
        this.check();
    }

    @Override
    public void glUniformMatrix3fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glUniformMatrix3fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix3fv(int n, int n2, boolean bl, float[] fArray, int n3) {
        ++this.calls;
        this.gl20.glUniformMatrix3fv(n, n2, bl, fArray, n3);
        this.check();
    }

    @Override
    public void glUniformMatrix4fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glUniformMatrix4fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix4fv(int n, int n2, boolean bl, float[] fArray, int n3) {
        ++this.calls;
        this.gl20.glUniformMatrix4fv(n, n2, bl, fArray, n3);
        this.check();
    }

    @Override
    public void glUseProgram(int n) {
        ++this.shaderSwitches;
        ++this.calls;
        this.gl20.glUseProgram(n);
        this.check();
    }

    @Override
    public void glValidateProgram(int n) {
        ++this.calls;
        this.gl20.glValidateProgram(n);
        this.check();
    }

    @Override
    public void glVertexAttrib1f(int n, float f) {
        ++this.calls;
        this.gl20.glVertexAttrib1f(n, f);
        this.check();
    }

    @Override
    public void glVertexAttrib1fv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glVertexAttrib1fv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glVertexAttrib2f(int n, float f, float f2) {
        ++this.calls;
        this.gl20.glVertexAttrib2f(n, f, f2);
        this.check();
    }

    @Override
    public void glVertexAttrib2fv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glVertexAttrib2fv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glVertexAttrib3f(int n, float f, float f2, float f3) {
        ++this.calls;
        this.gl20.glVertexAttrib3f(n, f, f2, f3);
        this.check();
    }

    @Override
    public void glVertexAttrib3fv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glVertexAttrib3fv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glVertexAttrib4f(int n, float f, float f2, float f3, float f4) {
        ++this.calls;
        this.gl20.glVertexAttrib4f(n, f, f2, f3, f4);
        this.check();
    }

    @Override
    public void glVertexAttrib4fv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl20.glVertexAttrib4fv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, int n5) {
        ++this.calls;
        this.gl20.glVertexAttribPointer(n, n2, n3, bl, n4, n5);
        this.check();
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) {
        ++this.calls;
        this.gl20.glVertexAttribPointer(n, n2, n3, bl, n4, buffer);
        this.check();
    }

    @Override
    public void glViewport(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl20.glViewport(n, n2, n3, n4);
        this.check();
    }
}

