/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.HdpiMode;

public class HdpiUtils {
    private static HdpiMode mode = HdpiMode.Logical;

    public static void glScissor(int n, int n2, int n3, int n4) {
        if (mode == HdpiMode.Logical && (Gdx.graphics.getWidth() != Gdx.graphics.getBackBufferWidth() || Gdx.graphics.getHeight() != Gdx.graphics.getBackBufferHeight())) {
            Gdx.gl.glScissor(HdpiUtils.toBackBufferX(n), HdpiUtils.toBackBufferY(n2), HdpiUtils.toBackBufferX(n3), HdpiUtils.toBackBufferY(n4));
        } else {
            Gdx.gl.glScissor(n, n2, n3, n4);
        }
    }

    public static void glViewport(int n, int n2, int n3, int n4) {
        if (mode == HdpiMode.Logical && (Gdx.graphics.getWidth() != Gdx.graphics.getBackBufferWidth() || Gdx.graphics.getHeight() != Gdx.graphics.getBackBufferHeight())) {
            Gdx.gl.glViewport(HdpiUtils.toBackBufferX(n), HdpiUtils.toBackBufferY(n2), HdpiUtils.toBackBufferX(n3), HdpiUtils.toBackBufferY(n4));
        } else {
            Gdx.gl.glViewport(n, n2, n3, n4);
        }
    }

    public static void setMode(HdpiMode hdpiMode) {
        mode = hdpiMode;
    }

    public static int toBackBufferX(int n) {
        return (int)((float)(n * Gdx.graphics.getBackBufferWidth()) / (float)Gdx.graphics.getWidth());
    }

    public static int toBackBufferY(int n) {
        return (int)((float)(n * Gdx.graphics.getBackBufferHeight()) / (float)Gdx.graphics.getHeight());
    }

    public static int toLogicalX(int n) {
        return (int)((float)(n * Gdx.graphics.getWidth()) / (float)Gdx.graphics.getBackBufferWidth());
    }

    public static int toLogicalY(int n) {
        return (int)((float)(n * Gdx.graphics.getHeight()) / (float)Gdx.graphics.getBackBufferHeight());
    }
}

