/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class FileTextureData
implements TextureData {
    final FileHandle file;
    Pixmap.Format format;
    int height = 0;
    boolean isPrepared = false;
    Pixmap pixmap;
    boolean useMipMaps;
    int width = 0;

    public FileTextureData(FileHandle object, Pixmap pixmap, Pixmap.Format format, boolean bl) {
        this.file = object;
        this.pixmap = pixmap;
        this.format = format;
        this.useMipMaps = bl;
        object = this.pixmap;
        if (object != null) {
            this.width = ((Pixmap)object).getWidth();
            this.height = this.pixmap.getHeight();
            if (format == null) {
                this.format = this.pixmap.getFormat();
            }
        }
    }

    @Override
    public void consumeCustomData(int n) {
        throw new GdxRuntimeException("This TextureData implementation does not upload data itself");
    }

    @Override
    public Pixmap consumePixmap() {
        if (this.isPrepared) {
            this.isPrepared = false;
            Pixmap pixmap = this.pixmap;
            this.pixmap = null;
            return pixmap;
        }
        throw new GdxRuntimeException("Call prepare() before calling getPixmap()");
    }

    @Override
    public boolean disposePixmap() {
        return true;
    }

    public FileHandle getFileHandle() {
        return this.file;
    }

    @Override
    public Pixmap.Format getFormat() {
        return this.format;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public TextureData.TextureDataType getType() {
        return TextureData.TextureDataType.Pixmap;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public void prepare() {
        if (!this.isPrepared) {
            if (this.pixmap == null) {
                this.pixmap = this.file.extension().equals("cim") ? PixmapIO.readCIM(this.file) : new Pixmap(this.file);
                this.width = this.pixmap.getWidth();
                this.height = this.pixmap.getHeight();
                if (this.format == null) {
                    this.format = this.pixmap.getFormat();
                }
            }
            this.isPrepared = true;
            return;
        }
        throw new GdxRuntimeException("Already prepared");
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public boolean useMipMaps() {
        return this.useMipMaps;
    }
}

