/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.CubemapAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.IntAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.SpotLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.environment.AmbientCubemap;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class DefaultShader
extends BaseShader {
    @Deprecated
    public static int defaultCullFace;
    @Deprecated
    public static int defaultDepthFunc;
    private static String defaultFragmentShader;
    private static String defaultVertexShader;
    protected static long implementedFlags;
    private static final long optionalAttributes;
    private static final Attributes tmpAttributes;
    protected final AmbientCubemap ambientCubemap;
    protected final long attributesMask;
    protected final Config config;
    protected int dirLightsColorOffset;
    protected int dirLightsDirectionOffset;
    protected int dirLightsLoc;
    protected int dirLightsSize;
    protected final DirectionalLight[] directionalLights;
    protected final boolean environmentCubemap;
    protected final boolean lighting;
    private boolean lightsSet;
    private final Matrix3 normalMatrix;
    protected final PointLight[] pointLights;
    protected int pointLightsColorOffset;
    protected int pointLightsIntensityOffset;
    protected int pointLightsLoc;
    protected int pointLightsPositionOffset;
    protected int pointLightsSize;
    private Renderable renderable;
    protected final boolean shadowMap;
    protected final SpotLight[] spotLights;
    protected int spotLightsColorOffset;
    protected int spotLightsCutoffAngleOffset;
    protected int spotLightsDirectionOffset;
    protected int spotLightsExponentOffset;
    protected int spotLightsIntensityOffset;
    protected int spotLightsLoc;
    protected int spotLightsPositionOffset;
    protected int spotLightsSize;
    private float time;
    private final Vector3 tmpV1;
    public final int u_alphaTest;
    protected final int u_ambientCubemap;
    public final int u_ambientTexture;
    public final int u_ambientUVTransform;
    public final int u_bones;
    public final int u_cameraDirection;
    public final int u_cameraNearFar;
    public final int u_cameraPosition;
    public final int u_cameraUp;
    public final int u_diffuseColor;
    public final int u_diffuseTexture;
    public final int u_diffuseUVTransform;
    protected final int u_dirLights0color;
    protected final int u_dirLights0direction;
    protected final int u_dirLights1color;
    public final int u_emissiveColor;
    public final int u_emissiveTexture;
    public final int u_emissiveUVTransform;
    protected final int u_environmentCubemap;
    protected final int u_fogColor;
    public final int u_normalMatrix;
    public final int u_normalTexture;
    public final int u_normalUVTransform;
    public final int u_opacity;
    protected final int u_pointLights0color;
    protected final int u_pointLights0intensity;
    protected final int u_pointLights0position;
    protected final int u_pointLights1color;
    public final int u_projTrans;
    public final int u_projViewTrans;
    public final int u_projViewWorldTrans;
    public final int u_reflectionColor;
    public final int u_reflectionTexture;
    public final int u_reflectionUVTransform;
    protected final int u_shadowMapProjViewTrans;
    protected final int u_shadowPCFOffset;
    protected final int u_shadowTexture;
    public final int u_shininess;
    public final int u_specularColor;
    public final int u_specularTexture;
    public final int u_specularUVTransform;
    protected final int u_spotLights0color;
    protected final int u_spotLights0cutoffAngle;
    protected final int u_spotLights0direction;
    protected final int u_spotLights0exponent;
    protected final int u_spotLights0intensity;
    protected final int u_spotLights0position;
    protected final int u_spotLights1color;
    public final int u_time;
    public final int u_viewTrans;
    public final int u_viewWorldTrans;
    public final int u_worldTrans;
    private final long vertexMask;

    static {
        implementedFlags = BlendingAttribute.Type | TextureAttribute.Diffuse | ColorAttribute.Diffuse | ColorAttribute.Specular | FloatAttribute.Shininess;
        defaultCullFace = 1029;
        defaultDepthFunc = 515;
        optionalAttributes = IntAttribute.CullFace | DepthTestAttribute.Type;
        tmpAttributes = new Attributes();
    }

    public DefaultShader(Renderable renderable) {
        this(renderable, new Config());
    }

    public DefaultShader(Renderable renderable, Config config) {
        this(renderable, config, DefaultShader.createPrefix(renderable, config));
    }

    public DefaultShader(Renderable matrix4Array, Config config, ShaderProgram baseLightArray) {
        long l;
        long l2;
        this.u_dirLights0color = this.register(new BaseShader.Uniform("u_dirLights[0].color"));
        this.u_dirLights0direction = this.register(new BaseShader.Uniform("u_dirLights[0].direction"));
        this.u_dirLights1color = this.register(new BaseShader.Uniform("u_dirLights[1].color"));
        this.u_pointLights0color = this.register(new BaseShader.Uniform("u_pointLights[0].color"));
        this.u_pointLights0position = this.register(new BaseShader.Uniform("u_pointLights[0].position"));
        this.u_pointLights0intensity = this.register(new BaseShader.Uniform("u_pointLights[0].intensity"));
        this.u_pointLights1color = this.register(new BaseShader.Uniform("u_pointLights[1].color"));
        this.u_spotLights0color = this.register(new BaseShader.Uniform("u_spotLights[0].color"));
        this.u_spotLights0position = this.register(new BaseShader.Uniform("u_spotLights[0].position"));
        this.u_spotLights0intensity = this.register(new BaseShader.Uniform("u_spotLights[0].intensity"));
        this.u_spotLights0direction = this.register(new BaseShader.Uniform("u_spotLights[0].direction"));
        this.u_spotLights0cutoffAngle = this.register(new BaseShader.Uniform("u_spotLights[0].cutoffAngle"));
        this.u_spotLights0exponent = this.register(new BaseShader.Uniform("u_spotLights[0].exponent"));
        this.u_spotLights1color = this.register(new BaseShader.Uniform("u_spotLights[1].color"));
        this.u_fogColor = this.register(new BaseShader.Uniform("u_fogColor"));
        this.u_shadowMapProjViewTrans = this.register(new BaseShader.Uniform("u_shadowMapProjViewTrans"));
        this.u_shadowTexture = this.register(new BaseShader.Uniform("u_shadowTexture"));
        this.u_shadowPCFOffset = this.register(new BaseShader.Uniform("u_shadowPCFOffset"));
        this.ambientCubemap = new AmbientCubemap();
        this.normalMatrix = new Matrix3();
        this.tmpV1 = new Vector3();
        Attributes attributes = DefaultShader.combineAttributes((Renderable)matrix4Array);
        this.config = config;
        this.program = baseLightArray;
        baseLightArray = matrix4Array.environment;
        boolean bl = true;
        int n = 0;
        boolean bl2 = baseLightArray != null;
        this.lighting = bl2;
        bl2 = attributes.has(CubemapAttribute.EnvironmentMap) || this.lighting && attributes.has(CubemapAttribute.EnvironmentMap);
        this.environmentCubemap = bl2;
        bl2 = this.lighting && matrix4Array.environment.shadowMap != null ? bl : false;
        this.shadowMap = bl2;
        this.renderable = matrix4Array;
        this.attributesMask = attributes.getMask() | optionalAttributes;
        this.vertexMask = matrix4Array.meshPart.mesh.getVertexAttributes().getMaskWithSizePacked();
        int n2 = this.lighting && config.numDirectionalLights > 0 ? config.numDirectionalLights : 0;
        this.directionalLights = new DirectionalLight[n2];
        for (n2 = 0; n2 < (baseLightArray = this.directionalLights).length; ++n2) {
            baseLightArray[n2] = new DirectionalLight();
        }
        n2 = this.lighting && config.numPointLights > 0 ? config.numPointLights : 0;
        this.pointLights = new PointLight[n2];
        for (n2 = 0; n2 < (baseLightArray = this.pointLights).length; ++n2) {
            baseLightArray[n2] = new PointLight();
        }
        n2 = this.lighting && config.numSpotLights > 0 ? config.numSpotLights : 0;
        this.spotLights = new SpotLight[n2];
        for (n2 = n; n2 < (baseLightArray = this.spotLights).length; ++n2) {
            baseLightArray[n2] = new SpotLight();
        }
        if (!config.ignoreUnimplemented && ((l2 = implementedFlags) & (l = this.attributesMask)) != l) {
            matrix4Array = new StringBuilder();
            matrix4Array.append("Some attributes not implemented yet (");
            matrix4Array.append(this.attributesMask);
            matrix4Array.append(")");
            throw new GdxRuntimeException(matrix4Array.toString());
        }
        this.u_projTrans = this.register(Inputs.projTrans, Setters.projTrans);
        this.u_viewTrans = this.register(Inputs.viewTrans, Setters.viewTrans);
        this.u_projViewTrans = this.register(Inputs.projViewTrans, Setters.projViewTrans);
        this.u_cameraPosition = this.register(Inputs.cameraPosition, Setters.cameraPosition);
        this.u_cameraDirection = this.register(Inputs.cameraDirection, Setters.cameraDirection);
        this.u_cameraUp = this.register(Inputs.cameraUp, Setters.cameraUp);
        this.u_cameraNearFar = this.register(Inputs.cameraNearFar, Setters.cameraNearFar);
        this.u_time = this.register(new BaseShader.Uniform("u_time"));
        this.u_worldTrans = this.register(Inputs.worldTrans, Setters.worldTrans);
        this.u_viewWorldTrans = this.register(Inputs.viewWorldTrans, Setters.viewWorldTrans);
        this.u_projViewWorldTrans = this.register(Inputs.projViewWorldTrans, Setters.projViewWorldTrans);
        this.u_normalMatrix = this.register(Inputs.normalMatrix, Setters.normalMatrix);
        matrix4Array = matrix4Array.bones;
        n = -1;
        n2 = matrix4Array != null && config.numBones > 0 ? this.register(Inputs.bones, (BaseShader.Setter)new Setters.Bones(config.numBones)) : -1;
        this.u_bones = n2;
        this.u_shininess = this.register(Inputs.shininess, Setters.shininess);
        this.u_opacity = this.register(Inputs.opacity);
        this.u_diffuseColor = this.register(Inputs.diffuseColor, Setters.diffuseColor);
        this.u_diffuseTexture = this.register(Inputs.diffuseTexture, Setters.diffuseTexture);
        this.u_diffuseUVTransform = this.register(Inputs.diffuseUVTransform, Setters.diffuseUVTransform);
        this.u_specularColor = this.register(Inputs.specularColor, Setters.specularColor);
        this.u_specularTexture = this.register(Inputs.specularTexture, Setters.specularTexture);
        this.u_specularUVTransform = this.register(Inputs.specularUVTransform, Setters.specularUVTransform);
        this.u_emissiveColor = this.register(Inputs.emissiveColor, Setters.emissiveColor);
        this.u_emissiveTexture = this.register(Inputs.emissiveTexture, Setters.emissiveTexture);
        this.u_emissiveUVTransform = this.register(Inputs.emissiveUVTransform, Setters.emissiveUVTransform);
        this.u_reflectionColor = this.register(Inputs.reflectionColor, Setters.reflectionColor);
        this.u_reflectionTexture = this.register(Inputs.reflectionTexture, Setters.reflectionTexture);
        this.u_reflectionUVTransform = this.register(Inputs.reflectionUVTransform, Setters.reflectionUVTransform);
        this.u_normalTexture = this.register(Inputs.normalTexture, Setters.normalTexture);
        this.u_normalUVTransform = this.register(Inputs.normalUVTransform, Setters.normalUVTransform);
        this.u_ambientTexture = this.register(Inputs.ambientTexture, Setters.ambientTexture);
        this.u_ambientUVTransform = this.register(Inputs.ambientUVTransform, Setters.ambientUVTransform);
        this.u_alphaTest = this.register(Inputs.alphaTest);
        n2 = this.lighting ? this.register(Inputs.ambientCube, (BaseShader.Setter)new Setters.ACubemap(config.numDirectionalLights, config.numPointLights)) : -1;
        this.u_ambientCubemap = n2;
        n2 = n;
        if (this.environmentCubemap) {
            n2 = this.register(Inputs.environmentCubemap, Setters.environmentCubemap);
        }
        this.u_environmentCubemap = n2;
    }

    public DefaultShader(Renderable renderable, Config config, String string2) {
        String string3 = config.vertexShader != null ? config.vertexShader : DefaultShader.getDefaultVertexShader();
        String string4 = config.fragmentShader != null ? config.fragmentShader : DefaultShader.getDefaultFragmentShader();
        this(renderable, config, string2, string3, string4);
    }

    public DefaultShader(Renderable renderable, Config config, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(string3);
        string3 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(string4);
        this(renderable, config, new ShaderProgram(string3, stringBuilder.toString()));
    }

    private static final boolean and(long l, long l2) {
        boolean bl = (l & l2) == l2;
        return bl;
    }

    private static final long combineAttributeMasks(Renderable renderable) {
        Environment environment = renderable.environment;
        long l = 0L;
        if (environment != null) {
            l = 0L | renderable.environment.getMask();
        }
        long l2 = l;
        if (renderable.material != null) {
            l2 = l | renderable.material.getMask();
        }
        return l2;
    }

    private static final Attributes combineAttributes(Renderable renderable) {
        tmpAttributes.clear();
        if (renderable.environment != null) {
            tmpAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            tmpAttributes.set(renderable.material);
        }
        return tmpAttributes;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String createPrefix(Renderable object, Config config) {
        Object object2;
        Object object3;
        long l;
        Object object4;
        block30: {
            block29: {
                object4 = DefaultShader.combineAttributes((Renderable)object);
                l = ((Attributes)object4).getMask();
                long l2 = ((Renderable)object).meshPart.mesh.getVertexAttributes().getMask();
                boolean bl = DefaultShader.and(l2, 1L);
                object3 = "";
                if (bl) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("");
                    ((StringBuilder)object2).append("#define positionFlag\n");
                    object3 = ((StringBuilder)object2).toString();
                }
                object2 = object3;
                if (DefaultShader.or(l2, 6L)) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object3);
                    ((StringBuilder)object2).append("#define colorFlag\n");
                    object2 = ((StringBuilder)object2).toString();
                }
                object3 = object2;
                if (DefaultShader.and(l2, 256L)) {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append((String)object2);
                    ((StringBuilder)object3).append("#define binormalFlag\n");
                    object3 = ((StringBuilder)object3).toString();
                }
                object2 = object3;
                if (DefaultShader.and(l2, 128L)) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object3);
                    ((StringBuilder)object2).append("#define tangentFlag\n");
                    object2 = ((StringBuilder)object2).toString();
                }
                object3 = object2;
                if (DefaultShader.and(l2, 8L)) {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append((String)object2);
                    ((StringBuilder)object3).append("#define normalFlag\n");
                    object3 = ((StringBuilder)object3).toString();
                }
                if (DefaultShader.and(l2, 8L)) break block29;
                object2 = object3;
                if (!DefaultShader.and(l2, 384L)) break block30;
            }
            object2 = object3;
            if (((Renderable)object).environment != null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object3);
                ((StringBuilder)object2).append("#define lightingFlag\n");
                object3 = ((StringBuilder)object2).toString();
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)object3);
                ((StringBuilder)object2).append("#define ambientCubemapFlag\n");
                object2 = ((StringBuilder)object2).toString();
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)object2);
                ((StringBuilder)object3).append("#define numDirectionalLights ");
                ((StringBuilder)object3).append(config.numDirectionalLights);
                ((StringBuilder)object3).append("\n");
                object2 = ((StringBuilder)object3).toString();
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)object2);
                ((StringBuilder)object3).append("#define numPointLights ");
                ((StringBuilder)object3).append(config.numPointLights);
                ((StringBuilder)object3).append("\n");
                object2 = ((StringBuilder)object3).toString();
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)object2);
                ((StringBuilder)object3).append("#define numSpotLights ");
                ((StringBuilder)object3).append(config.numSpotLights);
                ((StringBuilder)object3).append("\n");
                object2 = object3 = ((StringBuilder)object3).toString();
                if (((Attributes)object4).has(ColorAttribute.Fog)) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object3);
                    ((StringBuilder)object2).append("#define fogFlag\n");
                    object2 = ((StringBuilder)object2).toString();
                }
                object3 = object2;
                if (((Renderable)object).environment.shadowMap != null) {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append((String)object2);
                    ((StringBuilder)object3).append("#define shadowMapFlag\n");
                    object3 = ((StringBuilder)object3).toString();
                }
                object2 = object3;
                if (((Attributes)object4).has(CubemapAttribute.EnvironmentMap)) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object3);
                    ((StringBuilder)object2).append("#define environmentCubemapFlag\n");
                    object2 = ((StringBuilder)object2).toString();
                }
            }
        }
        int n = ((Renderable)object).meshPart.mesh.getVertexAttributes().size();
        for (int i = 0; i < n; ++i) {
            block33: {
                block32: {
                    block31: {
                        object4 = ((Renderable)object).meshPart.mesh.getVertexAttributes().get(i);
                        if (((VertexAttribute)object4).usage != 64) break block31;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append((String)object2);
                        ((StringBuilder)object3).append("#define boneWeight");
                        ((StringBuilder)object3).append(((VertexAttribute)object4).unit);
                        ((StringBuilder)object3).append("Flag\n");
                        object2 = ((StringBuilder)object3).toString();
                        break block32;
                    }
                    object3 = object2;
                    if (((VertexAttribute)object4).usage != 16) break block33;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append((String)object2);
                    ((StringBuilder)object3).append("#define texCoord");
                    ((StringBuilder)object3).append(((VertexAttribute)object4).unit);
                    ((StringBuilder)object3).append("Flag\n");
                    object2 = ((StringBuilder)object3).toString();
                }
                object3 = object2;
            }
            object2 = object3;
        }
        object4 = object2;
        if ((BlendingAttribute.Type & l) == BlendingAttribute.Type) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object2);
            ((StringBuilder)object3).append("#define blendedFlag\n");
            object4 = ((StringBuilder)object3).toString();
        }
        object3 = object4;
        if ((TextureAttribute.Diffuse & l) == TextureAttribute.Diffuse) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object4);
            ((StringBuilder)object2).append("#define diffuseTextureFlag\n");
            object3 = ((StringBuilder)object2).toString();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define diffuseTextureCoord texCoord0\n");
            object3 = ((StringBuilder)object2).toString();
        }
        object2 = object3;
        if ((TextureAttribute.Specular & l) == TextureAttribute.Specular) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define specularTextureFlag\n");
            object2 = ((StringBuilder)object2).toString();
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object2);
            ((StringBuilder)object3).append("#define specularTextureCoord texCoord0\n");
            object2 = ((StringBuilder)object3).toString();
        }
        object3 = object2;
        if ((TextureAttribute.Normal & l) == TextureAttribute.Normal) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object2);
            ((StringBuilder)object3).append("#define normalTextureFlag\n");
            object3 = ((StringBuilder)object3).toString();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define normalTextureCoord texCoord0\n");
            object3 = ((StringBuilder)object2).toString();
        }
        object4 = object3;
        if ((TextureAttribute.Emissive & l) == TextureAttribute.Emissive) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define emissiveTextureFlag\n");
            object3 = ((StringBuilder)object2).toString();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define emissiveTextureCoord texCoord0\n");
            object4 = ((StringBuilder)object2).toString();
        }
        object2 = object4;
        if ((TextureAttribute.Reflection & l) == TextureAttribute.Reflection) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object4);
            ((StringBuilder)object2).append("#define reflectionTextureFlag\n");
            object2 = ((StringBuilder)object2).toString();
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object2);
            ((StringBuilder)object3).append("#define reflectionTextureCoord texCoord0\n");
            object2 = ((StringBuilder)object3).toString();
        }
        object3 = object2;
        if ((TextureAttribute.Ambient & l) == TextureAttribute.Ambient) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object2);
            ((StringBuilder)object3).append("#define ambientTextureFlag\n");
            object3 = ((StringBuilder)object3).toString();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define ambientTextureCoord texCoord0\n");
            object3 = ((StringBuilder)object2).toString();
        }
        object2 = object3;
        if ((ColorAttribute.Diffuse & l) == ColorAttribute.Diffuse) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define diffuseColorFlag\n");
            object2 = ((StringBuilder)object2).toString();
        }
        object3 = object2;
        if ((ColorAttribute.Specular & l) == ColorAttribute.Specular) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object2);
            ((StringBuilder)object3).append("#define specularColorFlag\n");
            object3 = ((StringBuilder)object3).toString();
        }
        object2 = object3;
        if ((ColorAttribute.Emissive & l) == ColorAttribute.Emissive) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define emissiveColorFlag\n");
            object2 = ((StringBuilder)object2).toString();
        }
        object3 = object2;
        if ((ColorAttribute.Reflection & l) == ColorAttribute.Reflection) {
            object3 = new StringBuilder();
            ((StringBuilder)object3).append((String)object2);
            ((StringBuilder)object3).append("#define reflectionColorFlag\n");
            object3 = ((StringBuilder)object3).toString();
        }
        object4 = object3;
        if ((FloatAttribute.Shininess & l) == FloatAttribute.Shininess) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object3);
            ((StringBuilder)object2).append("#define shininessFlag\n");
            object4 = ((StringBuilder)object2).toString();
        }
        object2 = object4;
        if ((l & FloatAttribute.AlphaTest) == FloatAttribute.AlphaTest) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object4);
            ((StringBuilder)object2).append("#define alphaTestFlag\n");
            object2 = ((StringBuilder)object2).toString();
        }
        object3 = object2;
        if (((Renderable)object).bones == null) return object3;
        object3 = object2;
        if (config.numBones <= 0) return object3;
        object = new StringBuilder();
        ((StringBuilder)object).append((String)object2);
        ((StringBuilder)object).append("#define numBones ");
        ((StringBuilder)object).append(config.numBones);
        ((StringBuilder)object).append("\n");
        return ((StringBuilder)object).toString();
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/default.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/default.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    private static final boolean or(long l, long l2) {
        boolean bl = (l & l2) != 0L;
        return bl;
    }

    @Override
    public void begin(Camera baseLightArray, RenderContext renderContext) {
        int n;
        super.begin((Camera)baseLightArray, renderContext);
        baseLightArray = this.directionalLights;
        int n2 = baseLightArray.length;
        for (n = 0; n < n2; ++n) {
            baseLightArray[n].set(0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        }
        baseLightArray = this.pointLights;
        n2 = baseLightArray.length;
        for (n = 0; n < n2; ++n) {
            ((PointLight)baseLightArray[n]).set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        baseLightArray = this.spotLights;
        n2 = baseLightArray.length;
        for (n = 0; n < n2; ++n) {
            ((SpotLight)baseLightArray[n]).set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        }
        this.lightsSet = false;
        if (this.has(this.u_time)) {
            float f;
            n = this.u_time;
            this.time = f = this.time + Gdx.graphics.getDeltaTime();
            this.set(n, f);
        }
    }

    protected void bindLights(Renderable array, Attributes attributes) {
        int n;
        Environment environment = ((Renderable)((Object)array)).environment;
        array = attributes.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        Array<SpotLight> array2 = null;
        array = array == null ? null : ((DirectionalLightsAttribute)((Object)array)).lights;
        Object object = attributes.get(PointLightsAttribute.class, PointLightsAttribute.Type);
        object = object == null ? null : ((PointLightsAttribute)object).lights;
        SpotLightsAttribute spotLightsAttribute = attributes.get(SpotLightsAttribute.class, SpotLightsAttribute.Type);
        if (spotLightsAttribute != null) {
            array2 = spotLightsAttribute.lights;
        }
        int n2 = this.dirLightsLoc;
        int n3 = 0;
        if (n2 >= 0) {
            for (n2 = 0; n2 < this.directionalLights.length; ++n2) {
                if (array != null && n2 < array.size) {
                    if (this.lightsSet && this.directionalLights[n2].equals(array.get(n2))) continue;
                    this.directionalLights[n2].set(array.get(n2));
                } else {
                    if (this.lightsSet && this.directionalLights[n2].color.r == 0.0f && this.directionalLights[n2].color.g == 0.0f && this.directionalLights[n2].color.b == 0.0f) continue;
                    this.directionalLights[n2].color.set(0.0f, 0.0f, 0.0f, 1.0f);
                }
                n = this.dirLightsLoc + this.dirLightsSize * n2;
                this.program.setUniformf(this.dirLightsColorOffset + n, this.directionalLights[n2].color.r, this.directionalLights[n2].color.g, this.directionalLights[n2].color.b);
                this.program.setUniformf(n + this.dirLightsDirectionOffset, this.directionalLights[n2].direction.x, this.directionalLights[n2].direction.y, this.directionalLights[n2].direction.z);
                if (this.dirLightsSize <= 0) break;
            }
        }
        if (this.pointLightsLoc >= 0) {
            for (n2 = 0; n2 < this.pointLights.length; ++n2) {
                if (object != null && n2 < ((Array)object).size) {
                    if (this.lightsSet && this.pointLights[n2].equals((PointLight)((Array)object).get(n2))) continue;
                    this.pointLights[n2].set((PointLight)((Array)object).get(n2));
                } else {
                    if (this.lightsSet && this.pointLights[n2].intensity == 0.0f) continue;
                    this.pointLights[n2].intensity = 0.0f;
                }
                n = this.pointLightsLoc + this.pointLightsSize * n2;
                this.program.setUniformf(this.pointLightsColorOffset + n, this.pointLights[n2].color.r * this.pointLights[n2].intensity, this.pointLights[n2].color.g * this.pointLights[n2].intensity, this.pointLights[n2].color.b * this.pointLights[n2].intensity);
                this.program.setUniformf(this.pointLightsPositionOffset + n, this.pointLights[n2].position.x, this.pointLights[n2].position.y, this.pointLights[n2].position.z);
                if (this.pointLightsIntensityOffset >= 0) {
                    this.program.setUniformf(n + this.pointLightsIntensityOffset, this.pointLights[n2].intensity);
                }
                if (this.pointLightsSize <= 0) break;
            }
        }
        if (this.spotLightsLoc >= 0) {
            for (n2 = n3; n2 < this.spotLights.length; ++n2) {
                if (array2 != null && n2 < array2.size) {
                    if (this.lightsSet && this.spotLights[n2].equals(array2.get(n2))) continue;
                    this.spotLights[n2].set(array2.get(n2));
                } else {
                    if (this.lightsSet && this.spotLights[n2].intensity == 0.0f) continue;
                    this.spotLights[n2].intensity = 0.0f;
                }
                n3 = this.spotLightsLoc + this.spotLightsSize * n2;
                this.program.setUniformf(this.spotLightsColorOffset + n3, this.spotLights[n2].color.r * this.spotLights[n2].intensity, this.spotLights[n2].color.g * this.spotLights[n2].intensity, this.spotLights[n2].color.b * this.spotLights[n2].intensity);
                this.program.setUniformf(this.spotLightsPositionOffset + n3, this.spotLights[n2].position);
                this.program.setUniformf(this.spotLightsDirectionOffset + n3, this.spotLights[n2].direction);
                this.program.setUniformf(this.spotLightsCutoffAngleOffset + n3, this.spotLights[n2].cutoffAngle);
                this.program.setUniformf(this.spotLightsExponentOffset + n3, this.spotLights[n2].exponent);
                if (this.spotLightsIntensityOffset >= 0) {
                    this.program.setUniformf(n3 + this.spotLightsIntensityOffset, this.spotLights[n2].intensity);
                }
                if (this.spotLightsSize <= 0) break;
            }
        }
        if (attributes.has(ColorAttribute.Fog)) {
            this.set(this.u_fogColor, ((ColorAttribute)attributes.get((long)ColorAttribute.Fog)).color);
        }
        if (environment != null && environment.shadowMap != null) {
            this.set(this.u_shadowMapProjViewTrans, environment.shadowMap.getProjViewTrans());
            this.set(this.u_shadowTexture, environment.shadowMap.getDepthMap());
            this.set(this.u_shadowPCFOffset, 1.0f / ((float)((GLTexture)environment.shadowMap.getDepthMap().texture).getWidth() * 2.0f));
        }
        this.lightsSet = true;
    }

    protected void bindMaterial(Attributes object) {
        int n = this.config.defaultCullFace == -1 ? defaultCullFace : this.config.defaultCullFace;
        int n2 = this.config.defaultDepthFunc == -1 ? defaultDepthFunc : this.config.defaultDepthFunc;
        float f = 0.0f;
        float f2 = 1.0f;
        object = ((Attributes)object).iterator();
        boolean bl = true;
        while (object.hasNext()) {
            Attribute attribute = (Attribute)object.next();
            long l = attribute.type;
            if (BlendingAttribute.is(l)) {
                RenderContext renderContext = this.context;
                attribute = (BlendingAttribute)attribute;
                renderContext.setBlending(true, ((BlendingAttribute)attribute).sourceFunction, ((BlendingAttribute)attribute).destFunction);
                this.set(this.u_opacity, ((BlendingAttribute)attribute).opacity);
                continue;
            }
            if ((IntAttribute.CullFace & l) == IntAttribute.CullFace) {
                n = ((IntAttribute)attribute).value;
                continue;
            }
            if ((FloatAttribute.AlphaTest & l) == FloatAttribute.AlphaTest) {
                this.set(this.u_alphaTest, ((FloatAttribute)attribute).value);
                continue;
            }
            if ((l & DepthTestAttribute.Type) == DepthTestAttribute.Type) {
                attribute = (DepthTestAttribute)attribute;
                n2 = ((DepthTestAttribute)attribute).depthFunc;
                f = ((DepthTestAttribute)attribute).depthRangeNear;
                f2 = ((DepthTestAttribute)attribute).depthRangeFar;
                bl = ((DepthTestAttribute)attribute).depthMask;
                continue;
            }
            if (this.config.ignoreUnimplemented) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append("Unknown material attribute: ");
            ((StringBuilder)object).append(attribute.toString());
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
        this.context.setCullFace(n);
        this.context.setDepthTest(n2, f, f2);
        this.context.setDepthMask(bl);
    }

    @Override
    public boolean canRender(Renderable renderable) {
        boolean bl;
        long l = DefaultShader.combineAttributeMasks(renderable);
        long l2 = this.attributesMask;
        long l3 = optionalAttributes;
        boolean bl2 = true;
        bl = l2 == (l | l3) && this.vertexMask == renderable.meshPart.mesh.getVertexAttributes().getMaskWithSizePacked() && (bl = renderable.environment != null) == this.lighting ? bl2 : false;
        return bl;
    }

    @Override
    public int compareTo(Shader shader) {
        if (shader == null) {
            return -1;
        }
        if (shader == this) {
            // empty if block
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.program.dispose();
        super.dispose();
    }

    @Override
    public void end() {
        super.end();
    }

    public boolean equals(DefaultShader defaultShader) {
        boolean bl = defaultShader == this;
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof DefaultShader && this.equals((DefaultShader)object);
        return bl;
    }

    public int getDefaultCullFace() {
        int n = this.config.defaultCullFace == -1 ? defaultCullFace : this.config.defaultCullFace;
        return n;
    }

    public int getDefaultDepthFunc() {
        int n = this.config.defaultDepthFunc == -1 ? defaultDepthFunc : this.config.defaultDepthFunc;
        return n;
    }

    @Override
    public void init() {
        ShaderProgram shaderProgram = this.program;
        this.program = null;
        this.init(shaderProgram, this.renderable);
        this.renderable = null;
        this.dirLightsLoc = this.loc(this.u_dirLights0color);
        this.dirLightsColorOffset = this.loc(this.u_dirLights0color) - this.dirLightsLoc;
        this.dirLightsDirectionOffset = this.loc(this.u_dirLights0direction) - this.dirLightsLoc;
        this.dirLightsSize = this.loc(this.u_dirLights1color) - this.dirLightsLoc;
        if (this.dirLightsSize < 0) {
            this.dirLightsSize = 0;
        }
        this.pointLightsLoc = this.loc(this.u_pointLights0color);
        this.pointLightsColorOffset = this.loc(this.u_pointLights0color) - this.pointLightsLoc;
        this.pointLightsPositionOffset = this.loc(this.u_pointLights0position) - this.pointLightsLoc;
        boolean bl = this.has(this.u_pointLights0intensity);
        int n = -1;
        int n2 = bl ? this.loc(this.u_pointLights0intensity) - this.pointLightsLoc : -1;
        this.pointLightsIntensityOffset = n2;
        this.pointLightsSize = this.loc(this.u_pointLights1color) - this.pointLightsLoc;
        if (this.pointLightsSize < 0) {
            this.pointLightsSize = 0;
        }
        this.spotLightsLoc = this.loc(this.u_spotLights0color);
        this.spotLightsColorOffset = this.loc(this.u_spotLights0color) - this.spotLightsLoc;
        this.spotLightsPositionOffset = this.loc(this.u_spotLights0position) - this.spotLightsLoc;
        this.spotLightsDirectionOffset = this.loc(this.u_spotLights0direction) - this.spotLightsLoc;
        n2 = n;
        if (this.has(this.u_spotLights0intensity)) {
            n2 = this.loc(this.u_spotLights0intensity) - this.spotLightsLoc;
        }
        this.spotLightsIntensityOffset = n2;
        this.spotLightsCutoffAngleOffset = this.loc(this.u_spotLights0cutoffAngle) - this.spotLightsLoc;
        this.spotLightsExponentOffset = this.loc(this.u_spotLights0exponent) - this.spotLightsLoc;
        this.spotLightsSize = this.loc(this.u_spotLights1color) - this.spotLightsLoc;
        if (this.spotLightsSize < 0) {
            this.spotLightsSize = 0;
        }
    }

    @Override
    public void render(Renderable renderable, Attributes attributes) {
        if (!attributes.has(BlendingAttribute.Type)) {
            this.context.setBlending(false, 770, 771);
        }
        this.bindMaterial(attributes);
        if (this.lighting) {
            this.bindLights(renderable, attributes);
        }
        super.render(renderable, attributes);
    }

    public void setDefaultCullFace(int n) {
        this.config.defaultCullFace = n;
    }

    public void setDefaultDepthFunc(int n) {
        this.config.defaultDepthFunc = n;
    }

    public static class Config {
        public int defaultCullFace = -1;
        public int defaultDepthFunc = -1;
        public String fragmentShader = null;
        public boolean ignoreUnimplemented = true;
        public int numBones = 12;
        public int numDirectionalLights = 2;
        public int numPointLights = 5;
        public int numSpotLights = 0;
        public String vertexShader = null;

        public Config() {
        }

        public Config(String string2, String string3) {
            this.vertexShader = string2;
            this.fragmentShader = string3;
        }
    }

    public static class Inputs {
        public static final BaseShader.Uniform alphaTest;
        public static final BaseShader.Uniform ambientCube;
        public static final BaseShader.Uniform ambientTexture;
        public static final BaseShader.Uniform ambientUVTransform;
        public static final BaseShader.Uniform bones;
        public static final BaseShader.Uniform cameraDirection;
        public static final BaseShader.Uniform cameraNearFar;
        public static final BaseShader.Uniform cameraPosition;
        public static final BaseShader.Uniform cameraUp;
        public static final BaseShader.Uniform diffuseColor;
        public static final BaseShader.Uniform diffuseTexture;
        public static final BaseShader.Uniform diffuseUVTransform;
        public static final BaseShader.Uniform dirLights;
        public static final BaseShader.Uniform emissiveColor;
        public static final BaseShader.Uniform emissiveTexture;
        public static final BaseShader.Uniform emissiveUVTransform;
        public static final BaseShader.Uniform environmentCubemap;
        public static final BaseShader.Uniform normalMatrix;
        public static final BaseShader.Uniform normalTexture;
        public static final BaseShader.Uniform normalUVTransform;
        public static final BaseShader.Uniform opacity;
        public static final BaseShader.Uniform pointLights;
        public static final BaseShader.Uniform projTrans;
        public static final BaseShader.Uniform projViewTrans;
        public static final BaseShader.Uniform projViewWorldTrans;
        public static final BaseShader.Uniform reflectionColor;
        public static final BaseShader.Uniform reflectionTexture;
        public static final BaseShader.Uniform reflectionUVTransform;
        public static final BaseShader.Uniform shininess;
        public static final BaseShader.Uniform specularColor;
        public static final BaseShader.Uniform specularTexture;
        public static final BaseShader.Uniform specularUVTransform;
        public static final BaseShader.Uniform spotLights;
        public static final BaseShader.Uniform viewTrans;
        public static final BaseShader.Uniform viewWorldTrans;
        public static final BaseShader.Uniform worldTrans;

        static {
            projTrans = new BaseShader.Uniform("u_projTrans");
            viewTrans = new BaseShader.Uniform("u_viewTrans");
            projViewTrans = new BaseShader.Uniform("u_projViewTrans");
            cameraPosition = new BaseShader.Uniform("u_cameraPosition");
            cameraDirection = new BaseShader.Uniform("u_cameraDirection");
            cameraUp = new BaseShader.Uniform("u_cameraUp");
            cameraNearFar = new BaseShader.Uniform("u_cameraNearFar");
            worldTrans = new BaseShader.Uniform("u_worldTrans");
            viewWorldTrans = new BaseShader.Uniform("u_viewWorldTrans");
            projViewWorldTrans = new BaseShader.Uniform("u_projViewWorldTrans");
            normalMatrix = new BaseShader.Uniform("u_normalMatrix");
            bones = new BaseShader.Uniform("u_bones");
            shininess = new BaseShader.Uniform("u_shininess", FloatAttribute.Shininess);
            opacity = new BaseShader.Uniform("u_opacity", BlendingAttribute.Type);
            diffuseColor = new BaseShader.Uniform("u_diffuseColor", ColorAttribute.Diffuse);
            diffuseTexture = new BaseShader.Uniform("u_diffuseTexture", TextureAttribute.Diffuse);
            diffuseUVTransform = new BaseShader.Uniform("u_diffuseUVTransform", TextureAttribute.Diffuse);
            specularColor = new BaseShader.Uniform("u_specularColor", ColorAttribute.Specular);
            specularTexture = new BaseShader.Uniform("u_specularTexture", TextureAttribute.Specular);
            specularUVTransform = new BaseShader.Uniform("u_specularUVTransform", TextureAttribute.Specular);
            emissiveColor = new BaseShader.Uniform("u_emissiveColor", ColorAttribute.Emissive);
            emissiveTexture = new BaseShader.Uniform("u_emissiveTexture", TextureAttribute.Emissive);
            emissiveUVTransform = new BaseShader.Uniform("u_emissiveUVTransform", TextureAttribute.Emissive);
            reflectionColor = new BaseShader.Uniform("u_reflectionColor", ColorAttribute.Reflection);
            reflectionTexture = new BaseShader.Uniform("u_reflectionTexture", TextureAttribute.Reflection);
            reflectionUVTransform = new BaseShader.Uniform("u_reflectionUVTransform", TextureAttribute.Reflection);
            normalTexture = new BaseShader.Uniform("u_normalTexture", TextureAttribute.Normal);
            normalUVTransform = new BaseShader.Uniform("u_normalUVTransform", TextureAttribute.Normal);
            ambientTexture = new BaseShader.Uniform("u_ambientTexture", TextureAttribute.Ambient);
            ambientUVTransform = new BaseShader.Uniform("u_ambientUVTransform", TextureAttribute.Ambient);
            alphaTest = new BaseShader.Uniform("u_alphaTest");
            ambientCube = new BaseShader.Uniform("u_ambientCubemap");
            dirLights = new BaseShader.Uniform("u_dirLights");
            pointLights = new BaseShader.Uniform("u_pointLights");
            spotLights = new BaseShader.Uniform("u_spotLights");
            environmentCubemap = new BaseShader.Uniform("u_environmentCubemap");
        }
    }

    public static class Setters {
        public static final BaseShader.Setter ambientTexture;
        public static final BaseShader.Setter ambientUVTransform;
        public static final BaseShader.Setter cameraDirection;
        public static final BaseShader.Setter cameraNearFar;
        public static final BaseShader.Setter cameraPosition;
        public static final BaseShader.Setter cameraUp;
        public static final BaseShader.Setter diffuseColor;
        public static final BaseShader.Setter diffuseTexture;
        public static final BaseShader.Setter diffuseUVTransform;
        public static final BaseShader.Setter emissiveColor;
        public static final BaseShader.Setter emissiveTexture;
        public static final BaseShader.Setter emissiveUVTransform;
        public static final BaseShader.Setter environmentCubemap;
        public static final BaseShader.Setter normalMatrix;
        public static final BaseShader.Setter normalTexture;
        public static final BaseShader.Setter normalUVTransform;
        public static final BaseShader.Setter projTrans;
        public static final BaseShader.Setter projViewTrans;
        public static final BaseShader.Setter projViewWorldTrans;
        public static final BaseShader.Setter reflectionColor;
        public static final BaseShader.Setter reflectionTexture;
        public static final BaseShader.Setter reflectionUVTransform;
        public static final BaseShader.Setter shininess;
        public static final BaseShader.Setter specularColor;
        public static final BaseShader.Setter specularTexture;
        public static final BaseShader.Setter specularUVTransform;
        public static final BaseShader.Setter viewTrans;
        public static final BaseShader.Setter viewWorldTrans;
        public static final BaseShader.Setter worldTrans;

        static {
            projTrans = new BaseShader.GlobalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.camera.projection);
                }
            };
            viewTrans = new BaseShader.GlobalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.camera.view);
                }
            };
            projViewTrans = new BaseShader.GlobalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.camera.combined);
                }
            };
            cameraPosition = new BaseShader.GlobalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.camera.position.x, baseShader.camera.position.y, baseShader.camera.position.z, 1.1881f / (baseShader.camera.far * baseShader.camera.far));
                }
            };
            cameraDirection = new BaseShader.GlobalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.camera.direction);
                }
            };
            cameraUp = new BaseShader.GlobalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.camera.up);
                }
            };
            cameraNearFar = new BaseShader.GlobalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.camera.near, baseShader.camera.far);
                }
            };
            worldTrans = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, renderable.worldTransform);
                }
            };
            viewWorldTrans = new BaseShader.LocalSetter(){
                final Matrix4 temp = new Matrix4();

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, this.temp.set(baseShader.camera.view).mul(renderable.worldTransform));
                }
            };
            projViewWorldTrans = new BaseShader.LocalSetter(){
                final Matrix4 temp = new Matrix4();

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, this.temp.set(baseShader.camera.combined).mul(renderable.worldTransform));
                }
            };
            normalMatrix = new BaseShader.LocalSetter(){
                private final Matrix3 tmpM = new Matrix3();

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, this.tmpM.set(renderable.worldTransform).inv().transpose());
                }
            };
            shininess = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, ((FloatAttribute)attributes.get((long)FloatAttribute.Shininess)).value);
                }
            };
            diffuseColor = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, ((ColorAttribute)attributes.get((long)ColorAttribute.Diffuse)).color);
                }
            };
            diffuseTexture = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.context.textureBinder.bind(((TextureAttribute)attributes.get((long)TextureAttribute.Diffuse)).textureDescription));
                }
            };
            diffuseUVTransform = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable object, Attributes attributes) {
                    object = (TextureAttribute)attributes.get(TextureAttribute.Diffuse);
                    baseShader.set(n, ((TextureAttribute)object).offsetU, ((TextureAttribute)object).offsetV, ((TextureAttribute)object).scaleU, ((TextureAttribute)object).scaleV);
                }
            };
            specularColor = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, ((ColorAttribute)attributes.get((long)ColorAttribute.Specular)).color);
                }
            };
            specularTexture = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.context.textureBinder.bind(((TextureAttribute)attributes.get((long)TextureAttribute.Specular)).textureDescription));
                }
            };
            specularUVTransform = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable object, Attributes attributes) {
                    object = (TextureAttribute)attributes.get(TextureAttribute.Specular);
                    baseShader.set(n, ((TextureAttribute)object).offsetU, ((TextureAttribute)object).offsetV, ((TextureAttribute)object).scaleU, ((TextureAttribute)object).scaleV);
                }
            };
            emissiveColor = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, ((ColorAttribute)attributes.get((long)ColorAttribute.Emissive)).color);
                }
            };
            emissiveTexture = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.context.textureBinder.bind(((TextureAttribute)attributes.get((long)TextureAttribute.Emissive)).textureDescription));
                }
            };
            emissiveUVTransform = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable object, Attributes attributes) {
                    object = (TextureAttribute)attributes.get(TextureAttribute.Emissive);
                    baseShader.set(n, ((TextureAttribute)object).offsetU, ((TextureAttribute)object).offsetV, ((TextureAttribute)object).scaleU, ((TextureAttribute)object).scaleV);
                }
            };
            reflectionColor = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, ((ColorAttribute)attributes.get((long)ColorAttribute.Reflection)).color);
                }
            };
            reflectionTexture = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.context.textureBinder.bind(((TextureAttribute)attributes.get((long)TextureAttribute.Reflection)).textureDescription));
                }
            };
            reflectionUVTransform = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable object, Attributes attributes) {
                    object = (TextureAttribute)attributes.get(TextureAttribute.Reflection);
                    baseShader.set(n, ((TextureAttribute)object).offsetU, ((TextureAttribute)object).offsetV, ((TextureAttribute)object).scaleU, ((TextureAttribute)object).scaleV);
                }
            };
            normalTexture = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.context.textureBinder.bind(((TextureAttribute)attributes.get((long)TextureAttribute.Normal)).textureDescription));
                }
            };
            normalUVTransform = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable object, Attributes attributes) {
                    object = (TextureAttribute)attributes.get(TextureAttribute.Normal);
                    baseShader.set(n, ((TextureAttribute)object).offsetU, ((TextureAttribute)object).offsetV, ((TextureAttribute)object).scaleU, ((TextureAttribute)object).scaleV);
                }
            };
            ambientTexture = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    baseShader.set(n, baseShader.context.textureBinder.bind(((TextureAttribute)attributes.get((long)TextureAttribute.Ambient)).textureDescription));
                }
            };
            ambientUVTransform = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable object, Attributes attributes) {
                    object = (TextureAttribute)attributes.get(TextureAttribute.Ambient);
                    baseShader.set(n, ((TextureAttribute)object).offsetU, ((TextureAttribute)object).offsetV, ((TextureAttribute)object).scaleU, ((TextureAttribute)object).scaleV);
                }
            };
            environmentCubemap = new BaseShader.LocalSetter(){

                @Override
                public void set(BaseShader baseShader, int n, Renderable renderable, Attributes attributes) {
                    if (attributes.has(CubemapAttribute.EnvironmentMap)) {
                        baseShader.set(n, baseShader.context.textureBinder.bind(((CubemapAttribute)attributes.get((long)CubemapAttribute.EnvironmentMap)).textureDescription));
                    }
                }
            };
        }

        public static class ACubemap
        extends BaseShader.LocalSetter {
            private static final float[] ones = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            private static final Vector3 tmpV1 = new Vector3();
            private final AmbientCubemap cacheAmbientCubemap = new AmbientCubemap();
            public final int dirLightsOffset;
            public final int pointLightsOffset;

            public ACubemap(int n, int n2) {
                this.dirLightsOffset = n;
                this.pointLightsOffset = n2;
            }

            @Override
            public void set(BaseShader object, int n, Renderable array, Attributes attributes) {
                if (((Renderable)((Object)array)).environment == null) {
                    array = ((BaseShader)object).program;
                    n = ((BaseShader)object).loc(n);
                    object = ones;
                    ((ShaderProgram)((Object)array)).setUniform3fv(n, (float[])object, 0, ((Object)object).length);
                } else {
                    int n2;
                    ((Renderable)((Object)array)).worldTransform.getTranslation(tmpV1);
                    if (attributes.has(ColorAttribute.AmbientLight)) {
                        this.cacheAmbientCubemap.set(((ColorAttribute)attributes.get((long)ColorAttribute.AmbientLight)).color);
                    }
                    if (attributes.has(DirectionalLightsAttribute.Type)) {
                        array = ((DirectionalLightsAttribute)attributes.get((long)DirectionalLightsAttribute.Type)).lights;
                        for (n2 = this.dirLightsOffset; n2 < array.size; ++n2) {
                            this.cacheAmbientCubemap.add(((DirectionalLight)array.get((int)n2)).color, ((DirectionalLight)array.get((int)n2)).direction);
                        }
                    }
                    if (attributes.has(PointLightsAttribute.Type)) {
                        array = ((PointLightsAttribute)attributes.get((long)PointLightsAttribute.Type)).lights;
                        for (n2 = this.pointLightsOffset; n2 < array.size; ++n2) {
                            this.cacheAmbientCubemap.add(((PointLight)array.get((int)n2)).color, ((PointLight)array.get((int)n2)).position, tmpV1, ((PointLight)array.get((int)n2)).intensity);
                        }
                    }
                    this.cacheAmbientCubemap.clamp();
                    ((BaseShader)object).program.setUniform3fv(((BaseShader)object).loc(n), this.cacheAmbientCubemap.data, 0, this.cacheAmbientCubemap.data.length);
                }
            }
        }

        public static class Bones
        extends BaseShader.LocalSetter {
            private static final Matrix4 idtMatrix = new Matrix4();
            public final float[] bones;

            public Bones(int n) {
                this.bones = new float[n * 16];
            }

            @Override
            public void set(BaseShader object, int n, Renderable object2, Attributes object3) {
                for (int i = 0; i < ((Object)(object3 = (Object)this.bones)).length; ++i) {
                    int n2 = i / 16;
                    float f = ((Renderable)object2).bones != null && n2 < ((Renderable)object2).bones.length && ((Renderable)object2).bones[n2] != null ? ((Renderable)object2).bones[n2].val[i % 16] : Bones.idtMatrix.val[i % 16];
                    object3[i] = f;
                }
                object2 = ((BaseShader)object).program;
                n = ((BaseShader)object).loc(n);
                object = this.bones;
                ((ShaderProgram)object2).setUniformMatrix4fv(n, (float[])object, 0, ((Object)object).length);
            }
        }
    }
}

