/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public abstract class RegionInfluencer
extends Influencer {
    ParallelArray.FloatChannel regionChannel;
    public Array<AspectTextureRegion> regions;

    public RegionInfluencer() {
        this(1);
        AspectTextureRegion aspectTextureRegion = new AspectTextureRegion();
        aspectTextureRegion.v = 0.0f;
        aspectTextureRegion.u = 0.0f;
        aspectTextureRegion.v2 = 1.0f;
        aspectTextureRegion.u2 = 1.0f;
        aspectTextureRegion.halfInvAspectRatio = 0.5f;
        this.regions.add(aspectTextureRegion);
    }

    public RegionInfluencer(int n) {
        this.regions = new Array(false, n, AspectTextureRegion.class);
    }

    public RegionInfluencer(Texture texture) {
        this(new TextureRegion(texture));
    }

    public RegionInfluencer(RegionInfluencer regionInfluencer) {
        this(regionInfluencer.regions.size);
        this.regions.ensureCapacity(regionInfluencer.regions.size);
        for (int i = 0; i < regionInfluencer.regions.size; ++i) {
            this.regions.add(new AspectTextureRegion(regionInfluencer.regions.get(i)));
        }
    }

    public RegionInfluencer(TextureRegion ... textureRegionArray) {
        this.regions = new Array(false, textureRegionArray.length, AspectTextureRegion.class);
        this.add(textureRegionArray);
    }

    public void add(TextureRegion ... textureRegionArray) {
        this.regions.ensureCapacity(textureRegionArray.length);
        for (TextureRegion textureRegion : textureRegionArray) {
            this.regions.add(new AspectTextureRegion(textureRegion));
        }
    }

    @Override
    public void allocateChannels() {
        this.regionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.TextureRegion);
    }

    public void clear() {
        this.regions.clear();
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.regions.clear();
        this.regions.addAll((Array)((Object)json.readValue("regions", Array.class, AspectTextureRegion.class, jsonValue)));
    }

    @Override
    public void write(Json json) {
        json.writeValue("regions", this.regions, Array.class, AspectTextureRegion.class);
    }

    public static class Animated
    extends RegionInfluencer {
        ParallelArray.FloatChannel lifeChannel;

        public Animated() {
        }

        public Animated(Texture texture) {
            super(texture);
        }

        public Animated(TextureRegion textureRegion) {
            super(textureRegion);
        }

        public Animated(Animated animated) {
            super(animated);
        }

        @Override
        public void allocateChannels() {
            super.allocateChannels();
            this.lifeChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Life);
        }

        @Override
        public Animated copy() {
            return new Animated(this);
        }

        @Override
        public void update() {
            int n = this.controller.particles.size;
            int n2 = this.regionChannel.strideSize;
            int n3 = 2;
            int n4 = 0;
            while (n4 < n * n2) {
                AspectTextureRegion aspectTextureRegion = (AspectTextureRegion)this.regions.get((int)(this.lifeChannel.data[n3] * (float)(this.regions.size - 1)));
                this.regionChannel.data[n4 + 0] = aspectTextureRegion.u;
                this.regionChannel.data[n4 + 1] = aspectTextureRegion.v;
                this.regionChannel.data[n4 + 2] = aspectTextureRegion.u2;
                this.regionChannel.data[n4 + 3] = aspectTextureRegion.v2;
                this.regionChannel.data[n4 + 4] = 0.5f;
                this.regionChannel.data[n4 + 5] = aspectTextureRegion.halfInvAspectRatio;
                n4 += this.regionChannel.strideSize;
                n3 += this.lifeChannel.strideSize;
            }
        }
    }

    public static class AspectTextureRegion {
        public float halfInvAspectRatio;
        public float u;
        public float u2;
        public float v;
        public float v2;

        public AspectTextureRegion() {
        }

        public AspectTextureRegion(TextureRegion textureRegion) {
            this.set(textureRegion);
        }

        public AspectTextureRegion(AspectTextureRegion aspectTextureRegion) {
            this.set(aspectTextureRegion);
        }

        public void set(TextureRegion textureRegion) {
            this.u = textureRegion.getU();
            this.v = textureRegion.getV();
            this.u2 = textureRegion.getU2();
            this.v2 = textureRegion.getV2();
            this.halfInvAspectRatio = (float)textureRegion.getRegionHeight() / (float)textureRegion.getRegionWidth() * 0.5f;
        }

        public void set(AspectTextureRegion aspectTextureRegion) {
            this.u = aspectTextureRegion.u;
            this.v = aspectTextureRegion.v;
            this.u2 = aspectTextureRegion.u2;
            this.v2 = aspectTextureRegion.v2;
            this.halfInvAspectRatio = aspectTextureRegion.halfInvAspectRatio;
        }
    }

    public static class Random
    extends RegionInfluencer {
        public Random() {
        }

        public Random(Texture texture) {
            super(texture);
        }

        public Random(TextureRegion textureRegion) {
            super(textureRegion);
        }

        public Random(Random random) {
            super(random);
        }

        @Override
        public void activateParticles(int n, int n2) {
            int n3 = n * this.regionChannel.strideSize;
            int n4 = this.regionChannel.strideSize;
            for (n = n3; n < n2 * n4 + n3; n += this.regionChannel.strideSize) {
                AspectTextureRegion aspectTextureRegion = (AspectTextureRegion)this.regions.random();
                this.regionChannel.data[n + 0] = aspectTextureRegion.u;
                this.regionChannel.data[n + 1] = aspectTextureRegion.v;
                this.regionChannel.data[n + 2] = aspectTextureRegion.u2;
                this.regionChannel.data[n + 3] = aspectTextureRegion.v2;
                this.regionChannel.data[n + 4] = 0.5f;
                this.regionChannel.data[n + 5] = aspectTextureRegion.halfInvAspectRatio;
            }
        }

        @Override
        public Random copy() {
            return new Random(this);
        }
    }

    public static class Single
    extends RegionInfluencer {
        public Single() {
        }

        public Single(Texture texture) {
            super(texture);
        }

        public Single(TextureRegion textureRegion) {
            super(textureRegion);
        }

        public Single(Single single) {
            super(single);
        }

        @Override
        public Single copy() {
            return new Single(this);
        }

        @Override
        public void init() {
            Object object = (AspectTextureRegion[])this.regions.items;
            object = object[0];
            int n = this.controller.emitter.maxParticleCount;
            int n2 = this.regionChannel.strideSize;
            for (int i = 0; i < n * n2; i += this.regionChannel.strideSize) {
                this.regionChannel.data[i + 0] = object.u;
                this.regionChannel.data[i + 1] = object.v;
                this.regionChannel.data[i + 2] = object.u2;
                this.regionChannel.data[i + 3] = object.v2;
                this.regionChannel.data[i + 4] = 0.5f;
                this.regionChannel.data[i + 5] = object.halfInvAspectRatio;
            }
        }
    }
}

