/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public abstract class ModelInfluencer
extends Influencer {
    ParallelArray.ObjectChannel<ModelInstance> modelChannel;
    public Array<Model> models;

    public ModelInfluencer() {
        this.models = new Array(true, 1, Model.class);
    }

    public ModelInfluencer(ModelInfluencer modelInfluencer) {
        this(modelInfluencer.models.toArray(Model.class));
    }

    public ModelInfluencer(Model ... modelArray) {
        this.models = new Array<Model>(modelArray);
    }

    @Override
    public void allocateChannels() {
        this.modelChannel = (ParallelArray.ObjectChannel)this.controller.particles.addChannel(ParticleChannels.ModelInstance);
    }

    @Override
    public void load(AssetManager assetManager, ResourceData serializable) {
        Object object;
        serializable = ((ResourceData)serializable).getSaveData();
        while ((object = ((ResourceData.SaveData)serializable).loadAsset()) != null) {
            if ((object = (Model)assetManager.get(object)) != null) {
                this.models.add((Model)object);
                continue;
            }
            throw new RuntimeException("Model is null");
        }
    }

    @Override
    public void save(AssetManager assetManager, ResourceData object) {
        ResourceData.SaveData saveData = ((ResourceData)object).createSaveData();
        object = this.models.iterator();
        while (object.hasNext()) {
            saveData.saveAsset(assetManager.getAssetFileName((Model)object.next()), Model.class);
        }
    }

    public static class Random
    extends ModelInfluencer {
        ModelInstancePool pool = new ModelInstancePool();

        public Random() {
        }

        public Random(Random random) {
            super(random);
        }

        public Random(Model ... modelArray) {
            super(modelArray);
        }

        @Override
        public void activateParticles(int n, int n2) {
            for (int i = n; i < n2 + n; ++i) {
                ((ModelInstance[])this.modelChannel.data)[i] = (ModelInstance)this.pool.obtain();
            }
        }

        @Override
        public Random copy() {
            return new Random(this);
        }

        @Override
        public void init() {
            this.pool.clear();
        }

        @Override
        public void killParticles(int n, int n2) {
            for (int i = n; i < n2 + n; ++i) {
                this.pool.free(((ModelInstance[])this.modelChannel.data)[i]);
                ((ModelInstance[])this.modelChannel.data)[i] = null;
            }
        }

        private class ModelInstancePool
        extends Pool<ModelInstance> {
            @Override
            public ModelInstance newObject() {
                return new ModelInstance((Model)Random.this.models.random());
            }
        }
    }

    public static class Single
    extends ModelInfluencer {
        public Single() {
        }

        public Single(Single single) {
            super(single);
        }

        public Single(Model ... modelArray) {
            super(modelArray);
        }

        @Override
        public Single copy() {
            return new Single(this);
        }

        @Override
        public void init() {
            Model model = (Model)this.models.first();
            int n = this.controller.emitter.maxParticleCount;
            for (int i = 0; i < n; ++i) {
                ((ModelInstance[])this.modelChannel.data)[i] = new ModelInstance(model);
            }
        }
    }
}

