/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.attributes;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;

public class TextureAttribute
extends Attribute {
    public static final long Ambient;
    public static final String AmbientAlias = "ambientTexture";
    public static final long Bump;
    public static final String BumpAlias = "bumpTexture";
    public static final long Diffuse;
    public static final String DiffuseAlias = "diffuseTexture";
    public static final long Emissive;
    public static final String EmissiveAlias = "emissiveTexture";
    protected static long Mask = 0L;
    public static final long Normal;
    public static final String NormalAlias = "normalTexture";
    public static final long Reflection;
    public static final String ReflectionAlias = "reflectionTexture";
    public static final long Specular;
    public static final String SpecularAlias = "specularTexture";
    public float offsetU = 0.0f;
    public float offsetV = 0.0f;
    public float scaleU = 1.0f;
    public float scaleV = 1.0f;
    public final TextureDescriptor<Texture> textureDescription;
    public int uvIndex = 0;

    static {
        Diffuse = TextureAttribute.register(DiffuseAlias);
        Specular = TextureAttribute.register(SpecularAlias);
        Bump = TextureAttribute.register(BumpAlias);
        Normal = TextureAttribute.register(NormalAlias);
        Ambient = TextureAttribute.register(AmbientAlias);
        Emissive = TextureAttribute.register(EmissiveAlias);
        Reflection = TextureAttribute.register(ReflectionAlias);
        Mask = Diffuse | Specular | Bump | Normal | Ambient | Emissive | Reflection;
    }

    public TextureAttribute(long l) {
        super(l);
        if (TextureAttribute.is(l)) {
            this.textureDescription = new TextureDescriptor();
            return;
        }
        throw new GdxRuntimeException("Invalid type specified");
    }

    public TextureAttribute(long l, Texture texture) {
        this(l);
        this.textureDescription.texture = texture;
    }

    public TextureAttribute(long l, TextureRegion textureRegion) {
        this(l);
        this.set(textureRegion);
    }

    public <T extends Texture> TextureAttribute(long l, TextureDescriptor<T> textureDescriptor) {
        this(l);
        this.textureDescription.set(textureDescriptor);
    }

    public <T extends Texture> TextureAttribute(long l, TextureDescriptor<T> textureDescriptor, float f, float f2, float f3, float f4) {
        this(l, textureDescriptor, f, f2, f3, f4, 0);
    }

    public <T extends Texture> TextureAttribute(long l, TextureDescriptor<T> textureDescriptor, float f, float f2, float f3, float f4, int n) {
        this(l, textureDescriptor);
        this.offsetU = f;
        this.offsetV = f2;
        this.scaleU = f3;
        this.scaleV = f4;
        this.uvIndex = n;
    }

    public TextureAttribute(TextureAttribute textureAttribute) {
        this(textureAttribute.type, textureAttribute.textureDescription, textureAttribute.offsetU, textureAttribute.offsetV, textureAttribute.scaleU, textureAttribute.scaleV, textureAttribute.uvIndex);
    }

    public static TextureAttribute createAmbient(Texture texture) {
        return new TextureAttribute(Ambient, texture);
    }

    public static TextureAttribute createAmbient(TextureRegion textureRegion) {
        return new TextureAttribute(Ambient, textureRegion);
    }

    public static TextureAttribute createBump(Texture texture) {
        return new TextureAttribute(Bump, texture);
    }

    public static TextureAttribute createBump(TextureRegion textureRegion) {
        return new TextureAttribute(Bump, textureRegion);
    }

    public static TextureAttribute createDiffuse(Texture texture) {
        return new TextureAttribute(Diffuse, texture);
    }

    public static TextureAttribute createDiffuse(TextureRegion textureRegion) {
        return new TextureAttribute(Diffuse, textureRegion);
    }

    public static TextureAttribute createEmissive(Texture texture) {
        return new TextureAttribute(Emissive, texture);
    }

    public static TextureAttribute createEmissive(TextureRegion textureRegion) {
        return new TextureAttribute(Emissive, textureRegion);
    }

    public static TextureAttribute createNormal(Texture texture) {
        return new TextureAttribute(Normal, texture);
    }

    public static TextureAttribute createNormal(TextureRegion textureRegion) {
        return new TextureAttribute(Normal, textureRegion);
    }

    public static TextureAttribute createReflection(Texture texture) {
        return new TextureAttribute(Reflection, texture);
    }

    public static TextureAttribute createReflection(TextureRegion textureRegion) {
        return new TextureAttribute(Reflection, textureRegion);
    }

    public static TextureAttribute createSpecular(Texture texture) {
        return new TextureAttribute(Specular, texture);
    }

    public static TextureAttribute createSpecular(TextureRegion textureRegion) {
        return new TextureAttribute(Specular, textureRegion);
    }

    public static final boolean is(long l) {
        boolean bl = (l & Mask) != 0L;
        return bl;
    }

    @Override
    public int compareTo(Attribute attribute) {
        long l = this.type;
        long l2 = attribute.type;
        int n = -1;
        if (l != l2) {
            if (this.type >= attribute.type) {
                n = 1;
            }
            return n;
        }
        attribute = (TextureAttribute)attribute;
        int n2 = this.textureDescription.compareTo(((TextureAttribute)attribute).textureDescription);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.uvIndex;
        int n3 = ((TextureAttribute)attribute).uvIndex;
        if (n2 != n3) {
            return n2 - n3;
        }
        if (!MathUtils.isEqual(this.scaleU, ((TextureAttribute)attribute).scaleU)) {
            if (this.scaleU > ((TextureAttribute)attribute).scaleU) {
                n = 1;
            }
            return n;
        }
        if (!MathUtils.isEqual(this.scaleV, ((TextureAttribute)attribute).scaleV)) {
            if (this.scaleV > ((TextureAttribute)attribute).scaleV) {
                n = 1;
            }
            return n;
        }
        if (!MathUtils.isEqual(this.offsetU, ((TextureAttribute)attribute).offsetU)) {
            if (this.offsetU > ((TextureAttribute)attribute).offsetU) {
                n = 1;
            }
            return n;
        }
        if (!MathUtils.isEqual(this.offsetV, ((TextureAttribute)attribute).offsetV)) {
            if (this.offsetV > ((TextureAttribute)attribute).offsetV) {
                n = 1;
            }
            return n;
        }
        return 0;
    }

    @Override
    public Attribute copy() {
        return new TextureAttribute(this);
    }

    @Override
    public int hashCode() {
        return (((((super.hashCode() * 991 + this.textureDescription.hashCode()) * 991 + NumberUtils.floatToRawIntBits(this.offsetU)) * 991 + NumberUtils.floatToRawIntBits(this.offsetV)) * 991 + NumberUtils.floatToRawIntBits(this.scaleU)) * 991 + NumberUtils.floatToRawIntBits(this.scaleV)) * 991 + this.uvIndex;
    }

    public void set(TextureRegion textureRegion) {
        this.textureDescription.texture = textureRegion.getTexture();
        this.offsetU = textureRegion.getU();
        this.offsetV = textureRegion.getV();
        this.scaleU = textureRegion.getU2() - this.offsetU;
        this.scaleV = textureRegion.getV2() - this.offsetV;
    }
}

