/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.SpotLightsAttribute;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.ShadowMap;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Environment
extends Attributes {
    public ShadowMap shadowMap;

    public Environment add(BaseLight baseLight) {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (!(baseLight instanceof DirectionalLight)) break block2;
                        this.add((DirectionalLight)baseLight);
                        break block3;
                    }
                    if (!(baseLight instanceof PointLight)) break block4;
                    this.add((PointLight)baseLight);
                    break block3;
                }
                if (!(baseLight instanceof SpotLight)) break block5;
                this.add((SpotLight)baseLight);
            }
            return this;
        }
        throw new GdxRuntimeException("Unknown light type");
    }

    public Environment add(DirectionalLight directionalLight) {
        DirectionalLightsAttribute directionalLightsAttribute;
        DirectionalLightsAttribute directionalLightsAttribute2 = directionalLightsAttribute = (DirectionalLightsAttribute)this.get(DirectionalLightsAttribute.Type);
        if (directionalLightsAttribute == null) {
            directionalLightsAttribute2 = new DirectionalLightsAttribute();
            this.set((Attribute)directionalLightsAttribute2);
        }
        directionalLightsAttribute2.lights.add(directionalLight);
        return this;
    }

    public Environment add(PointLight pointLight) {
        PointLightsAttribute pointLightsAttribute;
        PointLightsAttribute pointLightsAttribute2 = pointLightsAttribute = (PointLightsAttribute)this.get(PointLightsAttribute.Type);
        if (pointLightsAttribute == null) {
            pointLightsAttribute2 = new PointLightsAttribute();
            this.set((Attribute)pointLightsAttribute2);
        }
        pointLightsAttribute2.lights.add(pointLight);
        return this;
    }

    public Environment add(SpotLight spotLight) {
        SpotLightsAttribute spotLightsAttribute;
        SpotLightsAttribute spotLightsAttribute2 = spotLightsAttribute = (SpotLightsAttribute)this.get(SpotLightsAttribute.Type);
        if (spotLightsAttribute == null) {
            spotLightsAttribute2 = new SpotLightsAttribute();
            this.set((Attribute)spotLightsAttribute2);
        }
        spotLightsAttribute2.lights.add(spotLight);
        return this;
    }

    public Environment add(Array<BaseLight> object) {
        object = ((Array)object).iterator();
        while (object.hasNext()) {
            this.add((BaseLight)object.next());
        }
        return this;
    }

    public Environment add(BaseLight ... baseLightArray) {
        int n = baseLightArray.length;
        for (int i = 0; i < n; ++i) {
            this.add(baseLightArray[i]);
        }
        return this;
    }

    public Environment remove(BaseLight baseLight) {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (!(baseLight instanceof DirectionalLight)) break block2;
                        this.remove((DirectionalLight)baseLight);
                        break block3;
                    }
                    if (!(baseLight instanceof PointLight)) break block4;
                    this.remove((PointLight)baseLight);
                    break block3;
                }
                if (!(baseLight instanceof SpotLight)) break block5;
                this.remove((SpotLight)baseLight);
            }
            return this;
        }
        throw new GdxRuntimeException("Unknown light type");
    }

    public Environment remove(DirectionalLight directionalLight) {
        if (this.has(DirectionalLightsAttribute.Type)) {
            DirectionalLightsAttribute directionalLightsAttribute = (DirectionalLightsAttribute)this.get(DirectionalLightsAttribute.Type);
            directionalLightsAttribute.lights.removeValue(directionalLight, false);
            if (directionalLightsAttribute.lights.size == 0) {
                this.remove(DirectionalLightsAttribute.Type);
            }
        }
        return this;
    }

    public Environment remove(PointLight pointLight) {
        if (this.has(PointLightsAttribute.Type)) {
            PointLightsAttribute pointLightsAttribute = (PointLightsAttribute)this.get(PointLightsAttribute.Type);
            pointLightsAttribute.lights.removeValue(pointLight, false);
            if (pointLightsAttribute.lights.size == 0) {
                this.remove(PointLightsAttribute.Type);
            }
        }
        return this;
    }

    public Environment remove(SpotLight spotLight) {
        if (this.has(SpotLightsAttribute.Type)) {
            SpotLightsAttribute spotLightsAttribute = (SpotLightsAttribute)this.get(SpotLightsAttribute.Type);
            spotLightsAttribute.lights.removeValue(spotLight, false);
            if (spotLightsAttribute.lights.size == 0) {
                this.remove(SpotLightsAttribute.Type);
            }
        }
        return this;
    }

    public Environment remove(Array<BaseLight> object) {
        object = ((Array)object).iterator();
        while (object.hasNext()) {
            this.remove((BaseLight)object.next());
        }
        return this;
    }

    public Environment remove(BaseLight ... baseLightArray) {
        int n = baseLightArray.length;
        for (int i = 0; i < n; ++i) {
            this.remove(baseLightArray[i]);
        }
        return this;
    }
}

