/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.NumberUtils;

public class Sprite
extends TextureRegion {
    static final int SPRITE_SIZE = 20;
    static final int VERTEX_SIZE = 5;
    private Rectangle bounds;
    private final Color color;
    private boolean dirty = true;
    float height;
    private float originX;
    private float originY;
    private float rotation;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    final float[] vertices = new float[20];
    float width;
    private float x;
    private float y;

    public Sprite() {
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Sprite(Texture texture) {
        this(texture, 0, 0, texture.getWidth(), texture.getHeight());
    }

    public Sprite(Texture texture, int n, int n2) {
        this(texture, 0, 0, n, n2);
    }

    public Sprite(Texture texture, int n, int n2, int n3, int n4) {
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        if (texture != null) {
            this.texture = texture;
            this.setRegion(n, n2, n3, n4);
            this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.setSize(Math.abs(n3), Math.abs(n4));
            this.setOrigin(this.width / 2.0f, this.height / 2.0f);
            return;
        }
        throw new IllegalArgumentException("texture cannot be null.");
    }

    public Sprite(Sprite sprite) {
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.set(sprite);
    }

    public Sprite(TextureRegion textureRegion) {
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.setRegion(textureRegion);
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.setSize(textureRegion.getRegionWidth(), textureRegion.getRegionHeight());
        this.setOrigin(this.width / 2.0f, this.height / 2.0f);
    }

    public Sprite(TextureRegion textureRegion, int n, int n2, int n3, int n4) {
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.setRegion(textureRegion, n, n2, n3, n4);
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.setSize(Math.abs(n3), Math.abs(n4));
        this.setOrigin(this.width / 2.0f, this.height / 2.0f);
    }

    public void draw(Batch batch) {
        batch.draw(this.texture, this.getVertices(), 0, 20);
    }

    public void draw(Batch batch, float f) {
        float f2 = this.getColor().a;
        this.setAlpha(f * f2);
        this.draw(batch);
        this.setAlpha(f2);
    }

    @Override
    public void flip(boolean bl, boolean bl2) {
        float f;
        super.flip(bl, bl2);
        float[] fArray = this.vertices;
        if (bl) {
            f = fArray[3];
            fArray[3] = fArray[13];
            fArray[13] = f;
            f = fArray[8];
            fArray[8] = fArray[18];
            fArray[18] = f;
        }
        if (bl2) {
            f = fArray[4];
            fArray[4] = fArray[14];
            fArray[14] = f;
            f = fArray[9];
            fArray[9] = fArray[19];
            fArray[19] = f;
        }
    }

    public Rectangle getBoundingRectangle() {
        Object object = this.getVertices();
        float f = object[0];
        float f2 = object[1];
        float f3 = object[0];
        float f4 = object[1];
        float f5 = f;
        if (f > object[5]) {
            f5 = object[5];
        }
        f = f5;
        if (f5 > object[10]) {
            f = object[10];
        }
        float f6 = f;
        if (f > object[15]) {
            f6 = object[15];
        }
        f5 = f3;
        if (f3 < object[5]) {
            f5 = object[5];
        }
        f = f5;
        if (f5 < object[10]) {
            f = object[10];
        }
        f3 = f;
        if (f < object[15]) {
            f3 = object[15];
        }
        f = f2;
        if (f2 > object[6]) {
            f = object[6];
        }
        f5 = f;
        if (f > object[11]) {
            f5 = object[11];
        }
        f2 = f5;
        if (f5 > object[16]) {
            f2 = object[16];
        }
        f = f4;
        if (f4 < object[6]) {
            f = object[6];
        }
        f5 = f;
        if (f < object[11]) {
            f5 = object[11];
        }
        f = f5;
        if (f5 < object[16]) {
            f = object[16];
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle();
        }
        object = this.bounds;
        object.x = f6;
        object.y = f2;
        object.width = f3 - f6;
        object.height = f - f2;
        return object;
    }

    public Color getColor() {
        int n = NumberUtils.floatToIntColor(this.vertices[2]);
        Color color2 = this.color;
        color2.r = (float)(n & 0xFF) / 255.0f;
        color2.g = (float)(n >>> 8 & 0xFF) / 255.0f;
        color2.b = (float)(n >>> 16 & 0xFF) / 255.0f;
        color2.a = (float)(n >>> 24 & 0xFF) / 255.0f;
        return color2;
    }

    public float getHeight() {
        return this.height;
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float[] getVertices() {
        block5: {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            block7: {
                block6: {
                    if (!this.dirty) break block5;
                    this.dirty = false;
                    float[] fArray = this.vertices;
                    f10 = -this.originX;
                    f9 = -this.originY;
                    f8 = this.width + f10;
                    f7 = this.height + f9;
                    f6 = this.x - f10;
                    f5 = this.y - f9;
                    if (this.scaleX != 1.0f) break block6;
                    f4 = f10;
                    f3 = f9;
                    f2 = f8;
                    f = f7;
                    if (this.scaleY == 1.0f) break block7;
                }
                f2 = this.scaleX;
                f4 = f10 * f2;
                f = this.scaleY;
                f3 = f9 * f;
                f2 = f8 * f2;
                f = f7 * f;
            }
            if ((f7 = this.rotation) != 0.0f) {
                f8 = MathUtils.cosDeg(f7);
                f7 = MathUtils.sinDeg(this.rotation);
                f9 = f4 * f8;
                f10 = f4 * f7;
                f4 = f8 * f;
                float f11 = f * f7;
                f = f9 - f3 * f7 + f6;
                f3 = f3 * f8 + f10 + f5;
                fArray[0] = f;
                fArray[1] = f3;
                f9 = f9 - f11 + f6;
                f10 = f10 + f4 + f5;
                fArray[5] = f9;
                fArray[6] = f10;
                f8 = f2 * f8 - f11 + f6;
                f2 = f4 + f2 * f7 + f5;
                fArray[10] = f8;
                fArray[11] = f2;
                fArray[15] = f + (f8 - f9);
                fArray[16] = f2 - (f10 - f3);
            } else {
                fArray[0] = f4 += f6;
                fArray[1] = f3 += f5;
                fArray[5] = f4;
                fArray[6] = f += f5;
                fArray[10] = f2 += f6;
                fArray[11] = f;
                fArray[15] = f2;
                fArray[16] = f3;
            }
        }
        return this.vertices;
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void rotate(float f) {
        if (f == 0.0f) {
            return;
        }
        this.rotation += f;
        this.dirty = true;
    }

    public void rotate90(boolean bl) {
        float[] fArray = this.vertices;
        if (bl) {
            float f = fArray[4];
            fArray[4] = fArray[19];
            fArray[19] = fArray[14];
            fArray[14] = fArray[9];
            fArray[9] = f;
            f = fArray[3];
            fArray[3] = fArray[18];
            fArray[18] = fArray[13];
            fArray[13] = fArray[8];
            fArray[8] = f;
        } else {
            float f = fArray[4];
            fArray[4] = fArray[9];
            fArray[9] = fArray[14];
            fArray[14] = fArray[19];
            fArray[19] = f;
            f = fArray[3];
            fArray[3] = fArray[8];
            fArray[8] = fArray[13];
            fArray[13] = fArray[18];
            fArray[18] = f;
        }
    }

    public void scale(float f) {
        this.scaleX += f;
        this.scaleY += f;
        this.dirty = true;
    }

    @Override
    public void scroll(float f, float f2) {
        float[] fArray = this.vertices;
        if (f != 0.0f) {
            f = (fArray[3] + f) % 1.0f;
            float f3 = this.width / (float)this.texture.getWidth() + f;
            this.u = f;
            this.u2 = f3;
            fArray[3] = f;
            fArray[8] = f;
            fArray[13] = f3;
            fArray[18] = f3;
        }
        if (f2 != 0.0f) {
            f = (fArray[9] + f2) % 1.0f;
            f2 = this.height / (float)this.texture.getHeight() + f;
            this.v = f;
            this.v2 = f2;
            fArray[4] = f2;
            fArray[9] = f;
            fArray[14] = f;
            fArray[19] = f2;
        }
    }

    public void set(Sprite sprite) {
        if (sprite != null) {
            System.arraycopy(sprite.vertices, 0, this.vertices, 0, 20);
            this.texture = sprite.texture;
            this.u = sprite.u;
            this.v = sprite.v;
            this.u2 = sprite.u2;
            this.v2 = sprite.v2;
            this.x = sprite.x;
            this.y = sprite.y;
            this.width = sprite.width;
            this.height = sprite.height;
            this.regionWidth = sprite.regionWidth;
            this.regionHeight = sprite.regionHeight;
            this.originX = sprite.originX;
            this.originY = sprite.originY;
            this.rotation = sprite.rotation;
            this.scaleX = sprite.scaleX;
            this.scaleY = sprite.scaleY;
            this.color.set(sprite.color);
            this.dirty = sprite.dirty;
            return;
        }
        throw new IllegalArgumentException("sprite cannot be null.");
    }

    public void setAlpha(float f) {
        Object object = this.color;
        ((Color)object).a = f;
        f = ((Color)object).toFloatBits();
        object = this.vertices;
        object[2] = f;
        object[7] = f;
        object[12] = f;
        object[17] = f;
    }

    public void setBounds(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
        if (this.dirty) {
            return;
        }
        f3 += f;
        float[] fArray = this.vertices;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[5] = f;
        fArray[6] = f4 += f2;
        fArray[10] = f3;
        fArray[11] = f4;
        fArray[15] = f3;
        fArray[16] = f2;
        if (this.rotation != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f) {
            this.dirty = true;
        }
    }

    public void setCenter(float f, float f2) {
        this.setCenterX(f);
        this.setCenterY(f2);
    }

    public void setCenterX(float f) {
        this.setX(f - this.width / 2.0f);
    }

    public void setCenterY(float f) {
        this.setY(f - this.height / 2.0f);
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
        f = this.color.toFloatBits();
        float[] fArray = this.vertices;
        fArray[2] = f;
        fArray[7] = f;
        fArray[12] = f;
        fArray[17] = f;
    }

    public void setColor(Color object) {
        this.color.set((Color)object);
        float f = ((Color)object).toFloatBits();
        object = this.vertices;
        object[2] = f;
        object[7] = f;
        object[12] = f;
        object[17] = f;
    }

    public void setFlip(boolean bl, boolean bl2) {
        boolean bl3 = this.isFlipX();
        boolean bl4 = true;
        bl = bl3 != bl;
        bl2 = this.isFlipY() != bl2 ? bl4 : false;
        this.flip(bl, bl2);
    }

    public void setOrigin(float f, float f2) {
        this.originX = f;
        this.originY = f2;
        this.dirty = true;
    }

    public void setOriginBasedPosition(float f, float f2) {
        this.setPosition(f - this.originX, f2 - this.originY);
    }

    public void setOriginCenter() {
        this.originX = this.width / 2.0f;
        this.originY = this.height / 2.0f;
        this.dirty = true;
    }

    public void setPackedColor(float f) {
        Color.abgr8888ToColor(this.color, f);
        float[] fArray = this.vertices;
        fArray[2] = f;
        fArray[7] = f;
        fArray[12] = f;
        fArray[17] = f;
    }

    public void setPosition(float f, float f2) {
        this.translate(f - this.x, f2 - this.y);
    }

    @Override
    public void setRegion(float f, float f2, float f3, float f4) {
        super.setRegion(f, f2, f3, f4);
        float[] fArray = this.vertices;
        fArray[3] = f;
        fArray[4] = f4;
        fArray[8] = f;
        fArray[9] = f2;
        fArray[13] = f3;
        fArray[14] = f2;
        fArray[18] = f3;
        fArray[19] = f4;
    }

    public void setRotation(float f) {
        this.rotation = f;
        this.dirty = true;
    }

    public void setScale(float f) {
        this.scaleX = f;
        this.scaleY = f;
        this.dirty = true;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
        this.dirty = true;
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        if (this.dirty) {
            return;
        }
        float f3 = this.x;
        float f4 = f + f3;
        f = this.y;
        float[] fArray = this.vertices;
        fArray[0] = f3;
        fArray[1] = f;
        fArray[5] = f3;
        fArray[6] = f2 += f;
        fArray[10] = f4;
        fArray[11] = f2;
        fArray[15] = f4;
        fArray[16] = f;
        if (this.rotation != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f) {
            this.dirty = true;
        }
    }

    @Override
    public void setU(float f) {
        super.setU(f);
        float[] fArray = this.vertices;
        fArray[3] = f;
        fArray[8] = f;
    }

    @Override
    public void setU2(float f) {
        super.setU2(f);
        float[] fArray = this.vertices;
        fArray[13] = f;
        fArray[18] = f;
    }

    @Override
    public void setV(float f) {
        super.setV(f);
        float[] fArray = this.vertices;
        fArray[9] = f;
        fArray[14] = f;
    }

    @Override
    public void setV2(float f) {
        super.setV2(f);
        float[] fArray = this.vertices;
        fArray[4] = f;
        fArray[19] = f;
    }

    public void setX(float f) {
        this.translateX(f - this.x);
    }

    public void setY(float f) {
        this.translateY(f - this.y);
    }

    public void translate(float f, float f2) {
        this.x += f;
        this.y += f2;
        if (this.dirty) {
            return;
        }
        float[] fArray = this.vertices;
        fArray[0] = fArray[0] + f;
        fArray[1] = fArray[1] + f2;
        fArray[5] = fArray[5] + f;
        fArray[6] = fArray[6] + f2;
        fArray[10] = fArray[10] + f;
        fArray[11] = fArray[11] + f2;
        fArray[15] = fArray[15] + f;
        fArray[16] = fArray[16] + f2;
    }

    public void translateX(float f) {
        this.x += f;
        if (this.dirty) {
            return;
        }
        float[] fArray = this.vertices;
        fArray[0] = fArray[0] + f;
        fArray[5] = fArray[5] + f;
        fArray[10] = fArray[10] + f;
        fArray[15] = fArray[15] + f;
    }

    public void translateY(float f) {
        this.y += f;
        if (this.dirty) {
            return;
        }
        float[] fArray = this.vertices;
        fArray[1] = fArray[1] + f;
        fArray[6] = fArray[6] + f;
        fArray[11] = fArray[11] + f;
        fArray[16] = fArray[16] + f;
    }
}

