/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Gdx2DPixmap
implements Disposable {
    public static final int GDX2D_BLEND_NONE = 0;
    public static final int GDX2D_BLEND_SRC_OVER = 1;
    public static final int GDX2D_FORMAT_ALPHA = 1;
    public static final int GDX2D_FORMAT_LUMINANCE_ALPHA = 2;
    public static final int GDX2D_FORMAT_RGB565 = 5;
    public static final int GDX2D_FORMAT_RGB888 = 3;
    public static final int GDX2D_FORMAT_RGBA4444 = 6;
    public static final int GDX2D_FORMAT_RGBA8888 = 4;
    public static final int GDX2D_SCALE_LINEAR = 1;
    public static final int GDX2D_SCALE_NEAREST = 0;
    long basePtr;
    int format;
    int height;
    long[] nativeData = new long[4];
    ByteBuffer pixelPtr;
    int width;

    public Gdx2DPixmap(int n, int n2, int n3) throws GdxRuntimeException {
        this.pixelPtr = Gdx2DPixmap.newPixmap(this.nativeData, n, n2, n3);
        if (this.pixelPtr != null) {
            long[] lArray = this.nativeData;
            this.basePtr = lArray[0];
            this.width = (int)lArray[1];
            this.height = (int)lArray[2];
            this.format = (int)lArray[3];
            return;
        }
        throw new GdxRuntimeException("Error loading pixmap.");
    }

    public Gdx2DPixmap(InputStream object, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        while ((n2 = ((InputStream)object).read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        object = byteArrayOutputStream.toByteArray();
        this.pixelPtr = Gdx2DPixmap.load(this.nativeData, (byte[])object, 0, ((Object)object).length);
        if (this.pixelPtr != null) {
            object = this.nativeData;
            this.basePtr = (long)object[0];
            this.width = (int)object[1];
            this.height = (int)object[2];
            this.format = (int)object[3];
            if (n != 0 && n != this.format) {
                this.convert(n);
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Error loading pixmap: ");
        ((StringBuilder)object).append(Gdx2DPixmap.getFailureReason());
        object = new IOException(((StringBuilder)object).toString());
        throw object;
    }

    public Gdx2DPixmap(ByteBuffer byteBuffer, long[] lArray) {
        this.pixelPtr = byteBuffer;
        this.basePtr = lArray[0];
        this.width = (int)lArray[1];
        this.height = (int)lArray[2];
        this.format = (int)lArray[3];
    }

    public Gdx2DPixmap(byte[] object, int n, int n2, int n3) throws IOException {
        this.pixelPtr = Gdx2DPixmap.load(this.nativeData, (byte[])object, n, n2);
        if (this.pixelPtr != null) {
            object = this.nativeData;
            this.basePtr = object[0];
            this.width = (int)object[1];
            this.height = (int)object[2];
            this.format = (int)object[3];
            if (n3 != 0 && n3 != this.format) {
                this.convert(n3);
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Error loading pixmap: ");
        ((StringBuilder)object).append(Gdx2DPixmap.getFailureReason());
        throw new IOException(((StringBuilder)object).toString());
    }

    private static native void clear(long var0, int var2);

    private void convert(int n) {
        Gdx2DPixmap gdx2DPixmap = new Gdx2DPixmap(this.width, this.height, n);
        gdx2DPixmap.setBlend(0);
        gdx2DPixmap.drawPixmap(this, 0, 0, 0, 0, this.width, this.height);
        this.dispose();
        this.basePtr = gdx2DPixmap.basePtr;
        this.format = gdx2DPixmap.format;
        this.height = gdx2DPixmap.height;
        this.nativeData = gdx2DPixmap.nativeData;
        this.pixelPtr = gdx2DPixmap.pixelPtr;
        this.width = gdx2DPixmap.width;
    }

    private static native void drawCircle(long var0, int var2, int var3, int var4, int var5);

    private static native void drawLine(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void drawPixmap(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private static native void drawRect(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void fillCircle(long var0, int var2, int var3, int var4, int var5);

    private static native void fillRect(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void fillTriangle(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private static native void free(long var0);

    public static native String getFailureReason();

    private static native int getPixel(long var0, int var2, int var3);

    private static native ByteBuffer load(long[] var0, byte[] var1, int var2, int var3);

    public static Gdx2DPixmap newPixmap(int n, int n2, int n3) {
        try {
            Gdx2DPixmap gdx2DPixmap = new Gdx2DPixmap(n, n2, n3);
            return gdx2DPixmap;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Gdx2DPixmap newPixmap(InputStream object, int n) {
        try {
            object = new Gdx2DPixmap((InputStream)object, n);
            return object;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static native ByteBuffer newPixmap(long[] var0, int var1, int var2, int var3);

    private static native void setBlend(long var0, int var2);

    private static native void setPixel(long var0, int var2, int var3, int var4);

    private static native void setScale(long var0, int var2);

    public static int toGlFormat(int n) {
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("unknown format: ");
                stringBuilder.append(n);
                throw new GdxRuntimeException(stringBuilder.toString());
            }
            case 4: 
            case 6: {
                return 6408;
            }
            case 3: 
            case 5: {
                return 6407;
            }
            case 2: {
                return 6410;
            }
            case 1: 
        }
        return 6406;
    }

    public static int toGlType(int n) {
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("unknown format: ");
                stringBuilder.append(n);
                throw new GdxRuntimeException(stringBuilder.toString());
            }
            case 6: {
                return 32819;
            }
            case 5: {
                return 33635;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        return 5121;
    }

    public void clear(int n) {
        Gdx2DPixmap.clear(this.basePtr, n);
    }

    @Override
    public void dispose() {
        Gdx2DPixmap.free(this.basePtr);
    }

    public void drawCircle(int n, int n2, int n3, int n4) {
        Gdx2DPixmap.drawCircle(this.basePtr, n, n2, n3, n4);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5) {
        Gdx2DPixmap.drawLine(this.basePtr, n, n2, n3, n4, n5);
    }

    public void drawPixmap(Gdx2DPixmap gdx2DPixmap, int n, int n2, int n3, int n4, int n5, int n6) {
        Gdx2DPixmap.drawPixmap(gdx2DPixmap.basePtr, this.basePtr, n, n2, n5, n6, n3, n4, n5, n6);
    }

    public void drawPixmap(Gdx2DPixmap gdx2DPixmap, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Gdx2DPixmap.drawPixmap(gdx2DPixmap.basePtr, this.basePtr, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void drawRect(int n, int n2, int n3, int n4, int n5) {
        Gdx2DPixmap.drawRect(this.basePtr, n, n2, n3, n4, n5);
    }

    public void fillCircle(int n, int n2, int n3, int n4) {
        Gdx2DPixmap.fillCircle(this.basePtr, n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5) {
        Gdx2DPixmap.fillRect(this.basePtr, n, n2, n3, n4, n5);
    }

    public void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Gdx2DPixmap.fillTriangle(this.basePtr, n, n2, n3, n4, n5, n6, n7);
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatString() {
        switch (this.format) {
            default: {
                return "unknown";
            }
            case 6: {
                return "rgba4444";
            }
            case 5: {
                return "rgb565";
            }
            case 4: {
                return "rgba8888";
            }
            case 3: {
                return "rgb888";
            }
            case 2: {
                return "luminance alpha";
            }
            case 1: 
        }
        return "alpha";
    }

    public int getGLFormat() {
        return this.getGLInternalFormat();
    }

    public int getGLInternalFormat() {
        return Gdx2DPixmap.toGlFormat(this.format);
    }

    public int getGLType() {
        return Gdx2DPixmap.toGlType(this.format);
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixel(int n, int n2) {
        return Gdx2DPixmap.getPixel(this.basePtr, n, n2);
    }

    public ByteBuffer getPixels() {
        return this.pixelPtr;
    }

    public int getWidth() {
        return this.width;
    }

    public void setBlend(int n) {
        Gdx2DPixmap.setBlend(this.basePtr, n);
    }

    public void setPixel(int n, int n2, int n3) {
        Gdx2DPixmap.setPixel(this.basePtr, n, n2, n3);
    }

    public void setScale(int n) {
        Gdx2DPixmap.setScale(this.basePtr, n);
    }
}

