/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.reflect.ArrayReflection;

public class Animation<T> {
    private float animationDuration;
    private float frameDuration;
    T[] keyFrames;
    private int lastFrameNumber;
    private float lastStateTime;
    private PlayMode playMode = PlayMode.NORMAL;

    public Animation(float f, Array<? extends T> array) {
        this.frameDuration = f;
        Object[] objectArray = (Object[])ArrayReflection.newInstance(array.items.getClass().getComponentType(), array.size);
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = array.get(i);
        }
        this.setKeyFrames(objectArray);
    }

    public Animation(float f, Array<? extends T> array, PlayMode playMode) {
        this(f, array);
        this.setPlayMode(playMode);
    }

    public Animation(float f, T ... TArray) {
        this.frameDuration = f;
        this.setKeyFrames(TArray);
    }

    public float getAnimationDuration() {
        return this.animationDuration;
    }

    public float getFrameDuration() {
        return this.frameDuration;
    }

    public T getKeyFrame(float f) {
        int n = this.getKeyFrameIndex(f);
        return this.keyFrames[n];
    }

    public T getKeyFrame(float f, boolean bl) {
        PlayMode playMode = this.playMode;
        if (bl && (playMode == PlayMode.NORMAL || this.playMode == PlayMode.REVERSED)) {
            this.playMode = this.playMode == PlayMode.NORMAL ? PlayMode.LOOP : PlayMode.LOOP_REVERSED;
        } else if (!bl && this.playMode != PlayMode.NORMAL && this.playMode != PlayMode.REVERSED) {
            this.playMode = this.playMode == PlayMode.LOOP_REVERSED ? PlayMode.REVERSED : PlayMode.LOOP;
        }
        T t = this.getKeyFrame(f);
        this.playMode = playMode;
        return t;
    }

    public int getKeyFrameIndex(float f) {
        if (this.keyFrames.length == 1) {
            return 0;
        }
        int n = (int)(f / this.frameDuration);
        switch (1.$SwitchMap$com$badlogic$gdx$graphics$g2d$Animation$PlayMode[this.playMode.ordinal()]) {
            default: {
                break;
            }
            case 6: {
                T[] TArray = this.keyFrames;
                int n2 = TArray.length;
                n = TArray.length - n % n2 - 1;
                break;
            }
            case 5: {
                n = Math.max(this.keyFrames.length - n - 1, 0);
                break;
            }
            case 4: {
                if ((int)(this.lastStateTime / this.frameDuration) != n) {
                    n = MathUtils.random(this.keyFrames.length - 1);
                    break;
                }
                n = this.lastFrameNumber;
                break;
            }
            case 3: {
                int n3;
                T[] TArray = this.keyFrames;
                n = n3 = n % (TArray.length * 2 - 2);
                if (n3 < TArray.length) break;
                n = TArray.length - 2 - (n3 - TArray.length);
                break;
            }
            case 2: {
                n %= this.keyFrames.length;
                break;
            }
            case 1: {
                n = Math.min(this.keyFrames.length - 1, n);
            }
        }
        this.lastFrameNumber = n;
        this.lastStateTime = f;
        return n;
    }

    public T[] getKeyFrames() {
        return this.keyFrames;
    }

    public PlayMode getPlayMode() {
        return this.playMode;
    }

    public boolean isAnimationFinished(float f) {
        int n = (int)(f / this.frameDuration);
        int n2 = this.keyFrames.length;
        boolean bl = true;
        if (n2 - 1 >= n) {
            bl = false;
        }
        return bl;
    }

    public void setFrameDuration(float f) {
        this.frameDuration = f;
        this.animationDuration = (float)this.keyFrames.length * f;
    }

    protected void setKeyFrames(T ... TArray) {
        this.keyFrames = TArray;
        this.animationDuration = (float)TArray.length * this.frameDuration;
    }

    public void setPlayMode(PlayMode playMode) {
        this.playMode = playMode;
    }

    public static enum PlayMode {
        NORMAL,
        REVERSED,
        LOOP,
        LOOP_REVERSED,
        LOOP_PINGPONG,
        LOOP_RANDOM;

    }
}

