/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Texture
extends GLTexture {
    private static AssetManager assetManager;
    static final Map<Application, Array<Texture>> managedTextures;
    TextureData data;

    static {
        managedTextures = new HashMap<Application, Array<Texture>>();
    }

    public Texture(int n, int n2, Pixmap.Format format) {
        this(new PixmapTextureData(new Pixmap(n, n2, format), null, false, true));
    }

    protected Texture(int n, int n2, TextureData textureData) {
        super(n, n2);
        this.load(textureData);
        if (textureData.isManaged()) {
            Texture.addManagedTexture(Gdx.app, this);
        }
    }

    public Texture(FileHandle fileHandle) {
        this(fileHandle, null, false);
    }

    public Texture(FileHandle fileHandle, Pixmap.Format format, boolean bl) {
        this(TextureData.Factory.loadFromFile(fileHandle, format, bl));
    }

    public Texture(FileHandle fileHandle, boolean bl) {
        this(fileHandle, null, bl);
    }

    public Texture(Pixmap pixmap) {
        this(new PixmapTextureData(pixmap, null, false, false));
    }

    public Texture(Pixmap pixmap, Pixmap.Format format, boolean bl) {
        this(new PixmapTextureData(pixmap, format, bl, false));
    }

    public Texture(Pixmap pixmap, boolean bl) {
        this(new PixmapTextureData(pixmap, null, bl, false));
    }

    public Texture(TextureData textureData) {
        this(3553, Gdx.gl.glGenTexture(), textureData);
    }

    public Texture(String string2) {
        this(Gdx.files.internal(string2));
    }

    private static void addManagedTexture(Application application, Texture texture) {
        Array<Texture> array;
        Array<Texture> array2 = array = managedTextures.get(application);
        if (array == null) {
            array2 = new Array();
        }
        array2.add(texture);
        managedTextures.put(application, array2);
    }

    public static void clearAllTextures(Application application) {
        managedTextures.remove(application);
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed textures/app: { ");
        for (Application application : managedTextures.keySet()) {
            stringBuilder.append(Texture.managedTextures.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedTextures() {
        return Texture.managedTextures.get((Object)Gdx.app).size;
    }

    public static void invalidateAllTextures(Application object) {
        int n;
        if ((object = managedTextures.get(object)) == null) {
            return;
        }
        Object object2 = assetManager;
        if (object2 == null) {
            for (n = 0; n < ((Array)object).size; ++n) {
                ((Texture)((Array)object).get(n)).reload();
            }
        } else {
            ((AssetManager)object2).finishLoading();
            object2 = new Array(object);
            Iterator iterator = ((Array)object2).iterator();
            while (iterator.hasNext()) {
                Texture texture = (Texture)iterator.next();
                String string2 = assetManager.getAssetFileName(texture);
                if (string2 == null) {
                    texture.reload();
                    continue;
                }
                n = assetManager.getReferenceCount(string2);
                assetManager.setReferenceCount(string2, 0);
                texture.glHandle = 0;
                TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
                textureParameter.textureData = texture.getTextureData();
                textureParameter.minFilter = texture.getMinFilter();
                textureParameter.magFilter = texture.getMagFilter();
                textureParameter.wrapU = texture.getUWrap();
                textureParameter.wrapV = texture.getVWrap();
                textureParameter.genMipMaps = texture.data.useMipMaps();
                textureParameter.texture = texture;
                textureParameter.loadedCallback = new AssetLoaderParameters.LoadedCallback(){

                    @Override
                    public void finishedLoading(AssetManager assetManager, String string2, Class clazz) {
                        assetManager.setReferenceCount(string2, n);
                    }
                };
                assetManager.unload(string2);
                texture.glHandle = Gdx.gl.glGenTexture();
                assetManager.load(string2, Texture.class, textureParameter);
            }
            ((Array)object).clear();
            ((Array)object).addAll(object2);
        }
    }

    public static void setAssetManager(AssetManager assetManager) {
        Texture.assetManager = assetManager;
    }

    @Override
    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.data.isManaged() && managedTextures.get(Gdx.app) != null) {
            managedTextures.get(Gdx.app).removeValue(this, true);
        }
    }

    public void draw(Pixmap pixmap, int n, int n2) {
        if (!this.data.isManaged()) {
            this.bind();
            Gdx.gl.glTexSubImage2D(this.glTarget, 0, n, n2, pixmap.getWidth(), pixmap.getHeight(), pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
            return;
        }
        throw new GdxRuntimeException("can't draw to a managed texture");
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    public TextureData getTextureData() {
        return this.data;
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public boolean isManaged() {
        return this.data.isManaged();
    }

    public void load(TextureData textureData) {
        if (this.data != null && textureData.isManaged() != this.data.isManaged()) {
            throw new GdxRuntimeException("New data must have the same managed status as the old data");
        }
        this.data = textureData;
        if (!textureData.isPrepared()) {
            textureData.prepare();
        }
        this.bind();
        Texture.uploadImageData(3553, textureData);
        this.unsafeSetFilter(this.minFilter, this.magFilter, true);
        this.unsafeSetWrap(this.uWrap, this.vWrap, true);
        Gdx.gl.glBindTexture(this.glTarget, 0);
    }

    @Override
    protected void reload() {
        if (this.isManaged()) {
            this.glHandle = Gdx.gl.glGenTexture();
            this.load(this.data);
            return;
        }
        throw new GdxRuntimeException("Tried to reload unmanaged Texture");
    }

    public String toString() {
        TextureData textureData = this.data;
        if (textureData instanceof FileTextureData) {
            return textureData.toString();
        }
        return super.toString();
    }

    public static enum TextureFilter {
        Nearest(9728),
        Linear(9729),
        MipMap(9987),
        MipMapNearestNearest(9984),
        MipMapLinearNearest(9985),
        MipMapNearestLinear(9986),
        MipMapLinearLinear(9987);

        final int glEnum;

        private TextureFilter(int n2) {
            this.glEnum = n2;
        }

        public int getGLEnum() {
            return this.glEnum;
        }

        public boolean isMipMap() {
            int n = this.glEnum;
            boolean bl = n != 9728 && n != 9729;
            return bl;
        }
    }

    public static enum TextureWrap {
        MirroredRepeat(33648),
        ClampToEdge(33071),
        Repeat(10497);

        final int glEnum;

        private TextureWrap(int n2) {
            this.glEnum = n2;
        }

        public int getGLEnum() {
            return this.glEnum;
        }
    }
}

