/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.AudioTrack;
import com.badlogic.gdx.audio.AudioDevice;

class AndroidAudioDevice
implements AudioDevice {
    private short[] buffer = new short[1024];
    private final boolean isMono;
    private final int latency;
    private final AudioTrack track;

    AndroidAudioDevice(int n, boolean bl) {
        this.isMono = bl;
        int n2 = bl ? 4 : 12;
        int n3 = 2;
        int n4 = AudioTrack.getMinBufferSize((int)n, (int)n2, (int)2);
        n2 = bl ? 4 : 12;
        this.track = new AudioTrack(3, n, n2, 2, n4, 1);
        this.track.play();
        n = n3;
        if (bl) {
            n = 1;
        }
        this.latency = n4 / n;
    }

    @Override
    public void dispose() {
        this.track.stop();
        this.track.release();
    }

    @Override
    public int getLatency() {
        return this.latency;
    }

    @Override
    public boolean isMono() {
        return this.isMono;
    }

    @Override
    public void setVolume(float f) {
        this.track.setStereoVolume(f, f);
    }

    @Override
    public void writeSamples(float[] fArray, int n, int n2) {
        if (this.buffer.length < fArray.length) {
            this.buffer = new short[fArray.length];
        }
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2) {
            float f;
            float f2 = f = fArray[n4];
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            f = f2;
            if (f2 < -1.0f) {
                f = -1.0f;
            }
            short s = (short)(f * 32767.0f);
            this.buffer[n3] = s;
            ++n4;
            ++n3;
        }
        for (n = this.track.write(this.buffer, 0, n2); n != n2; n += this.track.write(this.buffer, n, n2 - n)) {
        }
    }

    @Override
    public void writeSamples(short[] sArray, int n, int n2) {
        for (int i = this.track.write(sArray, n, n2); i != n2; i += this.track.write(sArray, n + i, n2 - i)) {
        }
    }
}

