/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;

public class ParticleEffectLoader
extends SynchronousAssetLoader<ParticleEffect, ParticleEffectParameter> {
    public ParticleEffectLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String object, FileHandle fileHandle, ParticleEffectParameter particleEffectParameter) {
        if (particleEffectParameter != null && particleEffectParameter.atlasFile != null) {
            object = new Array();
            ((Array)object).add(new AssetDescriptor<TextureAtlas>(particleEffectParameter.atlasFile, TextureAtlas.class));
        } else {
            object = null;
        }
        return object;
    }

    @Override
    public ParticleEffect load(AssetManager assetManager, String object, FileHandle fileHandle, ParticleEffectParameter particleEffectParameter) {
        object = new ParticleEffect();
        if (particleEffectParameter != null && particleEffectParameter.atlasFile != null) {
            ((ParticleEffect)object).load(fileHandle, assetManager.get(particleEffectParameter.atlasFile, TextureAtlas.class), particleEffectParameter.atlasPrefix);
        } else if (particleEffectParameter != null && particleEffectParameter.imagesDir != null) {
            ((ParticleEffect)object).load(fileHandle, particleEffectParameter.imagesDir);
        } else {
            ((ParticleEffect)object).load(fileHandle, fileHandle.parent());
        }
        return object;
    }

    public static class ParticleEffectParameter
    extends AssetLoaderParameters<ParticleEffect> {
        public String atlasFile;
        public String atlasPrefix;
        public FileHandle imagesDir;
    }
}

