/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.KTXTextureData;
import com.badlogic.gdx.utils.Array;

public class CubemapLoader
extends AsynchronousAssetLoader<Cubemap, CubemapParameter> {
    CubemapLoaderInfo info = new CubemapLoaderInfo();

    public CubemapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String string2, FileHandle fileHandle, CubemapParameter cubemapParameter) {
        return null;
    }

    @Override
    public void loadAsync(AssetManager object, String string2, FileHandle fileHandle, CubemapParameter cubemapParameter) {
        this.info.filename = string2;
        if (cubemapParameter != null && cubemapParameter.cubemapData != null) {
            this.info.data = cubemapParameter.cubemapData;
            this.info.cubemap = cubemapParameter.cubemap;
        } else {
            this.info.cubemap = null;
            if (cubemapParameter != null) {
                object = cubemapParameter.format;
                this.info.cubemap = cubemapParameter.cubemap;
            }
            if (string2.contains(".ktx") || string2.contains(".zktx")) {
                this.info.data = new KTXTextureData(fileHandle, false);
            }
        }
        if (!this.info.data.isPrepared()) {
            this.info.data.prepare();
        }
    }

    @Override
    public Cubemap loadSync(AssetManager object, String string2, FileHandle fileHandle, CubemapParameter cubemapParameter) {
        object = this.info;
        if (object == null) {
            return null;
        }
        object = ((CubemapLoaderInfo)object).cubemap;
        if (object != null) {
            ((Cubemap)object).load(this.info.data);
        } else {
            object = new Cubemap(this.info.data);
        }
        if (cubemapParameter != null) {
            ((GLTexture)object).setFilter(cubemapParameter.minFilter, cubemapParameter.magFilter);
            ((GLTexture)object).setWrap(cubemapParameter.wrapU, cubemapParameter.wrapV);
        }
        return object;
    }

    public static class CubemapLoaderInfo {
        Cubemap cubemap;
        CubemapData data;
        String filename;
    }

    public static class CubemapParameter
    extends AssetLoaderParameters<Cubemap> {
        public Cubemap cubemap = null;
        public CubemapData cubemapData = null;
        public Pixmap.Format format = null;
        public Texture.TextureFilter magFilter;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureWrap wrapU;
        public Texture.TextureWrap wrapV;

        public CubemapParameter() {
            this.magFilter = Texture.TextureFilter.Nearest;
            this.wrapU = Texture.TextureWrap.ClampToEdge;
            this.wrapV = Texture.TextureWrap.ClampToEdge;
        }
    }
}

