/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UBJsonReader
implements BaseJsonReader {
    public boolean oldFormat = true;

    @Override
    public JsonValue parse(FileHandle fileHandle) {
        try {
            JsonValue jsonValue = this.parse(fileHandle.read(8192));
            return jsonValue;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error parsing file: ");
            stringBuilder.append(fileHandle);
            throw new SerializationException(stringBuilder.toString(), exception);
        }
    }

    public JsonValue parse(DataInputStream dataInputStream) throws IOException {
        try {
            JsonValue jsonValue = this.parse(dataInputStream, dataInputStream.readByte());
            return jsonValue;
        }
        finally {
            StreamUtils.closeQuietly(dataInputStream);
        }
    }

    protected JsonValue parse(DataInputStream dataInputStream, byte by) throws IOException {
        if (by == 91) {
            return this.parseArray(dataInputStream);
        }
        if (by == 123) {
            return this.parseObject(dataInputStream);
        }
        if (by == 90) {
            return new JsonValue(JsonValue.ValueType.nullValue);
        }
        if (by == 84) {
            return new JsonValue(true);
        }
        if (by == 70) {
            return new JsonValue(false);
        }
        if (by == 66) {
            return new JsonValue(this.readUChar(dataInputStream));
        }
        if (by == 85) {
            return new JsonValue(this.readUChar(dataInputStream));
        }
        if (by == 105) {
            short s = this.oldFormat ? dataInputStream.readShort() : (short)dataInputStream.readByte();
            return new JsonValue(s);
        }
        if (by == 73) {
            int n = this.oldFormat ? dataInputStream.readInt() : (int)dataInputStream.readShort();
            return new JsonValue(n);
        }
        if (by == 108) {
            return new JsonValue(dataInputStream.readInt());
        }
        if (by == 76) {
            return new JsonValue(dataInputStream.readLong());
        }
        if (by == 100) {
            return new JsonValue(dataInputStream.readFloat());
        }
        if (by == 68) {
            return new JsonValue(dataInputStream.readDouble());
        }
        if (by != 115 && by != 83) {
            if (by != 97 && by != 65) {
                if (by == 67) {
                    return new JsonValue(dataInputStream.readChar());
                }
                throw new GdxRuntimeException("Unrecognized data type");
            }
            return this.parseData(dataInputStream, by);
        }
        return new JsonValue(this.parseString(dataInputStream, by));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonValue parse(InputStream object) {
        void var1_4;
        Object object2;
        block7: {
            Object object3;
            SerializationException serializationException;
            block8: {
                serializationException = null;
                InputStream inputStream = null;
                object2 = inputStream;
                try {
                    object2 = inputStream;
                    object3 = new DataInputStream((InputStream)object);
                }
                catch (Throwable throwable) {
                    break block7;
                }
                catch (IOException iOException) {
                    object = serializationException;
                    break block8;
                }
                try {
                    object = this.parse((DataInputStream)object3);
                }
                catch (Throwable throwable) {
                    object2 = object3;
                    break block7;
                }
                catch (IOException iOException) {
                    object = object3;
                    object3 = iOException;
                    break block8;
                }
                StreamUtils.closeQuietly((Closeable)object3);
                return object;
            }
            object2 = object;
            {
                object2 = object;
                serializationException = new SerializationException((Throwable)object3);
                object2 = object;
                throw serializationException;
            }
        }
        StreamUtils.closeQuietly(object2);
        throw var1_4;
    }

    protected JsonValue parseArray(DataInputStream dataInputStream) throws IOException {
        byte by;
        JsonValue jsonValue = new JsonValue(JsonValue.ValueType.array);
        byte by2 = dataInputStream.readByte();
        if (by2 == 36) {
            by = dataInputStream.readByte();
            by2 = dataInputStream.readByte();
        } else {
            by = 0;
        }
        long l = -1L;
        byte by3 = by2;
        if (by2 == 35) {
            l = this.parseSize(dataInputStream, false, -1L);
            if (l >= 0L) {
                if (l == 0L) {
                    return jsonValue;
                }
                by3 = by == 0 ? dataInputStream.readByte() : by;
            } else {
                throw new GdxRuntimeException("Unrecognized data type");
            }
        }
        JsonValue jsonValue2 = null;
        long l2 = 0L;
        byte by4 = by3;
        while (dataInputStream.available() > 0 && by4 != 93) {
            JsonValue jsonValue3 = this.parse(dataInputStream, by4);
            jsonValue3.parent = jsonValue;
            if (jsonValue2 != null) {
                jsonValue3.prev = jsonValue2;
                jsonValue2.next = jsonValue3;
                ++jsonValue.size;
            } else {
                jsonValue.child = jsonValue3;
                jsonValue.size = 1;
            }
            long l3 = l2++;
            if (l > 0L) {
                l3 = l2;
                if (l2 >= l) break;
            }
            by2 = by == 0 ? dataInputStream.readByte() : by;
            jsonValue2 = jsonValue3;
            by4 = by2;
            l2 = l3;
        }
        return jsonValue;
    }

    protected JsonValue parseData(DataInputStream dataInputStream, byte by) throws IOException {
        byte by2 = dataInputStream.readByte();
        long l = by == 65 ? this.readUInt(dataInputStream) : (long)this.readUChar(dataInputStream);
        JsonValue jsonValue = new JsonValue(JsonValue.ValueType.array);
        JsonValue jsonValue2 = null;
        for (long i = 0L; i < l; ++i) {
            JsonValue jsonValue3 = this.parse(dataInputStream, by2);
            jsonValue3.parent = jsonValue;
            if (jsonValue2 != null) {
                jsonValue2.next = jsonValue3;
                ++jsonValue.size;
            } else {
                jsonValue.child = jsonValue3;
                jsonValue.size = 1;
            }
            jsonValue2 = jsonValue3;
        }
        return jsonValue;
    }

    protected JsonValue parseObject(DataInputStream dataInputStream) throws IOException {
        byte by;
        JsonValue jsonValue = new JsonValue(JsonValue.ValueType.object);
        byte by2 = dataInputStream.readByte();
        if (by2 == 36) {
            by = dataInputStream.readByte();
            by2 = dataInputStream.readByte();
        } else {
            by = 0;
        }
        long l = -1L;
        byte by3 = by2;
        if (by2 == 35) {
            l = this.parseSize(dataInputStream, false, -1L);
            if (l >= 0L) {
                if (l == 0L) {
                    return jsonValue;
                }
                by3 = dataInputStream.readByte();
            } else {
                throw new GdxRuntimeException("Unrecognized data type");
            }
        }
        JsonValue jsonValue2 = null;
        long l2 = 0L;
        byte by4 = by3;
        while (dataInputStream.available() > 0 && by4 != 125) {
            String string2 = this.parseString(dataInputStream, true, by4);
            by4 = by == 0 ? (by2 = dataInputStream.readByte()) : (by2 = by);
            JsonValue jsonValue3 = this.parse(dataInputStream, by4);
            jsonValue3.setName(string2);
            jsonValue3.parent = jsonValue;
            if (jsonValue2 != null) {
                jsonValue3.prev = jsonValue2;
                jsonValue2.next = jsonValue3;
                ++jsonValue.size;
            } else {
                jsonValue.child = jsonValue3;
                jsonValue.size = 1;
            }
            long l3 = l2++;
            if (l > 0L) {
                l3 = l2;
                if (l2 >= l) break;
            }
            by2 = dataInputStream.readByte();
            jsonValue2 = jsonValue3;
            by4 = by2;
            l2 = l3;
        }
        return jsonValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long parseSize(DataInputStream dataInputStream, byte by, boolean bl, long l) throws IOException {
        if (by == 105) {
            by = (byte)this.readUChar(dataInputStream);
            return by;
        }
        if (by == 73) {
            by = (byte)this.readUShort(dataInputStream);
            return by;
        }
        if (by == 108) {
            return this.readUInt(dataInputStream);
        }
        if (by == 76) {
            return dataInputStream.readLong();
        }
        if (!bl) return l;
        return (long)((short)by & 0xFF) << 24 | (long)((short)dataInputStream.readByte() & 0xFF) << 16 | (long)((short)dataInputStream.readByte() & 0xFF) << 8 | (long)((short)dataInputStream.readByte() & 0xFF);
    }

    protected long parseSize(DataInputStream dataInputStream, boolean bl, long l) throws IOException {
        return this.parseSize(dataInputStream, dataInputStream.readByte(), bl, l);
    }

    protected String parseString(DataInputStream dataInputStream, byte by) throws IOException {
        return this.parseString(dataInputStream, false, by);
    }

    protected String parseString(DataInputStream object, boolean bl, byte by) throws IOException {
        long l = -1L;
        if (by == 83) {
            l = this.parseSize((DataInputStream)object, true, -1L);
        } else if (by == 115) {
            l = this.readUChar((DataInputStream)object);
        } else if (bl) {
            l = this.parseSize((DataInputStream)object, by, false, -1L);
        }
        if (l >= 0L) {
            object = l > 0L ? this.readString((DataInputStream)object, l) : "";
            return object;
        }
        throw new GdxRuntimeException("Unrecognized data type, string expected");
    }

    protected String readString(DataInputStream dataInputStream, long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        dataInputStream.readFully(byArray);
        return new String(byArray, "UTF-8");
    }

    protected short readUChar(DataInputStream dataInputStream) throws IOException {
        return (short)((short)dataInputStream.readByte() & 0xFF);
    }

    protected long readUInt(DataInputStream dataInputStream) throws IOException {
        return (long)dataInputStream.readInt() & 0xFFFFFFFFFFFFFFFFL;
    }

    protected int readUShort(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort() & 0xFFFF;
    }
}

