/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.ReflectionException;

public class ReflectionPool<T>
extends Pool<T> {
    private final Constructor constructor;

    public ReflectionPool(Class<T> clazz) {
        this(clazz, 16, Integer.MAX_VALUE);
    }

    public ReflectionPool(Class<T> clazz, int n) {
        this(clazz, n, Integer.MAX_VALUE);
    }

    public ReflectionPool(Class<T> clazz, int n, int n2) {
        super(n, n2);
        this.constructor = this.findConstructor(clazz);
        if (this.constructor != null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Class cannot be created (missing no-arg constructor): ");
        stringBuilder.append(clazz.getName());
        throw new RuntimeException(stringBuilder.toString());
    }

    private Constructor findConstructor(Class<T> object) {
        try {
            Constructor constructor = ClassReflection.getConstructor(object, null);
            return constructor;
        }
        catch (Exception exception) {
            try {
                object = ClassReflection.getDeclaredConstructor(object, null);
                ((Constructor)object).setAccessible(true);
                return object;
            }
            catch (ReflectionException reflectionException) {
                return null;
            }
        }
    }

    @Override
    protected T newObject() {
        Object object;
        try {
            object = this.constructor.newInstance(null);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unable to create new instance: ");
            stringBuilder.append(this.constructor.getDeclaringClass().getName());
            throw new GdxRuntimeException(stringBuilder.toString(), exception);
        }
        return (T)object;
    }
}

