/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.PropertiesUtils;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.TextFormatter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;

public class I18NBundle {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Locale ROOT_LOCALE = new Locale("", "", "");
    private static boolean exceptionOnMissingKey;
    private static boolean simpleFormatter;
    private TextFormatter formatter;
    private Locale locale;
    private I18NBundle parent;
    private ObjectMap<String, String> properties;

    static {
        simpleFormatter = false;
        exceptionOnMissingKey = true;
    }

    private static boolean checkFileExistence(FileHandle fileHandle) {
        try {
            fileHandle.read().close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static I18NBundle createBundle(FileHandle fileHandle) {
        return I18NBundle.createBundleImpl(fileHandle, Locale.getDefault(), DEFAULT_ENCODING);
    }

    public static I18NBundle createBundle(FileHandle fileHandle, String string2) {
        return I18NBundle.createBundleImpl(fileHandle, Locale.getDefault(), string2);
    }

    public static I18NBundle createBundle(FileHandle fileHandle, Locale locale) {
        return I18NBundle.createBundleImpl(fileHandle, locale, DEFAULT_ENCODING);
    }

    public static I18NBundle createBundle(FileHandle fileHandle, Locale locale, String string2) {
        return I18NBundle.createBundleImpl(fileHandle, locale, string2);
    }

    private static I18NBundle createBundleImpl(FileHandle object, Locale locale, String charSequence) {
        if (object != null && locale != null && charSequence != null) {
            I18NBundle i18NBundle;
            I18NBundle i18NBundle2;
            Object object2;
            Object object3 = null;
            Object object4 = locale;
            do {
                object2 = I18NBundle.getCandidateLocales((Locale)object4);
                i18NBundle2 = I18NBundle.loadBundleChain((FileHandle)object, (String)charSequence, object2, 0, object3);
                i18NBundle = object3;
                if (i18NBundle2 != null) {
                    Locale locale2 = i18NBundle2.getLocale();
                    boolean bl = locale2.equals(ROOT_LOCALE);
                    i18NBundle = object3;
                    if (!bl) break;
                    if (locale2.equals(locale)) {
                        i18NBundle = object3;
                        break;
                    }
                    if (object2.size() == 1 && locale2.equals(object2.get(0))) {
                        i18NBundle = object3;
                        break;
                    }
                    i18NBundle = object3;
                    if (bl) {
                        i18NBundle = object3;
                        if (object3 == null) {
                            i18NBundle = i18NBundle2;
                        }
                    }
                }
                object4 = object2 = I18NBundle.getFallbackLocale((Locale)object4);
                object3 = i18NBundle;
            } while (object2 != null);
            if (i18NBundle2 == null) {
                if (i18NBundle == null) {
                    charSequence = new java.lang.StringBuilder();
                    ((java.lang.StringBuilder)charSequence).append("Can't find bundle for base file handle ");
                    ((java.lang.StringBuilder)charSequence).append(((FileHandle)object).path());
                    ((java.lang.StringBuilder)charSequence).append(", locale ");
                    ((java.lang.StringBuilder)charSequence).append(locale);
                    charSequence = ((java.lang.StringBuilder)charSequence).toString();
                    object3 = new java.lang.StringBuilder();
                    ((java.lang.StringBuilder)object3).append(object);
                    ((java.lang.StringBuilder)object3).append("_");
                    ((java.lang.StringBuilder)object3).append(locale);
                    throw new MissingResourceException((String)charSequence, ((java.lang.StringBuilder)object3).toString(), "");
                }
            } else {
                i18NBundle = i18NBundle2;
            }
            return i18NBundle;
        }
        object = new NullPointerException();
        throw object;
    }

    private static List<Locale> getCandidateLocales(Locale locale) {
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        Object object = locale.getVariant();
        ArrayList<Locale> arrayList = new ArrayList<Locale>(4);
        if (((String)object).length() > 0) {
            arrayList.add(locale);
        }
        if (string3.length() > 0) {
            object = arrayList.isEmpty() ? locale : new Locale(string2, string3);
            arrayList.add((Locale)object);
        }
        if (string2.length() > 0) {
            if (!arrayList.isEmpty()) {
                locale = new Locale(string2);
            }
            arrayList.add(locale);
        }
        arrayList.add(ROOT_LOCALE);
        return arrayList;
    }

    public static boolean getExceptionOnMissingKey() {
        return exceptionOnMissingKey;
    }

    private static Locale getFallbackLocale(Locale locale) {
        Locale locale2;
        Locale locale3 = locale2 = Locale.getDefault();
        if (locale.equals(locale2)) {
            locale3 = null;
        }
        return locale3;
    }

    public static boolean getSimpleFormatter() {
        return simpleFormatter;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static I18NBundle loadBundle(FileHandle object, String object2, Locale locale) {
        Throwable throwable2222222;
        Object object3;
        block8: {
            block7: {
                Object object4 = null;
                Object object5 = null;
                I18NBundle i18NBundle = null;
                object3 = object4;
                Object object6 = object5;
                object = I18NBundle.toFileHandle((FileHandle)object, locale);
                object3 = object4;
                object6 = object5;
                if (I18NBundle.checkFileExistence((FileHandle)object)) {
                    object3 = object4;
                    object6 = object5;
                    object3 = object4;
                    object6 = object5;
                    i18NBundle = new I18NBundle();
                    object3 = object4;
                    object6 = object5;
                    object3 = object = ((FileHandle)object).reader((String)object2);
                    object6 = object;
                    i18NBundle.load((Reader)object);
                    object2 = object;
                    object = i18NBundle;
                    break block7;
                } else {
                    object = null;
                    object2 = i18NBundle;
                }
                {
                    catch (Throwable throwable2222222) {
                        break block8;
                    }
                    catch (IOException iOException) {}
                    object3 = object6;
                    {
                        object3 = object6;
                        object = new GdxRuntimeException(iOException);
                        object3 = object6;
                        throw object;
                    }
                }
            }
            StreamUtils.closeQuietly((Closeable)object2);
            if (object != null) {
                super.setLocale(locale);
            }
            return object;
        }
        StreamUtils.closeQuietly(object3);
        throw throwable2222222;
    }

    private static I18NBundle loadBundleChain(FileHandle object, String string2, List<Locale> object2, int n, I18NBundle i18NBundle) {
        Locale locale = object2.get(n);
        if (n != object2.size() - 1) {
            object2 = I18NBundle.loadBundleChain((FileHandle)object, string2, object2, n + 1, i18NBundle);
        } else {
            if (i18NBundle != null && locale.equals(ROOT_LOCALE)) {
                return i18NBundle;
            }
            object2 = null;
        }
        object = I18NBundle.loadBundle((FileHandle)object, string2, locale);
        if (object != null) {
            ((I18NBundle)object).parent = object2;
            return object;
        }
        return object2;
    }

    public static void setExceptionOnMissingKey(boolean bl) {
        exceptionOnMissingKey = bl;
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
        this.formatter = new TextFormatter(locale, simpleFormatter ^ true);
    }

    public static void setSimpleFormatter(boolean bl) {
        simpleFormatter = bl;
    }

    private static FileHandle toFileHandle(FileHandle fileHandle, Locale object) {
        StringBuilder stringBuilder = new StringBuilder(fileHandle.name());
        if (!((Locale)object).equals(ROOT_LOCALE)) {
            String string2 = ((Locale)object).getLanguage();
            String string3 = ((Locale)object).getCountry();
            object = ((Locale)object).getVariant();
            boolean bl = "".equals(string2);
            boolean bl2 = "".equals(string3);
            boolean bl3 = "".equals(object);
            if (!(bl && bl2 && bl3)) {
                stringBuilder.append('_');
                if (!bl3) {
                    stringBuilder.append(string2).append('_').append(string3).append('_').append((String)object);
                } else if (!bl2) {
                    stringBuilder.append(string2).append('_').append(string3);
                } else {
                    stringBuilder.append(string2);
                }
            }
        }
        return fileHandle.sibling(stringBuilder.append(".properties").toString());
    }

    public void debug(String string2) {
        ObjectMap.Keys<String> keys2 = this.properties.keys();
        if (keys2 == null) {
            return;
        }
        for (String string3 : keys2) {
            this.properties.put(string3, string2);
        }
    }

    public String format(String string2, Object ... objectArray) {
        return this.formatter.format(this.get(string2), objectArray);
    }

    public final String get(String string2) {
        CharSequence charSequence = this.properties.get(string2);
        Object object = charSequence;
        if (charSequence == null) {
            object = this.parent;
            if (object != null) {
                charSequence = ((I18NBundle)object).get(string2);
            }
            object = charSequence;
            if (charSequence == null) {
                if (!exceptionOnMissingKey) {
                    charSequence = new java.lang.StringBuilder();
                    ((java.lang.StringBuilder)charSequence).append("???");
                    ((java.lang.StringBuilder)charSequence).append(string2);
                    ((java.lang.StringBuilder)charSequence).append("???");
                    return ((java.lang.StringBuilder)charSequence).toString();
                }
                charSequence = new java.lang.StringBuilder();
                ((java.lang.StringBuilder)charSequence).append("Can't find bundle key ");
                ((java.lang.StringBuilder)charSequence).append(string2);
                throw new MissingResourceException(((java.lang.StringBuilder)charSequence).toString(), this.getClass().getName(), string2);
            }
        }
        return object;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void load(Reader reader) throws IOException {
        this.properties = new ObjectMap();
        PropertiesUtils.load(this.properties, reader);
    }
}

