/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.HttpParametersUtils;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.Pools;
import java.io.InputStream;
import java.util.Map;

public class HttpRequestBuilder {
    public static String baseUrl = "";
    public static int defaultTimeout = 1000;
    public static Json json = new Json();
    private Net.HttpRequest httpRequest;

    private void validate() {
        if (this.httpRequest != null) {
            return;
        }
        throw new IllegalStateException("A new request has not been started yet. Call HttpRequestBuilder.newRequest() first.");
    }

    public HttpRequestBuilder basicAuthentication(String string2, String string3) {
        this.validate();
        Net.HttpRequest httpRequest = this.httpRequest;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Basic ");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(string2);
        stringBuilder2.append(":");
        stringBuilder2.append(string3);
        stringBuilder.append(Base64Coder.encodeString(stringBuilder2.toString()));
        httpRequest.setHeader("Authorization", stringBuilder.toString());
        return this;
    }

    public Net.HttpRequest build() {
        this.validate();
        Net.HttpRequest httpRequest = this.httpRequest;
        this.httpRequest = null;
        return httpRequest;
    }

    public HttpRequestBuilder content(InputStream inputStream, long l) {
        this.validate();
        this.httpRequest.setContent(inputStream, l);
        return this;
    }

    public HttpRequestBuilder content(String string2) {
        this.validate();
        this.httpRequest.setContent(string2);
        return this;
    }

    public HttpRequestBuilder followRedirects(boolean bl) {
        this.validate();
        this.httpRequest.setFollowRedirects(bl);
        return this;
    }

    public HttpRequestBuilder formEncodedContent(Map<String, String> object) {
        this.validate();
        this.httpRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
        object = HttpParametersUtils.convertHttpParameters(object);
        this.httpRequest.setContent((String)object);
        return this;
    }

    public HttpRequestBuilder header(String string2, String string3) {
        this.validate();
        this.httpRequest.setHeader(string2, string3);
        return this;
    }

    public HttpRequestBuilder includeCredentials(boolean bl) {
        this.validate();
        this.httpRequest.setIncludeCredentials(bl);
        return this;
    }

    public HttpRequestBuilder jsonContent(Object object) {
        this.validate();
        this.httpRequest.setHeader("Content-Type", "application/json");
        object = json.toJson(object);
        this.httpRequest.setContent((String)object);
        return this;
    }

    public HttpRequestBuilder method(String string2) {
        this.validate();
        this.httpRequest.setMethod(string2);
        return this;
    }

    public HttpRequestBuilder newRequest() {
        if (this.httpRequest == null) {
            this.httpRequest = Pools.obtain(Net.HttpRequest.class);
            this.httpRequest.setTimeOut(defaultTimeout);
            return this;
        }
        throw new IllegalStateException("A new request has already been started. Call HttpRequestBuilder.build() first.");
    }

    public HttpRequestBuilder timeout(int n) {
        this.validate();
        this.httpRequest.setTimeOut(n);
        return this;
    }

    public HttpRequestBuilder url(String string2) {
        this.validate();
        Net.HttpRequest httpRequest = this.httpRequest;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(baseUrl);
        stringBuilder.append(string2);
        httpRequest.setUrl(stringBuilder.toString());
        return this;
    }
}

