/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.profiling.GL20Interceptor;
import com.badlogic.gdx.graphics.profiling.GL30Interceptor;
import com.badlogic.gdx.graphics.profiling.GLErrorListener;
import com.badlogic.gdx.graphics.profiling.GLInterceptor;
import com.badlogic.gdx.math.FloatCounter;

public class GLProfiler {
    private boolean enabled = false;
    private GLInterceptor glInterceptor;
    private Graphics graphics;
    private GLErrorListener listener;

    public GLProfiler(Graphics graphics) {
        this.graphics = graphics;
        this.glInterceptor = graphics.getGL30() != null ? new GL30Interceptor(this, graphics.getGL30()) : new GL20Interceptor(this, graphics.getGL20());
        this.listener = GLErrorListener.LOGGING_LISTENER;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        if (this.graphics.getGL30() != null) {
            Graphics graphics = this.graphics;
            graphics.setGL30(((GL30Interceptor)graphics.getGL30()).gl30);
        } else {
            Graphics graphics = this.graphics;
            graphics.setGL20(((GL20Interceptor)graphics.getGL20()).gl20);
        }
        this.enabled = false;
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        if (this.graphics.getGL30() != null) {
            this.graphics.setGL30((GL30)((Object)this.glInterceptor));
        } else {
            this.graphics.setGL20(this.glInterceptor);
        }
        this.enabled = true;
    }

    public int getCalls() {
        return this.glInterceptor.getCalls();
    }

    public int getDrawCalls() {
        return this.glInterceptor.getDrawCalls();
    }

    public GLErrorListener getListener() {
        return this.listener;
    }

    public int getShaderSwitches() {
        return this.glInterceptor.getShaderSwitches();
    }

    public int getTextureBindings() {
        return this.glInterceptor.getTextureBindings();
    }

    public FloatCounter getVertexCount() {
        return this.glInterceptor.getVertexCount();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.glInterceptor.reset();
    }

    public void setListener(GLErrorListener gLErrorListener) {
        this.listener = gLErrorListener;
    }
}

