/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class VertexArray
implements VertexData {
    final VertexAttributes attributes;
    final FloatBuffer buffer;
    final ByteBuffer byteBuffer;
    boolean isBound = false;

    public VertexArray(int n, VertexAttributes vertexAttributes) {
        this.attributes = vertexAttributes;
        this.byteBuffer = BufferUtils.newUnsafeByteBuffer(this.attributes.vertexSize * n);
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
    }

    public VertexArray(int n, VertexAttribute ... vertexAttributeArray) {
        this(n, new VertexAttributes(vertexAttributeArray));
    }

    @Override
    public void bind(ShaderProgram shaderProgram) {
        this.bind(shaderProgram, null);
    }

    @Override
    public void bind(ShaderProgram shaderProgram, int[] object) {
        int n;
        int n2 = this.attributes.size();
        this.byteBuffer.limit(this.buffer.limit() * 4);
        int n3 = 0;
        if (object == null) {
            for (n = n3; n < n2; ++n) {
                object = this.attributes.get(n);
                n3 = shaderProgram.getAttributeLocation(object.alias);
                if (n3 < 0) continue;
                shaderProgram.enableVertexAttribute(n3);
                if (object.type == 5126) {
                    this.buffer.position(object.offset / 4);
                    shaderProgram.setVertexAttribute(n3, object.numComponents, object.type, object.normalized, this.attributes.vertexSize, (Buffer)this.buffer);
                    continue;
                }
                this.byteBuffer.position(object.offset);
                shaderProgram.setVertexAttribute(n3, object.numComponents, object.type, object.normalized, this.attributes.vertexSize, (Buffer)this.byteBuffer);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                VertexAttribute vertexAttribute = this.attributes.get(n);
                n3 = object[n];
                if (n3 < 0) continue;
                shaderProgram.enableVertexAttribute(n3);
                if (vertexAttribute.type == 5126) {
                    this.buffer.position(vertexAttribute.offset / 4);
                    shaderProgram.setVertexAttribute(n3, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.attributes.vertexSize, (Buffer)this.buffer);
                    continue;
                }
                this.byteBuffer.position(vertexAttribute.offset);
                shaderProgram.setVertexAttribute(n3, vertexAttribute.numComponents, vertexAttribute.type, vertexAttribute.normalized, this.attributes.vertexSize, (Buffer)this.byteBuffer);
            }
        }
        this.isBound = true;
    }

    @Override
    public void dispose() {
        BufferUtils.disposeUnsafeByteBuffer(this.byteBuffer);
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public FloatBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getNumMaxVertices() {
        return this.byteBuffer.capacity() / this.attributes.vertexSize;
    }

    @Override
    public int getNumVertices() {
        return this.buffer.limit() * 4 / this.attributes.vertexSize;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void setVertices(float[] fArray, int n, int n2) {
        BufferUtils.copy(fArray, this.byteBuffer, n2, n);
        this.buffer.position(0);
        this.buffer.limit(n2);
    }

    @Override
    public void unbind(ShaderProgram shaderProgram) {
        this.unbind(shaderProgram, null);
    }

    @Override
    public void unbind(ShaderProgram shaderProgram, int[] nArray) {
        int n = this.attributes.size();
        if (nArray == null) {
            for (int i = 0; i < n; ++i) {
                shaderProgram.disableVertexAttribute(this.attributes.get((int)i).alias);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                if (n2 < 0) continue;
                shaderProgram.disableVertexAttribute(n2);
            }
        }
        this.isBound = false;
    }

    @Override
    public void updateVertices(int n, float[] fArray, int n2, int n3) {
        int n4 = this.byteBuffer.position();
        this.byteBuffer.position(n * 4);
        BufferUtils.copy(fArray, n2, n3, (Buffer)this.byteBuffer);
        this.byteBuffer.position(n4);
    }
}

