/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.InstanceData;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class InstanceBufferObject
implements InstanceData {
    private VertexAttributes attributes;
    private FloatBuffer buffer;
    private int bufferHandle;
    private ByteBuffer byteBuffer;
    boolean isBound = false;
    boolean isDirty = false;
    private boolean ownsBuffer;
    private int usage;

    public InstanceBufferObject(boolean bl, int n, VertexAttributes vertexAttributes) {
        if (Gdx.gl30 != null) {
            this.bufferHandle = Gdx.gl20.glGenBuffer();
            ByteBuffer byteBuffer = BufferUtils.newUnsafeByteBuffer(vertexAttributes.vertexSize * n);
            byteBuffer.limit(0);
            this.setBuffer(byteBuffer, true, vertexAttributes);
            n = bl ? 35044 : 35048;
            this.setUsage(n);
            return;
        }
        throw new GdxRuntimeException("InstanceBufferObject requires a device running with GLES 3.0 compatibilty");
    }

    public InstanceBufferObject(boolean bl, int n, VertexAttribute ... vertexAttributeArray) {
        this(bl, n, new VertexAttributes(vertexAttributeArray));
    }

    private void bufferChanged() {
        if (this.isBound) {
            Gdx.gl20.glBufferData(34962, this.byteBuffer.limit(), null, this.usage);
            Gdx.gl20.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
    }

    @Override
    public void bind(ShaderProgram shaderProgram) {
        this.bind(shaderProgram, null);
    }

    @Override
    public void bind(ShaderProgram shaderProgram, int[] object) {
        Object object2 = Gdx.gl20;
        object2.glBindBuffer(34962, this.bufferHandle);
        boolean bl = this.isDirty;
        int n = 0;
        int n2 = 0;
        if (bl) {
            this.byteBuffer.limit(this.buffer.limit() * 4);
            object2.glBufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
        int n3 = this.attributes.size();
        if (object == null) {
            for (n = n2; n < n3; ++n) {
                object = this.attributes.get(n);
                n2 = shaderProgram.getAttributeLocation(object.alias);
                if (n2 < 0) continue;
                shaderProgram.enableVertexAttribute(n2 += object.unit);
                shaderProgram.setVertexAttribute(n2, object.numComponents, object.type, object.normalized, this.attributes.vertexSize, object.offset);
                Gdx.gl30.glVertexAttribDivisor(n2, 1);
            }
        } else {
            while (n < n3) {
                object2 = this.attributes.get(n);
                n2 = object[n];
                if (n2 >= 0) {
                    shaderProgram.enableVertexAttribute(n2 += ((VertexAttribute)object2).unit);
                    shaderProgram.setVertexAttribute(n2, ((VertexAttribute)object2).numComponents, ((VertexAttribute)object2).type, ((VertexAttribute)object2).normalized, this.attributes.vertexSize, ((VertexAttribute)object2).offset);
                    Gdx.gl30.glVertexAttribDivisor(n2, 1);
                }
                ++n;
            }
        }
        this.isBound = true;
    }

    @Override
    public void dispose() {
        GL20 gL20 = Gdx.gl20;
        gL20.glBindBuffer(34962, 0);
        gL20.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
        if (this.ownsBuffer) {
            BufferUtils.disposeUnsafeByteBuffer(this.byteBuffer);
        }
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public FloatBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    @Override
    public int getNumInstances() {
        return this.buffer.limit() * 4 / this.attributes.vertexSize;
    }

    @Override
    public int getNumMaxInstances() {
        return this.byteBuffer.capacity() / this.attributes.vertexSize;
    }

    protected int getUsage() {
        return this.usage;
    }

    @Override
    public void invalidate() {
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        this.isDirty = true;
    }

    protected void setBuffer(Buffer buffer, boolean bl, VertexAttributes vertexAttributes) {
        if (!this.isBound) {
            ByteBuffer byteBuffer;
            if (this.ownsBuffer && (byteBuffer = this.byteBuffer) != null) {
                BufferUtils.disposeUnsafeByteBuffer(byteBuffer);
            }
            this.attributes = vertexAttributes;
            if (buffer instanceof ByteBuffer) {
                this.byteBuffer = (ByteBuffer)buffer;
                this.ownsBuffer = bl;
                int n = this.byteBuffer.limit();
                buffer = this.byteBuffer;
                ((ByteBuffer)buffer).limit(buffer.capacity());
                this.buffer = this.byteBuffer.asFloatBuffer();
                this.byteBuffer.limit(n);
                this.buffer.limit(n / 4);
                return;
            }
            throw new GdxRuntimeException("Only ByteBuffer is currently supported");
        }
        throw new GdxRuntimeException("Cannot change attributes while VBO is bound");
    }

    @Override
    public void setInstanceData(FloatBuffer floatBuffer, int n) {
        this.isDirty = true;
        BufferUtils.copy(floatBuffer, this.byteBuffer, n);
        this.buffer.position(0);
        this.buffer.limit(n);
        this.bufferChanged();
    }

    @Override
    public void setInstanceData(float[] fArray, int n, int n2) {
        this.isDirty = true;
        BufferUtils.copy(fArray, this.byteBuffer, n2, n);
        this.buffer.position(0);
        this.buffer.limit(n2);
        this.bufferChanged();
    }

    protected void setUsage(int n) {
        if (!this.isBound) {
            this.usage = n;
            return;
        }
        throw new GdxRuntimeException("Cannot change usage while VBO is bound");
    }

    @Override
    public void unbind(ShaderProgram shaderProgram) {
        this.unbind(shaderProgram, null);
    }

    @Override
    public void unbind(ShaderProgram shaderProgram, int[] object) {
        GL20 gL20 = Gdx.gl20;
        int n = this.attributes.size();
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                object = this.attributes.get(i);
                int n2 = shaderProgram.getAttributeLocation(object.alias);
                if (n2 < 0) continue;
                shaderProgram.disableVertexAttribute(n2 + object.unit);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                VertexAttribute vertexAttribute = this.attributes.get(i);
                int n3 = object[i];
                if (n3 < 0) continue;
                shaderProgram.enableVertexAttribute(n3 + vertexAttribute.unit);
            }
        }
        gL20.glBindBuffer(34962, 0);
        this.isBound = false;
    }

    @Override
    public void updateInstanceData(int n, FloatBuffer floatBuffer, int n2, int n3) {
        this.isDirty = true;
        int n4 = this.byteBuffer.position();
        this.byteBuffer.position(n * 4);
        floatBuffer.position(n2 * 4);
        BufferUtils.copy(floatBuffer, this.byteBuffer, n3);
        this.byteBuffer.position(n4);
        this.buffer.position(0);
        this.bufferChanged();
    }

    @Override
    public void updateInstanceData(int n, float[] fArray, int n2, int n3) {
        this.isDirty = true;
        int n4 = this.byteBuffer.position();
        this.byteBuffer.position(n * 4);
        BufferUtils.copy(fArray, n2, n3, (Buffer)this.byteBuffer);
        this.byteBuffer.position(n4);
        this.buffer.position(0);
        this.bufferChanged();
    }
}

