/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.decals;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.decals.DecalMaterial;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.NumberUtils;

public class Decal {
    public static final int C1 = 3;
    public static final int C2 = 9;
    public static final int C3 = 15;
    public static final int C4 = 21;
    public static final int SIZE = 24;
    public static final int U1 = 4;
    public static final int U2 = 10;
    public static final int U3 = 16;
    public static final int U4 = 22;
    public static final int V1 = 5;
    public static final int V2 = 11;
    public static final int V3 = 17;
    public static final int V4 = 23;
    private static final int VERTEX_SIZE = 6;
    public static final int X1 = 0;
    public static final int X2 = 6;
    public static final int X3 = 12;
    public static final int X4 = 18;
    public static final int Y1 = 1;
    public static final int Y2 = 7;
    public static final int Y3 = 13;
    public static final int Y4 = 19;
    public static final int Z1 = 2;
    public static final int Z2 = 8;
    public static final int Z3 = 14;
    public static final int Z4 = 20;
    static final Vector3 dir;
    protected static Quaternion rotator;
    private static Vector3 tmp;
    private static Vector3 tmp2;
    protected Color color;
    protected Vector2 dimensions;
    protected DecalMaterial material;
    protected Vector3 position;
    protected Quaternion rotation;
    protected Vector2 scale;
    public Vector2 transformationOffset = null;
    protected boolean updated = false;
    public int value;
    protected float[] vertices = new float[24];

    static {
        tmp = new Vector3();
        tmp2 = new Vector3();
        dir = new Vector3();
        rotator = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Decal() {
        this.position = new Vector3();
        this.rotation = new Quaternion();
        this.scale = new Vector2(1.0f, 1.0f);
        this.color = new Color();
        this.dimensions = new Vector2();
        this.material = new DecalMaterial();
    }

    public Decal(DecalMaterial decalMaterial) {
        this.position = new Vector3();
        this.rotation = new Quaternion();
        this.scale = new Vector2(1.0f, 1.0f);
        this.color = new Color();
        this.dimensions = new Vector2();
        this.material = decalMaterial;
    }

    public static Decal newDecal(float f, float f2, TextureRegion textureRegion) {
        return Decal.newDecal(f, f2, textureRegion, -1, -1);
    }

    public static Decal newDecal(float f, float f2, TextureRegion object, int n, int n2) {
        Decal decal = new Decal();
        decal.setTextureRegion((TextureRegion)object);
        decal.setBlending(n, n2);
        object = decal.dimensions;
        ((Vector2)object).x = f;
        ((Vector2)object).y = f2;
        decal.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        return decal;
    }

    public static Decal newDecal(float f, float f2, TextureRegion object, int n, int n2, DecalMaterial object2) {
        object2 = new Decal((DecalMaterial)object2);
        ((Decal)object2).setTextureRegion((TextureRegion)object);
        ((Decal)object2).setBlending(n, n2);
        object = ((Decal)object2).dimensions;
        ((Vector2)object).x = f;
        ((Vector2)object).y = f2;
        ((Decal)object2).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        return object2;
    }

    public static Decal newDecal(float f, float f2, TextureRegion textureRegion, boolean bl) {
        int n = -1;
        int n2 = bl ? 770 : -1;
        if (bl) {
            n = 771;
        }
        return Decal.newDecal(f, f2, textureRegion, n2, n);
    }

    public static Decal newDecal(TextureRegion textureRegion) {
        return Decal.newDecal(textureRegion.getRegionWidth(), textureRegion.getRegionHeight(), textureRegion, -1, -1);
    }

    public static Decal newDecal(TextureRegion textureRegion, boolean bl) {
        float f = textureRegion.getRegionWidth();
        float f2 = textureRegion.getRegionHeight();
        int n = -1;
        int n2 = bl ? 770 : -1;
        if (bl) {
            n = 771;
        }
        return Decal.newDecal(f, f2, textureRegion, n2, n);
    }

    public Color getColor() {
        return this.color;
    }

    public float getHeight() {
        return this.dimensions.y;
    }

    public DecalMaterial getMaterial() {
        return this.material;
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public float getScaleX() {
        return this.scale.x;
    }

    public float getScaleY() {
        return this.scale.y;
    }

    public TextureRegion getTextureRegion() {
        return this.material.textureRegion;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public float getWidth() {
        return this.dimensions.x;
    }

    public float getX() {
        return this.position.x;
    }

    public float getY() {
        return this.position.y;
    }

    public float getZ() {
        return this.position.z;
    }

    public void lookAt(Vector3 vector3, Vector3 vector32) {
        dir.set(vector3).sub(this.position).nor();
        this.setRotation(dir, vector32);
    }

    protected void resetVertices() {
        float f = -this.dimensions.x / 2.0f;
        float f2 = this.dimensions.x + f;
        float f3 = this.dimensions.y / 2.0f;
        float f4 = f3 - this.dimensions.y;
        float[] fArray = this.vertices;
        fArray[0] = f;
        fArray[1] = f3;
        fArray[2] = 0.0f;
        fArray[6] = f2;
        fArray[7] = f3;
        fArray[8] = 0.0f;
        fArray[12] = f;
        fArray[13] = f4;
        fArray[14] = 0.0f;
        fArray[18] = f2;
        fArray[19] = f4;
        fArray[20] = 0.0f;
        this.updated = false;
    }

    public void rotateX(float f) {
        rotator.set(Vector3.X, f);
        this.rotation.mul(rotator);
        this.updated = false;
    }

    public void rotateY(float f) {
        rotator.set(Vector3.Y, f);
        this.rotation.mul(rotator);
        this.updated = false;
    }

    public void rotateZ(float f) {
        rotator.set(Vector3.Z, f);
        this.rotation.mul(rotator);
        this.updated = false;
    }

    public void setBlending(int n, int n2) {
        DecalMaterial decalMaterial = this.material;
        decalMaterial.srcBlendFactor = n;
        decalMaterial.dstBlendFactor = n2;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
        int n = (int)(f4 * 255.0f);
        int n2 = (int)(f3 * 255.0f);
        int n3 = (int)(f2 * 255.0f);
        f = NumberUtils.intToFloatColor((int)(f * 255.0f) | (n3 << 8 | (n2 << 16 | n << 24)));
        float[] fArray = this.vertices;
        fArray[3] = f;
        fArray[9] = f;
        fArray[15] = f;
        fArray[21] = f;
    }

    public void setColor(Color object) {
        this.color.set((Color)object);
        float f = ((Color)object).toFloatBits();
        object = this.vertices;
        object[3] = f;
        object[9] = f;
        object[15] = f;
        object[21] = f;
    }

    public void setDimensions(float f, float f2) {
        this.dimensions.set(f, f2);
        this.updated = false;
    }

    public void setHeight(float f) {
        this.dimensions.y = f;
        this.updated = false;
    }

    public void setMaterial(DecalMaterial decalMaterial) {
        this.material = decalMaterial;
    }

    public void setPackedColor(float f) {
        Color.abgr8888ToColor(this.color, f);
        float[] fArray = this.vertices;
        fArray[3] = f;
        fArray[9] = f;
        fArray[15] = f;
        fArray[21] = f;
    }

    public void setPosition(float f, float f2, float f3) {
        this.position.set(f, f2, f3);
        this.updated = false;
    }

    public void setPosition(Vector3 vector3) {
        this.position.set(vector3);
        this.updated = false;
    }

    public void setRotation(float f, float f2, float f3) {
        this.rotation.setEulerAngles(f, f2, f3);
        this.updated = false;
    }

    public void setRotation(Quaternion quaternion) {
        this.rotation.set(quaternion);
        this.updated = false;
    }

    public void setRotation(Vector3 vector3, Vector3 vector32) {
        tmp.set(vector32).crs(vector3).nor();
        tmp2.set(vector3).crs(tmp).nor();
        this.rotation.setFromAxes(Decal.tmp.x, Decal.tmp2.x, vector3.x, Decal.tmp.y, Decal.tmp2.y, vector3.y, Decal.tmp.z, Decal.tmp2.z, vector3.z);
        this.updated = false;
    }

    public void setRotationX(float f) {
        this.rotation.set(Vector3.X, f);
        this.updated = false;
    }

    public void setRotationY(float f) {
        this.rotation.set(Vector3.Y, f);
        this.updated = false;
    }

    public void setRotationZ(float f) {
        this.rotation.set(Vector3.Z, f);
        this.updated = false;
    }

    public void setScale(float f) {
        this.scale.set(f, f);
        this.updated = false;
    }

    public void setScale(float f, float f2) {
        this.scale.set(f, f2);
        this.updated = false;
    }

    public void setScaleX(float f) {
        this.scale.x = f;
        this.updated = false;
    }

    public void setScaleY(float f) {
        this.scale.y = f;
        this.updated = false;
    }

    public void setTextureRegion(TextureRegion textureRegion) {
        this.material.textureRegion = textureRegion;
        this.updateUVs();
    }

    public void setWidth(float f) {
        this.dimensions.x = f;
        this.updated = false;
    }

    public void setX(float f) {
        this.position.x = f;
        this.updated = false;
    }

    public void setY(float f) {
        this.position.y = f;
        this.updated = false;
    }

    public void setZ(float f) {
        this.position.z = f;
        this.updated = false;
    }

    protected void transformVertices() {
        float f;
        float f2;
        Object object = this.transformationOffset;
        if (object != null) {
            f2 = -((Vector2)object).x;
            f = -this.transformationOffset.y;
        } else {
            f2 = 0.0f;
            f = 0.0f;
        }
        Object object2 = (this.vertices[0] + f2) * this.scale.x;
        Object object3 = (this.vertices[1] + f) * this.scale.y;
        object = this.vertices;
        Object object4 = object[2];
        object[0] = this.rotation.w * object2 + this.rotation.y * object4 - this.rotation.z * object3;
        this.vertices[1] = this.rotation.w * object3 + this.rotation.z * object2 - this.rotation.x * object4;
        this.vertices[2] = this.rotation.w * object4 + this.rotation.x * object3 - this.rotation.y * object2;
        object2 = -this.rotation.x * object2 - this.rotation.y * object3 - this.rotation.z * object4;
        this.rotation.conjugate();
        object = this.vertices;
        object4 = object[0];
        Object object5 = object[1];
        object3 = object[2];
        object[0] = this.rotation.x * object2 + this.rotation.w * object4 + this.rotation.z * object5 - this.rotation.y * object3;
        this.vertices[1] = this.rotation.y * object2 + this.rotation.w * object5 + this.rotation.x * object3 - this.rotation.z * object4;
        this.vertices[2] = object2 * this.rotation.z + object3 * this.rotation.w + object4 * this.rotation.y - object5 * this.rotation.x;
        this.rotation.conjugate();
        object = this.vertices;
        object[0] = object[0] + (this.position.x - f2);
        object = this.vertices;
        object[1] = object[1] + (this.position.y - f);
        object = this.vertices;
        object[2] = object[2] + this.position.z;
        object3 = (this.vertices[6] + f2) * this.scale.x;
        object4 = (this.vertices[7] + f) * this.scale.y;
        object = this.vertices;
        object2 = object[8];
        object[6] = this.rotation.w * object3 + this.rotation.y * object2 - this.rotation.z * object4;
        this.vertices[7] = this.rotation.w * object4 + this.rotation.z * object3 - this.rotation.x * object2;
        this.vertices[8] = this.rotation.w * object2 + this.rotation.x * object4 - this.rotation.y * object3;
        object2 = -this.rotation.x * object3 - this.rotation.y * object4 - this.rotation.z * object2;
        this.rotation.conjugate();
        object = this.vertices;
        object4 = object[6];
        object3 = object[7];
        object5 = object[8];
        object[6] = this.rotation.x * object2 + this.rotation.w * object4 + this.rotation.z * object3 - this.rotation.y * object5;
        this.vertices[7] = this.rotation.y * object2 + this.rotation.w * object3 + this.rotation.x * object5 - this.rotation.z * object4;
        this.vertices[8] = object2 * this.rotation.z + object5 * this.rotation.w + object4 * this.rotation.y - object3 * this.rotation.x;
        this.rotation.conjugate();
        object = this.vertices;
        object[6] = object[6] + (this.position.x - f2);
        object = this.vertices;
        object[7] = object[7] + (this.position.y - f);
        object = this.vertices;
        object[8] = object[8] + this.position.z;
        object4 = (this.vertices[12] + f2) * this.scale.x;
        object2 = (this.vertices[13] + f) * this.scale.y;
        object = this.vertices;
        object3 = object[14];
        object[12] = this.rotation.w * object4 + this.rotation.y * object3 - this.rotation.z * object2;
        this.vertices[13] = this.rotation.w * object2 + this.rotation.z * object4 - this.rotation.x * object3;
        this.vertices[14] = this.rotation.w * object3 + this.rotation.x * object2 - this.rotation.y * object4;
        object5 = -this.rotation.x * object4 - this.rotation.y * object2 - this.rotation.z * object3;
        this.rotation.conjugate();
        object = this.vertices;
        object2 = object[12];
        object3 = object[13];
        object4 = object[14];
        object[12] = this.rotation.x * object5 + this.rotation.w * object2 + this.rotation.z * object3 - this.rotation.y * object4;
        this.vertices[13] = this.rotation.y * object5 + this.rotation.w * object3 + this.rotation.x * object4 - this.rotation.z * object2;
        this.vertices[14] = (float)(object5 * this.rotation.z + object4 * this.rotation.w + object2 * this.rotation.y - object3 * this.rotation.x);
        this.rotation.conjugate();
        object = this.vertices;
        object[12] = object[12] + (this.position.x - f2);
        object = this.vertices;
        object[13] = object[13] + (this.position.y - f);
        object = this.vertices;
        object[14] = object[14] + this.position.z;
        object2 = (this.vertices[18] + f2) * this.scale.x;
        object3 = (this.vertices[19] + f) * this.scale.y;
        object = this.vertices;
        object4 = object[20];
        object[18] = this.rotation.w * object2 + this.rotation.y * object4 - this.rotation.z * object3;
        this.vertices[19] = this.rotation.w * object3 + this.rotation.z * object2 - this.rotation.x * object4;
        this.vertices[20] = this.rotation.w * object4 + this.rotation.x * object3 - this.rotation.y * object2;
        object4 = -this.rotation.x * object2 - this.rotation.y * object3 - this.rotation.z * object4;
        this.rotation.conjugate();
        object = this.vertices;
        object3 = object[18];
        object2 = object[19];
        object5 = object[20];
        object[18] = this.rotation.x * object4 + this.rotation.w * object3 + this.rotation.z * object2 - this.rotation.y * object5;
        this.vertices[19] = this.rotation.y * object4 + this.rotation.w * object2 + this.rotation.x * object5 - this.rotation.z * object3;
        this.vertices[20] = (float)(object4 * this.rotation.z + object5 * this.rotation.w + object3 * this.rotation.y - object2 * this.rotation.x);
        this.rotation.conjugate();
        object = this.vertices;
        object[18] = object[18] + (this.position.x - f2);
        object = this.vertices;
        object[19] = object[19] + (this.position.y - f);
        object = this.vertices;
        object[20] = object[20] + this.position.z;
        this.updated = true;
    }

    public void translate(float f, float f2, float f3) {
        this.position.add(f, f2, f3);
        this.updated = false;
    }

    public void translate(Vector3 vector3) {
        this.position.add(vector3);
        this.updated = false;
    }

    public void translateX(float f) {
        Vector3 vector3 = this.position;
        vector3.x += f;
        this.updated = false;
    }

    public void translateY(float f) {
        Vector3 vector3 = this.position;
        vector3.y += f;
        this.updated = false;
    }

    public void translateZ(float f) {
        Vector3 vector3 = this.position;
        vector3.z += f;
        this.updated = false;
    }

    protected void update() {
        if (!this.updated) {
            this.resetVertices();
            this.transformVertices();
        }
    }

    protected void updateUVs() {
        TextureRegion textureRegion = this.material.textureRegion;
        this.vertices[4] = textureRegion.getU();
        this.vertices[5] = textureRegion.getV();
        this.vertices[10] = textureRegion.getU2();
        this.vertices[11] = textureRegion.getV();
        this.vertices[16] = textureRegion.getU();
        this.vertices[17] = textureRegion.getV2();
        this.vertices[22] = textureRegion.getU2();
        this.vertices[23] = textureRegion.getV2();
    }
}

