/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.PolygonBatch;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;

public class PolygonSpriteBatch
implements PolygonBatch {
    private int blendDstFunc = 771;
    private int blendDstFuncAlpha = 771;
    private int blendSrcFunc = 770;
    private int blendSrcFuncAlpha = 770;
    private boolean blendingDisabled;
    private final Color color;
    float colorPacked;
    private final Matrix4 combinedMatrix;
    private ShaderProgram customShader;
    private boolean drawing;
    private float invTexHeight = 0.0f;
    private float invTexWidth = 0.0f;
    private Texture lastTexture;
    public int maxTrianglesInBatch = 0;
    private Mesh mesh;
    private boolean ownsShader;
    private final Matrix4 projectionMatrix;
    public int renderCalls = 0;
    private final ShaderProgram shader;
    public int totalRenderCalls = 0;
    private final Matrix4 transformMatrix = new Matrix4();
    private int triangleIndex;
    private final short[] triangles;
    private int vertexIndex;
    private final float[] vertices;

    public PolygonSpriteBatch() {
        this(2000, null);
    }

    public PolygonSpriteBatch(int n) {
        this(n, n * 2, null);
    }

    public PolygonSpriteBatch(int n, int n2, ShaderProgram object) {
        this.projectionMatrix = new Matrix4();
        this.combinedMatrix = new Matrix4();
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.colorPacked = Color.WHITE_FLOAT_BITS;
        if (n <= Short.MAX_VALUE) {
            Mesh.VertexDataType vertexDataType = Mesh.VertexDataType.VertexArray;
            if (Gdx.gl30 != null) {
                vertexDataType = Mesh.VertexDataType.VertexBufferObjectWithVAO;
            }
            this.mesh = new Mesh(vertexDataType, false, n, n2 *= 3, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
            this.vertices = new float[n * 5];
            this.triangles = new short[n2];
            if (object == null) {
                this.shader = SpriteBatch.createDefaultShader();
                this.ownsShader = true;
            } else {
                this.shader = object;
            }
            this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Can't have more than 32767 vertices per batch: ");
        ((StringBuilder)object).append(n);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public PolygonSpriteBatch(int n, ShaderProgram shaderProgram) {
        this(n, n * 2, shaderProgram);
    }

    private void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        ShaderProgram shaderProgram = this.customShader;
        if (shaderProgram != null) {
            shaderProgram.setUniformMatrix("u_projTrans", this.combinedMatrix);
            this.customShader.setUniformi("u_texture", 0);
        } else {
            this.shader.setUniformMatrix("u_projTrans", this.combinedMatrix);
            this.shader.setUniformi("u_texture", 0);
        }
    }

    private void switchTexture(Texture texture) {
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)texture.getWidth();
        this.invTexHeight = 1.0f / (float)texture.getHeight();
    }

    @Override
    public void begin() {
        if (!this.drawing) {
            this.renderCalls = 0;
            Gdx.gl.glDepthMask(false);
            ShaderProgram shaderProgram = this.customShader;
            if (shaderProgram != null) {
                shaderProgram.begin();
            } else {
                this.shader.begin();
            }
            this.setupMatrices();
            this.drawing = true;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.end must be called before begin.");
    }

    @Override
    public void disableBlending() {
        this.flush();
        this.blendingDisabled = true;
    }

    @Override
    public void dispose() {
        ShaderProgram shaderProgram;
        this.mesh.dispose();
        if (this.ownsShader && (shaderProgram = this.shader) != null) {
            shaderProgram.dispose();
        }
    }

    @Override
    public void draw(Texture texture, float f, float f2) {
        this.draw(texture, f, f2, (float)texture.getWidth(), (float)texture.getHeight());
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4) {
        if (this.drawing) {
            short[] sArray = this.triangles;
            float[] fArray = this.vertices;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                this.flush();
            }
            int n = this.triangleIndex;
            int n2 = this.vertexIndex;
            int n3 = n2 / 5;
            int n4 = n + 1;
            int n5 = n3;
            sArray[n] = (short)n5;
            n = n4 + 1;
            sArray[n4] = (short)(n3 + 1);
            n4 = n + 1;
            short s = (short)(n3 + 2);
            sArray[n] = s;
            n = n4 + 1;
            sArray[n4] = s;
            n4 = n + 1;
            sArray[n] = (short)(n3 + 3);
            sArray[n4] = (short)n5;
            this.triangleIndex = n4 + 1;
            f3 += f;
            f4 += f2;
            float f5 = this.colorPacked;
            n3 = n2 + 1;
            fArray[n2] = f;
            n5 = n3 + 1;
            fArray[n3] = f2;
            n2 = n5 + 1;
            fArray[n5] = f5;
            n5 = n2 + 1;
            fArray[n2] = 0.0f;
            n3 = n5 + 1;
            fArray[n5] = 1.0f;
            n2 = n3 + 1;
            fArray[n3] = f;
            n3 = n2 + 1;
            fArray[n2] = f4;
            n2 = n3 + 1;
            fArray[n3] = f5;
            n5 = n2 + 1;
            fArray[n2] = 0.0f;
            n3 = n5 + 1;
            fArray[n5] = 0.0f;
            n2 = n3 + 1;
            fArray[n3] = f3;
            n3 = n2 + 1;
            fArray[n2] = f4;
            n2 = n3 + 1;
            fArray[n3] = f5;
            n5 = n2 + 1;
            fArray[n2] = 1.0f;
            n3 = n5 + 1;
            fArray[n5] = 0.0f;
            n2 = n3 + 1;
            fArray[n3] = f3;
            n3 = n2 + 1;
            fArray[n2] = f2;
            n2 = n3 + 1;
            fArray[n3] = f5;
            n3 = n2 + 1;
            fArray[n2] = 1.0f;
            fArray[n3] = 1.0f;
            this.vertexIndex = n3 + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.drawing) {
            short[] sArray = this.triangles;
            float[] fArray = this.vertices;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                this.flush();
            }
            int n = this.triangleIndex;
            int n2 = this.vertexIndex;
            int n3 = n2 / 5;
            int n4 = n + 1;
            int n5 = n3;
            sArray[n] = (short)n5;
            int n6 = n4 + 1;
            sArray[n4] = (short)(n3 + 1);
            n4 = n6 + 1;
            n = (short)(n3 + 2);
            sArray[n6] = (short)n;
            n6 = n4 + 1;
            sArray[n4] = (short)n;
            n4 = n6 + 1;
            sArray[n6] = (short)(n3 + 3);
            sArray[n4] = (short)n5;
            this.triangleIndex = n4 + 1;
            f3 = f + f3;
            f4 = f2 + f4;
            float f9 = this.colorPacked;
            n3 = n2 + 1;
            fArray[n2] = f;
            n2 = n3 + 1;
            fArray[n3] = f2;
            n3 = n2 + 1;
            fArray[n2] = f9;
            n2 = n3 + 1;
            fArray[n3] = f5;
            n3 = n2 + 1;
            fArray[n2] = f6;
            n2 = n3 + 1;
            fArray[n3] = f;
            n3 = n2 + 1;
            fArray[n2] = f4;
            n2 = n3 + 1;
            fArray[n3] = f9;
            n3 = n2 + 1;
            fArray[n2] = f5;
            n2 = n3 + 1;
            fArray[n3] = f8;
            n3 = n2 + 1;
            fArray[n2] = f3;
            n5 = n3 + 1;
            fArray[n3] = f4;
            n2 = n5 + 1;
            fArray[n5] = f9;
            n3 = n2 + 1;
            fArray[n2] = f7;
            n5 = n3 + 1;
            fArray[n3] = f8;
            n2 = n5 + 1;
            fArray[n5] = f3;
            n3 = n2 + 1;
            fArray[n2] = f2;
            n2 = n3 + 1;
            fArray[n3] = f9;
            n3 = n2 + 1;
            fArray[n2] = f7;
            fArray[n3] = f6;
            this.vertexIndex = n3 + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        block10: {
            float f10;
            float f11;
            float f12;
            float f13;
            float f14;
            block12: {
                block11: {
                    if (!this.drawing) break block10;
                    short[] sArray = this.triangles;
                    float[] fArray = this.vertices;
                    if (texture != this.lastTexture) {
                        this.switchTexture(texture);
                    } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                        this.flush();
                    }
                    int n5 = this.triangleIndex;
                    int n6 = this.vertexIndex / 5;
                    int n7 = n5 + 1;
                    short s = (short)n6;
                    sArray[n5] = s;
                    int n8 = n7 + 1;
                    sArray[n7] = (short)(n6 + 1);
                    n7 = n8 + 1;
                    n5 = (short)(n6 + 2);
                    sArray[n8] = (short)n5;
                    n8 = n7 + 1;
                    sArray[n7] = (short)n5;
                    n7 = n8 + 1;
                    sArray[n8] = (short)(n6 + 3);
                    sArray[n7] = s;
                    this.triangleIndex = n7 + 1;
                    f14 = f + f3;
                    f13 = f2 + f4;
                    f12 = -f3;
                    f11 = -f4;
                    f5 -= f3;
                    f6 -= f4;
                    if (f7 != 1.0f) break block11;
                    f = f5;
                    f2 = f6;
                    f4 = f12;
                    f3 = f11;
                    if (f8 == 1.0f) break block12;
                }
                f4 = f12 * f7;
                f3 = f11 * f8;
                f = f5 * f7;
                f2 = f6 * f8;
            }
            if (f9 != 0.0f) {
                f6 = MathUtils.cosDeg(f9);
                f8 = MathUtils.sinDeg(f9);
                f5 = f6 * f4;
                f7 = f5 - f8 * f3;
                f9 = f4 * f8;
                f3 = f3 * f6 + f9;
                f4 = f8 * f2;
                f11 = f2 * f6;
                f9 += f11;
                f2 = f6 * f - f4;
                f11 += f8 * f;
                f8 = f2 - (f5 -= f4) + f7;
                f = f2;
                f6 = f11;
                f2 = f9;
                f4 = f7;
                f9 = f11 - (f9 - f3);
                f7 = f8;
                f8 = f9;
            } else {
                f7 = f;
                f6 = f2;
                f5 = f4;
                f8 = f3;
            }
            f9 = n;
            f12 = this.invTexWidth;
            f11 = f9 * f12;
            f9 = n2 + n4;
            float f15 = this.invTexHeight;
            f9 *= f15;
            f12 = (float)(n + n3) * f12;
            f15 = (float)n2 * f15;
            if (!bl) {
                f10 = f11;
                f11 = f12;
                f12 = f10;
            }
            if (!bl2) {
                f10 = f15;
                f15 = f9;
                f9 = f10;
            }
            f10 = this.colorPacked;
            n2 = this.vertexIndex;
            n = n2 + 1;
            fArray[n2] = f4 + f14;
            n2 = n + 1;
            fArray[n] = f3 + f13;
            n = n2 + 1;
            fArray[n2] = f10;
            n2 = n + 1;
            fArray[n] = f12;
            n = n2 + 1;
            fArray[n2] = f15;
            n2 = n + 1;
            fArray[n] = f5 + f14;
            n = n2 + 1;
            fArray[n2] = f2 + f13;
            n2 = n + 1;
            fArray[n] = f10;
            n = n2 + 1;
            fArray[n2] = f12;
            n2 = n + 1;
            fArray[n] = f9;
            n = n2 + 1;
            fArray[n2] = f + f14;
            n2 = n + 1;
            fArray[n] = f6 + f13;
            n = n2 + 1;
            fArray[n2] = f10;
            n2 = n + 1;
            fArray[n] = f11;
            n = n2 + 1;
            fArray[n2] = f9;
            n2 = n + 1;
            fArray[n] = f7 + f14;
            n3 = n2 + 1;
            fArray[n2] = f8 + f13;
            n = n3 + 1;
            fArray[n3] = f10;
            n2 = n + 1;
            fArray[n] = f11;
            fArray[n2] = f15;
            this.vertexIndex = n2 + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (this.drawing) {
            short[] sArray = this.triangles;
            float[] fArray = this.vertices;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                this.flush();
            }
            int n5 = this.triangleIndex;
            int n6 = this.vertexIndex / 5;
            int n7 = n5 + 1;
            short s = (short)n6;
            sArray[n5] = s;
            int n8 = n7 + 1;
            sArray[n7] = (short)(n6 + 1);
            n7 = n8 + 1;
            n5 = (short)(n6 + 2);
            sArray[n8] = (short)n5;
            n8 = n7 + 1;
            sArray[n7] = (short)n5;
            n7 = n8 + 1;
            sArray[n8] = (short)(n6 + 3);
            sArray[n7] = s;
            this.triangleIndex = n7 + 1;
            float f5 = n;
            float f6 = this.invTexWidth;
            float f7 = f5 * f6;
            f5 = n2 + n4;
            float f8 = this.invTexHeight;
            f5 *= f8;
            f6 = (float)(n + n3) * f6;
            f8 = (float)n2 * f8;
            float f9 = f + f3;
            float f10 = f2 + f4;
            if (bl) {
                f3 = f6;
            } else {
                f3 = f7;
                f7 = f6;
            }
            f6 = f8;
            f4 = f5;
            if (bl2) {
                f4 = f8;
                f6 = f5;
            }
            f5 = this.colorPacked;
            n2 = this.vertexIndex;
            n = n2 + 1;
            fArray[n2] = f;
            n2 = n + 1;
            fArray[n] = f2;
            n = n2 + 1;
            fArray[n2] = f5;
            n2 = n + 1;
            fArray[n] = f3;
            n = n2 + 1;
            fArray[n2] = f4;
            n2 = n + 1;
            fArray[n] = f;
            n3 = n2 + 1;
            fArray[n2] = f10;
            n = n3 + 1;
            fArray[n3] = f5;
            n3 = n + 1;
            fArray[n] = f3;
            n2 = n3 + 1;
            fArray[n3] = f6;
            n = n2 + 1;
            fArray[n2] = f9;
            n2 = n + 1;
            fArray[n] = f10;
            n = n2 + 1;
            fArray[n2] = f5;
            n2 = n + 1;
            fArray[n] = f7;
            n3 = n2 + 1;
            fArray[n2] = f6;
            n = n3 + 1;
            fArray[n3] = f9;
            n2 = n + 1;
            fArray[n] = f2;
            n = n2 + 1;
            fArray[n2] = f5;
            n2 = n + 1;
            fArray[n] = f7;
            fArray[n2] = f4;
            this.vertexIndex = n2 + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2, int n, int n2, int n3, int n4) {
        if (this.drawing) {
            short[] sArray = this.triangles;
            float[] fArray = this.vertices;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                this.flush();
            }
            int n5 = this.triangleIndex;
            int n6 = this.vertexIndex;
            int n7 = n6 / 5;
            int n8 = n5 + 1;
            short s = (short)n7;
            sArray[n5] = s;
            n5 = n8 + 1;
            sArray[n8] = (short)(n7 + 1);
            int n9 = n5 + 1;
            n8 = (short)(n7 + 2);
            sArray[n5] = (short)n8;
            n5 = n9 + 1;
            sArray[n9] = (short)n8;
            n8 = n5 + 1;
            sArray[n5] = (short)(n7 + 3);
            sArray[n8] = s;
            this.triangleIndex = n8 + 1;
            float f3 = n;
            float f4 = this.invTexWidth;
            f3 *= f4;
            float f5 = n2 + n4;
            float f6 = this.invTexHeight;
            f5 *= f6;
            f4 = (float)(n + n3) * f4;
            f6 = (float)n2 * f6;
            float f7 = (float)n3 + f;
            float f8 = (float)n4 + f2;
            float f9 = this.colorPacked;
            n = n6 + 1;
            fArray[n6] = f;
            n2 = n + 1;
            fArray[n] = f2;
            n = n2 + 1;
            fArray[n2] = f9;
            n2 = n + 1;
            fArray[n] = f3;
            n = n2 + 1;
            fArray[n2] = f5;
            n2 = n + 1;
            fArray[n] = f;
            n = n2 + 1;
            fArray[n2] = f8;
            n2 = n + 1;
            fArray[n] = f9;
            n = n2 + 1;
            fArray[n2] = f3;
            n3 = n + 1;
            fArray[n] = f6;
            n2 = n3 + 1;
            fArray[n3] = f7;
            n = n2 + 1;
            fArray[n2] = f8;
            n3 = n + 1;
            fArray[n] = f9;
            n2 = n3 + 1;
            fArray[n3] = f4;
            n = n2 + 1;
            fArray[n2] = f6;
            n2 = n + 1;
            fArray[n] = f7;
            n = n2 + 1;
            fArray[n2] = f2;
            n2 = n + 1;
            fArray[n] = f9;
            n = n2 + 1;
            fArray[n2] = f4;
            fArray[n] = f5;
            this.vertexIndex = n + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void draw(Texture var1_1, float[] var2_2, int var3_3, int var4_4) {
        if (this.drawing) {
            var5_5 = this.triangles;
            var6_6 = this.vertices;
            var7_7 = var4_4 / 20 * 6;
            if (var1_1 != this.lastTexture) {
                this.switchTexture((Texture)var1_1);
                var8_8 = Math.min(Math.min(var4_4, var6_6.length - var6_6.length % 20), var5_5.length / 6 * 20);
                var9_9 = var8_8 / 20;
lbl9:
                // 2 sources

                while (true) {
                    var7_7 = var9_9 * 6;
                    break;
                }
            } else if (this.triangleIndex + var7_7 <= var5_5.length && this.vertexIndex + var4_4 <= var6_6.length) {
                var8_8 = var4_4;
            } else {
                this.flush();
                var8_8 = Math.min(Math.min(var4_4, var6_6.length - var6_6.length % 20), var5_5.length / 6 * 20);
                var9_9 = var8_8 / 20;
                ** continue;
            }
            var10_10 = this.vertexIndex;
            var11_11 = (short)(var10_10 / 5);
            var9_9 = var12_12 = this.triangleIndex;
            while (true) {
                var13_13 = var9_9;
                var9_9 = var10_10;
                var14_14 = var13_13;
                var15_15 = var8_8;
                var16_16 = var3_3;
                var17_17 = var4_4;
                if (var13_13 >= var7_7 + var12_12) break;
                var5_5[var13_13] = var11_11;
                var5_5[var13_13 + 1] = (short)(var11_11 + 1);
                var9_9 = (short)(var11_11 + 2);
                var5_5[var13_13 + 2] = (short)var9_9;
                var5_5[var13_13 + 3] = (short)var9_9;
                var5_5[var13_13 + 4] = (short)(var11_11 + 3);
                var5_5[var13_13 + 5] = var11_11;
                var9_9 = var13_13 + 6;
                var11_11 = (short)(var11_11 + 4);
            }
            while (true) {
                System.arraycopy(var2_2, var16_16, var6_6, var9_9, var15_15);
                this.vertexIndex = var9_9 + var15_15;
                this.triangleIndex = var14_14;
                var8_8 = var17_17 - var15_15;
                if (var8_8 == 0) {
                    return;
                }
                var3_3 = var16_16 + var15_15;
                this.flush();
                var9_9 = var4_4 = 0;
                var16_16 = var3_3;
                var17_17 = var8_8;
                if (var15_15 <= var8_8) continue;
                var15_15 = Math.min(var8_8, var5_5.length / 6 * 20);
                var14_14 = var15_15 / 20 * 6;
                var9_9 = var4_4;
                var16_16 = var3_3;
                var17_17 = var8_8;
            }
        }
        var1_1 = new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        throw var1_1;
    }

    @Override
    public void draw(Texture object, float[] fArray, int n, int n2, short[] sArray, int n3, int n4) {
        if (this.drawing) {
            short[] sArray2 = this.triangles;
            float[] fArray2 = this.vertices;
            if (object != this.lastTexture) {
                this.switchTexture((Texture)object);
            } else if (this.triangleIndex + n4 > sArray2.length || this.vertexIndex + n2 > fArray2.length) {
                this.flush();
            }
            int n5 = this.triangleIndex;
            int n6 = this.vertexIndex;
            int n7 = n6 / 5;
            int n8 = n3;
            while (n8 < n4 + n3) {
                sArray2[n5] = (short)(sArray[n8] + n7);
                ++n8;
                ++n5;
            }
            this.triangleIndex = n5;
            System.arraycopy(fArray, n, fArray2, n6, n2);
            this.vertexIndex += n2;
            return;
        }
        object = new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        throw object;
    }

    @Override
    public void draw(PolygonRegion object, float f, float f2) {
        if (this.drawing) {
            short[] sArray = this.triangles;
            short[] sArray2 = ((PolygonRegion)object).triangles;
            int n = sArray2.length;
            float[] fArray = ((PolygonRegion)object).vertices;
            int n2 = fArray.length;
            Object object2 = ((PolygonRegion)object).region.texture;
            if (object2 != this.lastTexture) {
                this.switchTexture((Texture)object2);
            } else if (this.triangleIndex + n > sArray.length || this.vertexIndex + n2 * 5 / 2 > this.vertices.length) {
                this.flush();
            }
            int n3 = this.triangleIndex;
            int n4 = this.vertexIndex;
            int n5 = n4 / 5;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n) {
                sArray[n3] = (short)(sArray2[n7] + n5);
                ++n7;
                ++n3;
            }
            this.triangleIndex = n3;
            object2 = this.vertices;
            float f3 = this.colorPacked;
            object = ((PolygonRegion)object).textureCoords;
            n7 = n4;
            for (n3 = n6; n3 < n2; n3 += 2) {
                n4 = n7 + 1;
                object2[n7] = fArray[n3] + f;
                n6 = n4 + 1;
                n7 = n3 + 1;
                object2[n4] = fArray[n7] + f2;
                n4 = n6 + 1;
                object2[n6] = f3;
                n6 = n4 + 1;
                object2[n4] = object[n3];
                object2[n6] = object[n7];
                n7 = n6 + 1;
            }
            this.vertexIndex = n7;
            return;
        }
        object = new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        throw object;
    }

    @Override
    public void draw(PolygonRegion object, float f, float f2, float f3, float f4) {
        if (this.drawing) {
            Object[] objectArray = this.triangles;
            short[] sArray = ((PolygonRegion)object).triangles;
            int n = sArray.length;
            float[] fArray = ((PolygonRegion)object).vertices;
            int n2 = fArray.length;
            TextureRegion textureRegion = ((PolygonRegion)object).region;
            Texture texture = textureRegion.texture;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.triangleIndex + n > objectArray.length || this.vertexIndex + n2 * 5 / 2 > this.vertices.length) {
                this.flush();
            }
            n = this.triangleIndex;
            int n3 = this.vertexIndex;
            int n4 = n3 / 5;
            int n5 = sArray.length;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                objectArray[n] = (short)(sArray[n7] + n4);
                ++n7;
                ++n;
            }
            this.triangleIndex = n;
            objectArray = this.vertices;
            float f5 = this.colorPacked;
            object = ((PolygonRegion)object).textureCoords;
            f3 /= (float)textureRegion.regionWidth;
            f4 /= (float)textureRegion.regionHeight;
            n7 = n3;
            for (n = n6; n < n2; n += 2) {
                n3 = n7 + 1;
                objectArray[n7] = (short)(fArray[n] * f3 + f);
                n6 = n3 + 1;
                n7 = n + 1;
                objectArray[n3] = (short)(fArray[n7] * f4 + f2);
                n3 = n6 + 1;
                objectArray[n6] = (short)f5;
                n6 = n3 + 1;
                objectArray[n3] = (short)object[n];
                objectArray[n6] = (short)object[n7];
                n7 = n6 + 1;
            }
            this.vertexIndex = n7;
            return;
        }
        object = new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        throw object;
    }

    @Override
    public void draw(PolygonRegion object, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.drawing) {
            short[] sArray = this.triangles;
            short[] sArray2 = ((PolygonRegion)object).triangles;
            int n = sArray2.length;
            float[] fArray = ((PolygonRegion)object).vertices;
            int n2 = fArray.length;
            TextureRegion textureRegion = ((PolygonRegion)object).region;
            Object object2 = textureRegion.texture;
            if (object2 != this.lastTexture) {
                this.switchTexture((Texture)object2);
            } else if (this.triangleIndex + n > sArray.length || this.vertexIndex + n2 * 5 / 2 > this.vertices.length) {
                this.flush();
            }
            int n3 = this.triangleIndex;
            int n4 = this.vertexIndex;
            int n5 = n4 / 5;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n) {
                sArray[n3] = (short)(sArray2[n7] + n5);
                ++n7;
                ++n3;
            }
            this.triangleIndex = n3;
            object2 = this.vertices;
            float f10 = this.colorPacked;
            object = ((PolygonRegion)object).textureCoords;
            f5 /= (float)textureRegion.regionWidth;
            f6 /= (float)textureRegion.regionHeight;
            float f11 = MathUtils.cosDeg(f9);
            float f12 = MathUtils.sinDeg(f9);
            n3 = n6;
            n7 = n4;
            while (n3 < n2) {
                float f13 = (fArray[n3] * f5 - f3) * f7;
                n4 = n3 + 1;
                f9 = (fArray[n4] * f6 - f4) * f8;
                n6 = n7 + 1;
                object2[n7] = f11 * f13 - f12 * f9 + (f + f3);
                n7 = n6 + 1;
                object2[n6] = f13 * f12 + f9 * f11 + (f2 + f4);
                n6 = n7 + 1;
                object2[n7] = f10;
                n7 = n6 + 1;
                object2[n6] = object[n3];
                object2[n7] = object[n4];
                n3 += 2;
                ++n7;
            }
            this.vertexIndex = n7;
            return;
        }
        object = new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
        throw object;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2) {
        this.draw(textureRegion, f, f2, (float)textureRegion.getRegionWidth(), (float)textureRegion.getRegionHeight());
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4) {
        if (this.drawing) {
            short[] sArray = this.triangles;
            float[] fArray = this.vertices;
            Texture texture = textureRegion.texture;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                this.flush();
            }
            int n = this.triangleIndex;
            int n2 = this.vertexIndex / 5;
            int n3 = n + 1;
            int n4 = n2;
            sArray[n] = (short)n4;
            n = n3 + 1;
            sArray[n3] = (short)(n2 + 1);
            int n5 = n + 1;
            n3 = (short)(n2 + 2);
            sArray[n] = (short)n3;
            n = n5 + 1;
            sArray[n5] = (short)n3;
            n3 = n + 1;
            sArray[n] = (short)(n2 + 3);
            sArray[n3] = (short)n4;
            this.triangleIndex = n3 + 1;
            f3 += f;
            float f5 = f4 + f2;
            f4 = textureRegion.u;
            float f6 = textureRegion.v2;
            float f7 = textureRegion.u2;
            float f8 = textureRegion.v;
            float f9 = this.colorPacked;
            n2 = this.vertexIndex;
            n4 = n2 + 1;
            fArray[n2] = f;
            n2 = n4 + 1;
            fArray[n4] = f2;
            n4 = n2 + 1;
            fArray[n2] = f9;
            n2 = n4 + 1;
            fArray[n4] = f4;
            n3 = n2 + 1;
            fArray[n2] = f6;
            n4 = n3 + 1;
            fArray[n3] = f;
            n2 = n4 + 1;
            fArray[n4] = f5;
            n4 = n2 + 1;
            fArray[n2] = f9;
            n2 = n4 + 1;
            fArray[n4] = f4;
            n3 = n2 + 1;
            fArray[n2] = f8;
            n4 = n3 + 1;
            fArray[n3] = f3;
            n2 = n4 + 1;
            fArray[n4] = f5;
            n4 = n2 + 1;
            fArray[n2] = f9;
            n2 = n4 + 1;
            fArray[n4] = f7;
            n4 = n2 + 1;
            fArray[n2] = f8;
            n2 = n4 + 1;
            fArray[n4] = f3;
            n4 = n2 + 1;
            fArray[n2] = f2;
            n2 = n4 + 1;
            fArray[n4] = f9;
            n4 = n2 + 1;
            fArray[n2] = f7;
            fArray[n4] = f6;
            this.vertexIndex = n4 + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        block8: {
            float f10;
            float f11;
            float f12;
            float f13;
            int n;
            int n2;
            int n3;
            block10: {
                block9: {
                    if (!this.drawing) break block8;
                    short[] sArray = this.triangles;
                    float[] fArray = this.vertices;
                    Texture texture = textureRegion.texture;
                    if (texture != this.lastTexture) {
                        this.switchTexture(texture);
                    } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                        this.flush();
                    }
                    int n4 = this.triangleIndex;
                    n3 = this.vertexIndex / 5;
                    n2 = n4 + 1;
                    n = n3;
                    sArray[n4] = (short)n;
                    int n5 = n2 + 1;
                    sArray[n2] = (short)(n3 + 1);
                    n2 = n5 + 1;
                    n4 = (short)(n3 + 2);
                    sArray[n5] = (short)n4;
                    n5 = n2 + 1;
                    sArray[n2] = (short)n4;
                    n2 = n5 + 1;
                    sArray[n5] = (short)(n3 + 3);
                    sArray[n2] = (short)n;
                    this.triangleIndex = n2 + 1;
                    f13 = f + f3;
                    f12 = f2 + f4;
                    f11 = -f3;
                    f10 = -f4;
                    f5 -= f3;
                    f6 -= f4;
                    if (f7 != 1.0f) break block9;
                    f4 = f5;
                    f = f6;
                    f3 = f11;
                    f2 = f10;
                    if (f8 == 1.0f) break block10;
                }
                f3 = f11 * f7;
                f2 = f10 * f8;
                f4 = f5 * f7;
                f = f6 * f8;
            }
            if (f9 != 0.0f) {
                f8 = MathUtils.cosDeg(f9);
                f7 = MathUtils.sinDeg(f9);
                f6 = f8 * f3;
                f5 = f6 - f7 * f2;
                f9 = f3 * f7;
                f2 = f2 * f8 + f9;
                f3 = f7 * f;
                f9 += (f *= f8);
                f8 = f8 * f4 - f3;
                f10 = f + f7 * f4;
                f7 = f8 - (f6 -= f3) + f5;
                f = f10;
                f4 = f9;
                f3 = f5;
                f5 = f10 - (f9 - f2);
            } else {
                f7 = f4;
                f9 = f;
                f6 = f3;
                f5 = f2;
                f8 = f4;
                f4 = f;
                f = f9;
            }
            f11 = textureRegion.u;
            float f14 = textureRegion.v2;
            float f15 = textureRegion.u2;
            f9 = textureRegion.v;
            f10 = this.colorPacked;
            n3 = this.vertexIndex;
            n = n3 + 1;
            fArray[n3] = f3 + f13;
            n3 = n + 1;
            fArray[n] = f2 + f12;
            n = n3 + 1;
            fArray[n3] = f10;
            n3 = n + 1;
            fArray[n] = f11;
            n = n3 + 1;
            fArray[n3] = f14;
            n3 = n + 1;
            fArray[n] = f6 + f13;
            n = n3 + 1;
            fArray[n3] = f4 + f12;
            n3 = n + 1;
            fArray[n] = f10;
            n2 = n3 + 1;
            fArray[n3] = f11;
            n = n2 + 1;
            fArray[n2] = f9;
            n3 = n + 1;
            fArray[n] = f8 + f13;
            n = n3 + 1;
            fArray[n3] = f + f12;
            n3 = n + 1;
            fArray[n] = f10;
            n = n3 + 1;
            fArray[n3] = f15;
            n3 = n + 1;
            fArray[n] = f9;
            n = n3 + 1;
            fArray[n3] = f7 + f13;
            n3 = n + 1;
            fArray[n] = f5 + f12;
            n = n3 + 1;
            fArray[n3] = f10;
            n3 = n + 1;
            fArray[n] = f15;
            fArray[n3] = f14;
            this.vertexIndex = n3 + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
        block10: {
            float f10;
            float f11;
            float f12;
            float f13;
            float f14;
            float f15;
            float f16;
            float f17;
            float f18;
            int n;
            int n2;
            int n3;
            block12: {
                block11: {
                    if (!this.drawing) break block10;
                    short[] sArray = this.triangles;
                    float[] fArray = this.vertices;
                    Texture texture = textureRegion.texture;
                    if (texture != this.lastTexture) {
                        this.switchTexture(texture);
                    } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                        this.flush();
                    }
                    n3 = this.triangleIndex;
                    n2 = this.vertexIndex / 5;
                    int n4 = n3 + 1;
                    n = n2;
                    sArray[n3] = (short)n;
                    n3 = n4 + 1;
                    sArray[n4] = (short)(n2 + 1);
                    int n5 = n3 + 1;
                    n4 = (short)(n2 + 2);
                    sArray[n3] = (short)n4;
                    n3 = n5 + 1;
                    sArray[n5] = (short)n4;
                    n4 = n3 + 1;
                    sArray[n3] = (short)(n2 + 3);
                    sArray[n4] = (short)n;
                    this.triangleIndex = n4 + 1;
                    f18 = f + f3;
                    f17 = f2 + f4;
                    f16 = -f3;
                    f15 = -f4;
                    f5 -= f3;
                    f6 -= f4;
                    if (f7 != 1.0f) break block11;
                    f4 = f5;
                    f = f6;
                    f3 = f16;
                    f2 = f15;
                    if (f8 == 1.0f) break block12;
                }
                f3 = f16 * f7;
                f2 = f15 * f8;
                f4 = f5 * f7;
                f = f6 * f8;
            }
            if (f9 != 0.0f) {
                f8 = MathUtils.cosDeg(f9);
                f7 = MathUtils.sinDeg(f9);
                f6 = f8 * f3;
                f5 = f6 - f7 * f2;
                f9 = f3 * f7;
                f2 = f2 * f8 + f9;
                f3 = f7 * f;
                f9 += (f *= f8);
                f8 = f8 * f4 - f3;
                f15 = f + f7 * f4;
                f7 = f8 - (f6 -= f3) + f5;
                f = f15;
                f3 = f9;
                f4 = f5;
                f5 = f15 - (f9 - f2);
            } else {
                f7 = f4;
                f9 = f;
                f6 = f3;
                f5 = f2;
                f8 = f4;
                f4 = f3;
                f3 = f;
                f = f9;
            }
            if (bl) {
                f9 = textureRegion.u2;
                f14 = textureRegion.v2;
                f15 = textureRegion.u;
                f13 = textureRegion.v2;
                f16 = textureRegion.u;
                f12 = textureRegion.v;
                f11 = textureRegion.u2;
                f10 = textureRegion.v;
            } else {
                f9 = textureRegion.u;
                f14 = textureRegion.v;
                f15 = textureRegion.u2;
                f13 = textureRegion.v;
                f16 = textureRegion.u2;
                f12 = textureRegion.v2;
                f11 = textureRegion.u;
                f10 = textureRegion.v2;
            }
            float f19 = this.colorPacked;
            n2 = this.vertexIndex;
            n = n2 + 1;
            fArray[n2] = f4 + f18;
            n2 = n + 1;
            fArray[n] = f2 + f17;
            n = n2 + 1;
            fArray[n2] = f19;
            n2 = n + 1;
            fArray[n] = f9;
            n = n2 + 1;
            fArray[n2] = f14;
            n3 = n + 1;
            fArray[n] = f6 + f18;
            n2 = n3 + 1;
            fArray[n3] = f3 + f17;
            n = n2 + 1;
            fArray[n2] = f19;
            n2 = n + 1;
            fArray[n] = f15;
            n = n2 + 1;
            fArray[n2] = f13;
            n2 = n + 1;
            fArray[n] = f8 + f18;
            n = n2 + 1;
            fArray[n2] = f + f17;
            n2 = n + 1;
            fArray[n] = f19;
            n3 = n2 + 1;
            fArray[n2] = f16;
            n = n3 + 1;
            fArray[n3] = f12;
            n2 = n + 1;
            fArray[n] = f7 + f18;
            n3 = n2 + 1;
            fArray[n2] = f5 + f17;
            n = n3 + 1;
            fArray[n3] = f19;
            n2 = n + 1;
            fArray[n] = f11;
            fArray[n2] = f10;
            this.vertexIndex = n2 + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, Affine2 affine2) {
        if (this.drawing) {
            short[] sArray = this.triangles;
            float[] fArray = this.vertices;
            Texture texture = textureRegion.texture;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.triangleIndex + 6 > sArray.length || this.vertexIndex + 20 > fArray.length) {
                this.flush();
            }
            int n = this.triangleIndex;
            int n2 = this.vertexIndex / 5;
            int n3 = n + 1;
            int n4 = n2;
            sArray[n] = (short)n4;
            int n5 = n3 + 1;
            sArray[n3] = (short)(n2 + 1);
            n3 = n5 + 1;
            n = (short)(n2 + 2);
            sArray[n5] = (short)n;
            n5 = n3 + 1;
            sArray[n3] = (short)n;
            n3 = n5 + 1;
            sArray[n5] = (short)(n2 + 3);
            sArray[n3] = (short)n4;
            this.triangleIndex = n3 + 1;
            float f3 = affine2.m02;
            float f4 = affine2.m12;
            float f5 = affine2.m01;
            float f6 = affine2.m02;
            float f7 = affine2.m11;
            float f8 = affine2.m12;
            float f9 = affine2.m00;
            float f10 = affine2.m01;
            float f11 = affine2.m02;
            float f12 = affine2.m10;
            float f13 = affine2.m11;
            float f14 = affine2.m12;
            float f15 = affine2.m00;
            float f16 = affine2.m02;
            float f17 = affine2.m10;
            float f18 = affine2.m12;
            float f19 = textureRegion.u;
            float f20 = textureRegion.v2;
            float f21 = textureRegion.u2;
            float f22 = textureRegion.v;
            float f23 = this.colorPacked;
            n4 = this.vertexIndex;
            n2 = n4 + 1;
            fArray[n4] = f3;
            n4 = n2 + 1;
            fArray[n2] = f4;
            n3 = n4 + 1;
            fArray[n4] = f23;
            n2 = n3 + 1;
            fArray[n3] = f19;
            n4 = n2 + 1;
            fArray[n2] = f20;
            n2 = n4 + 1;
            fArray[n4] = f5 * f2 + f6;
            n4 = n2 + 1;
            fArray[n2] = f7 * f2 + f8;
            n2 = n4 + 1;
            fArray[n4] = f23;
            n4 = n2 + 1;
            fArray[n2] = f19;
            n3 = n4 + 1;
            fArray[n4] = f22;
            n2 = n3 + 1;
            fArray[n3] = f9 * f + f10 * f2 + f11;
            n4 = n2 + 1;
            fArray[n2] = f12 * f + f13 * f2 + f14;
            n2 = n4 + 1;
            fArray[n4] = f23;
            n4 = n2 + 1;
            fArray[n2] = f21;
            n2 = n4 + 1;
            fArray[n4] = f22;
            n4 = n2 + 1;
            fArray[n2] = f15 * f + f16;
            n2 = n4 + 1;
            fArray[n4] = f17 * f + f18;
            n4 = n2 + 1;
            fArray[n2] = f23;
            n2 = n4 + 1;
            fArray[n4] = f21;
            fArray[n2] = f20;
            this.vertexIndex = n2 + 1;
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before draw.");
    }

    @Override
    public void enableBlending() {
        this.flush();
        this.blendingDisabled = false;
    }

    @Override
    public void end() {
        if (this.drawing) {
            if (this.vertexIndex > 0) {
                this.flush();
            }
            this.lastTexture = null;
            this.drawing = false;
            Object object = Gdx.gl;
            object.glDepthMask(true);
            if (this.isBlendingEnabled()) {
                object.glDisable(3042);
            }
            if ((object = this.customShader) != null) {
                ((ShaderProgram)object).end();
            } else {
                this.shader.end();
            }
            return;
        }
        throw new IllegalStateException("PolygonSpriteBatch.begin must be called before end.");
    }

    @Override
    public void flush() {
        if (this.vertexIndex == 0) {
            return;
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        int n = this.triangleIndex;
        if (n > this.maxTrianglesInBatch) {
            this.maxTrianglesInBatch = n;
        }
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.vertexIndex);
        mesh.setIndices(this.triangles, 0, n);
        if (this.blendingDisabled) {
            Gdx.gl.glDisable(3042);
        } else {
            Gdx.gl.glEnable(3042);
            if (this.blendSrcFunc != -1) {
                Gdx.gl.glBlendFuncSeparate(this.blendSrcFunc, this.blendDstFunc, this.blendSrcFuncAlpha, this.blendDstFuncAlpha);
            }
        }
        ShaderProgram shaderProgram = this.customShader;
        if (shaderProgram == null) {
            shaderProgram = this.shader;
        }
        mesh.render(shaderProgram, 4, 0, n);
        this.vertexIndex = 0;
        this.triangleIndex = 0;
    }

    @Override
    public int getBlendDstFunc() {
        return this.blendDstFunc;
    }

    @Override
    public int getBlendDstFuncAlpha() {
        return this.blendDstFuncAlpha;
    }

    @Override
    public int getBlendSrcFunc() {
        return this.blendSrcFunc;
    }

    @Override
    public int getBlendSrcFuncAlpha() {
        return this.blendSrcFuncAlpha;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public float getPackedColor() {
        return this.colorPacked;
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    @Override
    public ShaderProgram getShader() {
        ShaderProgram shaderProgram;
        ShaderProgram shaderProgram2 = shaderProgram = this.customShader;
        if (shaderProgram == null) {
            shaderProgram2 = this.shader;
        }
        return shaderProgram2;
    }

    @Override
    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public boolean isBlendingEnabled() {
        return this.blendingDisabled ^ true;
    }

    @Override
    public boolean isDrawing() {
        return this.drawing;
    }

    @Override
    public void setBlendFunction(int n, int n2) {
        this.setBlendFunctionSeparate(n, n2, n, n2);
    }

    @Override
    public void setBlendFunctionSeparate(int n, int n2, int n3, int n4) {
        if (this.blendSrcFunc == n && this.blendDstFunc == n2 && this.blendSrcFuncAlpha == n3 && this.blendDstFuncAlpha == n4) {
            return;
        }
        this.flush();
        this.blendSrcFunc = n;
        this.blendDstFunc = n2;
        this.blendSrcFuncAlpha = n3;
        this.blendDstFuncAlpha = n4;
    }

    @Override
    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
        this.colorPacked = this.color.toFloatBits();
    }

    @Override
    public void setColor(Color color2) {
        this.color.set(color2);
        this.colorPacked = color2.toFloatBits();
    }

    @Override
    public void setPackedColor(float f) {
        Color.abgr8888ToColor(this.color, f);
        this.colorPacked = f;
    }

    @Override
    public void setProjectionMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.projectionMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    @Override
    public void setShader(ShaderProgram shaderProgram) {
        if (this.drawing) {
            this.flush();
            ShaderProgram shaderProgram2 = this.customShader;
            if (shaderProgram2 != null) {
                shaderProgram2.end();
            } else {
                this.shader.end();
            }
        }
        this.customShader = shaderProgram;
        if (this.drawing) {
            shaderProgram = this.customShader;
            if (shaderProgram != null) {
                shaderProgram.begin();
            } else {
                this.shader.begin();
            }
            this.setupMatrices();
        }
    }

    @Override
    public void setTransformMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.transformMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }
}

