/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;

public class TextureAtlasLoader
extends SynchronousAssetLoader<TextureAtlas, TextureAtlasParameter> {
    TextureAtlas.TextureAtlasData data;

    public TextureAtlasLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String iterator, FileHandle object, TextureAtlasParameter assetLoaderParameters) {
        iterator = ((FileHandle)object).parent();
        this.data = assetLoaderParameters != null ? new TextureAtlas.TextureAtlasData((FileHandle)object, (FileHandle)((Object)iterator), assetLoaderParameters.flip) : new TextureAtlas.TextureAtlasData((FileHandle)object, (FileHandle)((Object)iterator), false);
        object = new Array();
        for (TextureAtlas.TextureAtlasData.Page page : this.data.getPages()) {
            assetLoaderParameters = new TextureLoader.TextureParameter();
            ((TextureLoader.TextureParameter)assetLoaderParameters).format = page.format;
            ((TextureLoader.TextureParameter)assetLoaderParameters).genMipMaps = page.useMipMaps;
            ((TextureLoader.TextureParameter)assetLoaderParameters).minFilter = page.minFilter;
            ((TextureLoader.TextureParameter)assetLoaderParameters).magFilter = page.magFilter;
            ((Array)object).add(new AssetDescriptor<TextureAtlas>(page.textureFile, Texture.class, assetLoaderParameters));
        }
        return object;
    }

    @Override
    public TextureAtlas load(AssetManager disposable, String object, FileHandle object22, TextureAtlasParameter textureAtlasParameter) {
        for (TextureAtlas.TextureAtlasData.Page page : this.data.getPages()) {
            page.texture = ((AssetManager)disposable).get(page.textureFile.path().replaceAll("\\\\", "/"), Texture.class);
        }
        disposable = new TextureAtlas(this.data);
        this.data = null;
        return disposable;
    }

    public static class TextureAtlasParameter
    extends AssetLoaderParameters<TextureAtlas> {
        public boolean flip = false;

        public TextureAtlasParameter() {
        }

        public TextureAtlasParameter(boolean bl) {
            this.flip = bl;
        }
    }
}

