/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Game_Action;
import age.of.civilizations2.jakowski.lukasz.LanguageManager;
import age.of.civilizations2.jakowski.lukasz.Toast;
import age.of.civilizations2.jakowski.lukasz.ViewsManager;

class RTS {
    protected static final int MAX_SPEED = 6;
    protected static boolean PAUSE = true;
    protected static boolean PAUSED_BY_NEXT_TURN = false;
    protected static final boolean[] SHOW_REPORT;
    protected static int SOURCE = 0;
    protected static int SPEED = 1;
    protected static long TIME_LAST_UPDATE;
    protected static long TIME_PAST;
    protected static final int[] TIME_REQUIRED_TO_ACTION;
    protected static final int[] TIME_REQUIRED_TO_ACTION_LOADAI;
    protected static final int[] TIME_REQUIRED_TO_ACTION_MOVEUNITS;
    protected static final int[] TIME_REQUIRED_TO_ACTION_REPORT;

    static {
        TIME_REQUIRED_TO_ACTION = new int[]{1, 6500, 4000, 3000, 2000, 1250, 250};
        TIME_REQUIRED_TO_ACTION_MOVEUNITS = new int[]{1, 1750, 1250, 1000, 1000, 750, 500};
        TIME_REQUIRED_TO_ACTION_REPORT = new int[]{1, 2250, 2000, 1750, 1650, 1500, 500};
        TIME_REQUIRED_TO_ACTION_LOADAI = new int[]{1, 750, 500, 1, 1, 1, 1};
        SHOW_REPORT = new boolean[]{true, true, true, true, true, true, false};
        TIME_PAST = 0L;
        TIME_LAST_UPDATE = 0L;
    }

    RTS() {
    }

    private static final boolean addTime() {
        if (CFG.gameAction.getActiveTurnState() == Game_Action.TurnStates.INPUT_ORDERS) {
            if (!CFG.menuManager.getInGameView_Options() && !CFG.menuManager.getInGameView_EndOfGame()) {
                if (!CFG.SPECTATOR_MODE && (CFG.viewsManager.getActiveViewID() >= 0 && !CFG.viewsManager.getActiveView().canMoveArmy && CFG.viewsManager.getActiveViewID() != ViewsManager.VIEW_DISEASES_MODE || CFG.chooseProvinceMode || CFG.menuManager.getInGame_ProvinceMoveUnits_Visible() || CFG.menuManager.getInGame_ProvinceRecruit_Visible() || CFG.menuManager.getInGame_ProvinceRegroupArmy_Visible() || CFG.menuManager.getInGame_ProvinceDisband_Visible() || CFG.menuManager.getInGame_ProvinceBuild_Visible() || CFG.menuManager.getInGame_ProvinceChooseProvince_Visible() || CFG.menuManager.getVisible_InGame_FlagAction() || CFG.menuManager.getVisible_InGame_Budget() || CFG.menuManager.getVisibleInGame_Event())) {
                    return false;
                }
            } else {
                RTS.resetTime();
                return false;
            }
        }
        return true;
    }

    protected static final int getRequiredTime() {
        if (CFG.gameAction.getActiveTurnState() == Game_Action.TurnStates.INPUT_ORDERS) {
            return TIME_REQUIRED_TO_ACTION[SPEED];
        }
        if (CFG.gameAction.getActiveTurnState() == Game_Action.TurnStates.TURN_ACTIONS) {
            if (CFG.gameAction.getCurrentMoveunits() != null) {
                return TIME_REQUIRED_TO_ACTION_MOVEUNITS[SPEED];
            }
            return TIME_REQUIRED_TO_ACTION_REPORT[SPEED];
        }
        if (CFG.gameAction.getActiveTurnState() != Game_Action.TurnStates.LOAD_AI_RTO && CFG.gameAction.getActiveTurnState() != Game_Action.TurnStates.LOADING_NEXT_TURN) {
            return TIME_REQUIRED_TO_ACTION[SPEED];
        }
        return TIME_REQUIRED_TO_ACTION_LOADAI[SPEED];
    }

    protected static final float getTimePerc() {
        return Math.min((float)TIME_PAST / (float)RTS.getRequiredTime(), 1.0f);
    }

    protected static boolean isEnabled() {
        int n = CFG.game.getPlayersSize();
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    protected static void pauseUnpause() {
        String string2;
        LanguageManager languageManager;
        PAUSED_BY_NEXT_TURN = false;
        if (!(PAUSE ^= true)) {
            TIME_LAST_UPDATE = System.currentTimeMillis();
        }
        Toast toast = CFG.toast;
        if (PAUSE) {
            languageManager = CFG.langManager;
            string2 = "Paused";
        } else {
            languageManager = CFG.langManager;
            string2 = "Unpaused";
        }
        toast.setInView(languageManager.get(string2));
    }

    protected static final void reset() {
        PAUSE = true;
        PAUSED_BY_NEXT_TURN = false;
        RTS.resetTime();
    }

    protected static final void resetTime() {
        TIME_PAST = 0L;
        TIME_LAST_UPDATE = System.currentTimeMillis();
    }

    protected static final boolean showReport() {
        return SHOW_REPORT[SPEED];
    }

    private static final boolean timePasted() {
        boolean bl = TIME_PAST > (long)RTS.getRequiredTime();
        return bl;
    }

    protected static void updateSpeed(int n) {
        float f = RTS.getTimePerc();
        if ((n = (SPEED += n)) < 1) {
            SPEED = 1;
        } else if (n > 6) {
            SPEED = 6;
        }
        TIME_PAST = (long)((float)TIME_REQUIRED_TO_ACTION[SPEED] * f);
        Toast toast = CFG.toast;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CFG.langManager.get("Speed"));
        stringBuilder.append(": ");
        stringBuilder.append(SPEED);
        toast.setInView(stringBuilder.toString());
    }

    protected static final void updateTime() {
        if (RTS.addTime()) {
            TIME_PAST += System.currentTimeMillis() - TIME_LAST_UPDATE;
            TIME_LAST_UPDATE = System.currentTimeMillis();
        } else {
            TIME_LAST_UPDATE = System.currentTimeMillis();
        }
        if (RTS.timePasted()) {
            TIME_PAST = 0L;
            if (CFG.gameAction.getActiveTurnState() == Game_Action.TurnStates.INPUT_ORDERS) {
                CFG.gameAction.tryToTakeNexTurn();
            } else if (CFG.gameAction.getActiveTurnState() == Game_Action.TurnStates.TURN_ACTIONS) {
                CFG.gameAction.tryToTakeNexTurn();
            } else if ((CFG.gameAction.getActiveTurnState() == Game_Action.TurnStates.LOAD_AI_RTO || CFG.gameAction.getActiveTurnState() == Game_Action.TurnStates.LOADING_NEXT_TURN) && CFG.menuManager.getInGame_ProvinceInfo().getMenuElement(0).getClickable()) {
                CFG.gameAction.tryToTakeNexTurn();
                RTS.resetTime();
            }
        }
    }

    protected static void updateTimePast_AfterAction(float f) {
        if ((TIME_PAST -= (long)((int)((float)TIME_REQUIRED_TO_ACTION[SPEED] * f))) < 0L) {
            TIME_PAST = 0L;
        }
    }
}

