/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.Modifier;

public final class ClassReflection {
    public static Class forName(String string2) throws ReflectionException {
        try {
            Class<?> clazz = Class.forName(string2);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Class not found: ");
            stringBuilder.append(string2);
            throw new ReflectionException(stringBuilder.toString(), classNotFoundException);
        }
    }

    public static Annotation getAnnotation(Class object, Class<? extends java.lang.annotation.Annotation> clazz) {
        if ((object = ((Class)object).getAnnotation(clazz)) != null) {
            return new Annotation((java.lang.annotation.Annotation)object);
        }
        return null;
    }

    public static Annotation[] getAnnotations(Class annotationArray) {
        annotationArray = annotationArray.getAnnotations();
        Annotation[] annotationArray2 = new Annotation[annotationArray.length];
        for (int i = 0; i < annotationArray.length; ++i) {
            annotationArray2[i] = new Annotation(annotationArray[i]);
        }
        return annotationArray2;
    }

    public static Class getComponentType(Class clazz) {
        return clazz.getComponentType();
    }

    public static Constructor getConstructor(Class clazz, Class ... object) throws ReflectionException {
        try {
            object = new Constructor(clazz.getConstructor((Class<?>)object));
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Constructor not found for class: ");
            ((StringBuilder)object).append(clazz.getName());
            throw new ReflectionException(((StringBuilder)object).toString(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Security violation occurred while getting constructor for class: '");
            stringBuilder.append(clazz.getName());
            stringBuilder.append("'.");
            throw new ReflectionException(stringBuilder.toString(), securityException);
        }
    }

    public static Constructor[] getConstructors(Class constructorArray) {
        constructorArray = constructorArray.getConstructors();
        Constructor[] constructorArray2 = new Constructor[constructorArray.length];
        int n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            constructorArray2[i] = new Constructor(constructorArray[i]);
        }
        return constructorArray2;
    }

    public static Annotation getDeclaredAnnotation(Class annotationArray, Class<? extends java.lang.annotation.Annotation> clazz) {
        for (java.lang.annotation.Annotation annotation : annotationArray.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return new Annotation(annotation);
        }
        return null;
    }

    public static Annotation[] getDeclaredAnnotations(Class annotationArray) {
        java.lang.annotation.Annotation[] annotationArray2 = annotationArray.getDeclaredAnnotations();
        annotationArray = new Annotation[annotationArray2.length];
        for (int i = 0; i < annotationArray2.length; ++i) {
            annotationArray[i] = new Annotation(annotationArray2[i]);
        }
        return annotationArray;
    }

    public static Constructor getDeclaredConstructor(Class clazz, Class ... object) throws ReflectionException {
        try {
            object = new Constructor(clazz.getDeclaredConstructor((Class<?>)object));
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Constructor not found for class: ");
            ((StringBuilder)object).append(clazz.getName());
            throw new ReflectionException(((StringBuilder)object).toString(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Security violation while getting constructor for class: ");
            ((StringBuilder)object).append(clazz.getName());
            throw new ReflectionException(((StringBuilder)object).toString(), securityException);
        }
    }

    public static Field getDeclaredField(Class clazz, String string2) throws ReflectionException {
        try {
            Field field = new Field(clazz.getDeclaredField(string2));
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field not found: ");
            stringBuilder.append(string2);
            stringBuilder.append(", for class: ");
            stringBuilder.append(clazz.getName());
            throw new ReflectionException(stringBuilder.toString(), noSuchFieldException);
        }
        catch (SecurityException securityException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Security violation while getting field: ");
            stringBuilder.append(string2);
            stringBuilder.append(", for class: ");
            stringBuilder.append(clazz.getName());
            throw new ReflectionException(stringBuilder.toString(), securityException);
        }
    }

    public static Field[] getDeclaredFields(Class fieldArray) {
        fieldArray = fieldArray.getDeclaredFields();
        Field[] fieldArray2 = new Field[fieldArray.length];
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            fieldArray2[i] = new Field(fieldArray[i]);
        }
        return fieldArray2;
    }

    public static Method getDeclaredMethod(Class clazz, String string2, Class ... object) throws ReflectionException {
        try {
            object = new Method(clazz.getDeclaredMethod(string2, (Class<?>)object));
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Method not found: ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(", for class: ");
            ((StringBuilder)object).append(clazz.getName());
            throw new ReflectionException(((StringBuilder)object).toString(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Security violation while getting method: ");
            stringBuilder.append(string2);
            stringBuilder.append(", for class: ");
            stringBuilder.append(clazz.getName());
            throw new ReflectionException(stringBuilder.toString(), securityException);
        }
    }

    public static Method[] getDeclaredMethods(Class methodArray) {
        methodArray = methodArray.getDeclaredMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            methodArray2[i] = new Method(methodArray[i]);
        }
        return methodArray2;
    }

    public static Object[] getEnumConstants(Class clazz) {
        return clazz.getEnumConstants();
    }

    public static Field getField(Class clazz, String string2) throws ReflectionException {
        try {
            Field field = new Field(clazz.getField(string2));
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field not found: ");
            stringBuilder.append(string2);
            stringBuilder.append(", for class: ");
            stringBuilder.append(clazz.getName());
            throw new ReflectionException(stringBuilder.toString(), noSuchFieldException);
        }
        catch (SecurityException securityException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Security violation while getting field: ");
            stringBuilder.append(string2);
            stringBuilder.append(", for class: ");
            stringBuilder.append(clazz.getName());
            throw new ReflectionException(stringBuilder.toString(), securityException);
        }
    }

    public static Field[] getFields(Class fieldArray) {
        java.lang.reflect.Field[] fieldArray2 = fieldArray.getFields();
        fieldArray = new Field[fieldArray2.length];
        int n = fieldArray2.length;
        for (int i = 0; i < n; ++i) {
            fieldArray[i] = new Field(fieldArray2[i]);
        }
        return fieldArray;
    }

    public static Class[] getInterfaces(Class clazz) {
        return clazz.getInterfaces();
    }

    public static Method getMethod(Class clazz, String string2, Class ... object) throws ReflectionException {
        try {
            object = new Method(clazz.getMethod(string2, (Class<?>)object));
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Method not found: ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(", for class: ");
            ((StringBuilder)object).append(clazz.getName());
            throw new ReflectionException(((StringBuilder)object).toString(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Security violation while getting method: ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(", for class: ");
            ((StringBuilder)object).append(clazz.getName());
            throw new ReflectionException(((StringBuilder)object).toString(), securityException);
        }
    }

    public static Method[] getMethods(Class methodArray) {
        java.lang.reflect.Method[] methodArray2 = methodArray.getMethods();
        methodArray = new Method[methodArray2.length];
        int n = methodArray2.length;
        for (int i = 0; i < n; ++i) {
            methodArray[i] = new Method(methodArray2[i]);
        }
        return methodArray;
    }

    public static String getSimpleName(Class clazz) {
        return clazz.getSimpleName();
    }

    public static boolean isAbstract(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAnnotation(Class clazz) {
        return clazz.isAnnotation();
    }

    public static boolean isAnnotationPresent(Class clazz, Class<? extends java.lang.annotation.Annotation> clazz2) {
        return clazz.isAnnotationPresent(clazz2);
    }

    public static boolean isArray(Class clazz) {
        return clazz.isArray();
    }

    public static boolean isAssignableFrom(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2);
    }

    public static boolean isEnum(Class clazz) {
        return clazz.isEnum();
    }

    public static boolean isInstance(Class clazz, Object object) {
        return clazz.isInstance(object);
    }

    public static boolean isInterface(Class clazz) {
        return clazz.isInterface();
    }

    public static boolean isMemberClass(Class clazz) {
        return clazz.isMemberClass();
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive();
    }

    public static boolean isStaticClass(Class clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static <T> T newInstance(Class<T> clazz) throws ReflectionException {
        T t;
        try {
            t = clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not instantiate instance of class: ");
            stringBuilder.append(clazz.getName());
            throw new ReflectionException(stringBuilder.toString(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not instantiate instance of class: ");
            stringBuilder.append(clazz.getName());
            throw new ReflectionException(stringBuilder.toString(), instantiationException);
        }
        return t;
    }
}

