/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.BufferUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final byte[] EMPTY_BYTES = new byte[0];

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static int copyStream(InputStream inputStream, ByteBuffer byteBuffer, byte[] byArray) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            BufferUtils.copy(byArray, 0, (Buffer)byteBuffer, n);
            byteBuffer.position(n2 + (n3 += n));
        }
        byteBuffer.position(n2);
        return n3;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtils.copyStream(inputStream, outputStream, new byte[4096]);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        StreamUtils.copyStream(inputStream, outputStream, new byte[n]);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void copyStream(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        StreamUtils.copyStream(inputStream, byteBuffer, new byte[4096]);
    }

    public static void copyStream(InputStream inputStream, ByteBuffer byteBuffer, int n) throws IOException {
        StreamUtils.copyStream(inputStream, byteBuffer, new byte[n]);
    }

    public static byte[] copyStreamToByteArray(InputStream inputStream) throws IOException {
        return StreamUtils.copyStreamToByteArray(inputStream, inputStream.available());
    }

    public static byte[] copyStreamToByteArray(InputStream inputStream, int n) throws IOException {
        OptimizedByteArrayOutputStream optimizedByteArrayOutputStream = new OptimizedByteArrayOutputStream(Math.max(0, n));
        StreamUtils.copyStream(inputStream, optimizedByteArrayOutputStream);
        return ((ByteArrayOutputStream)optimizedByteArrayOutputStream).toByteArray();
    }

    public static String copyStreamToString(InputStream inputStream) throws IOException {
        return StreamUtils.copyStreamToString(inputStream, inputStream.available(), null);
    }

    public static String copyStreamToString(InputStream inputStream, int n) throws IOException {
        return StreamUtils.copyStreamToString(inputStream, n, null);
    }

    public static String copyStreamToString(InputStream closeable, int n, String object) throws IOException {
        closeable = object == null ? new InputStreamReader((InputStream)closeable) : new InputStreamReader((InputStream)closeable, (String)object);
        StringWriter stringWriter = new StringWriter(Math.max(0, n));
        object = new char[4096];
        while ((n = ((Reader)closeable).read((char[])object)) != -1) {
            stringWriter.write((char[])object, 0, n);
        }
        return stringWriter.toString();
    }

    public static class OptimizedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public OptimizedByteArrayOutputStream(int n) {
            super(n);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        @Override
        public byte[] toByteArray() {
            synchronized (this) {
                block4: {
                    if (this.count != this.buf.length) break block4;
                    byte[] byArray = this.buf;
                    return byArray;
                }
                byte[] byArray = super.toByteArray();
                return byArray;
            }
        }
    }
}

