/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import java.util.Comparator;

public class SnapshotArray<T>
extends Array<T> {
    private T[] recycled;
    private T[] snapshot;
    private int snapshots;

    public SnapshotArray() {
    }

    public SnapshotArray(int n) {
        super(n);
    }

    public SnapshotArray(Array array) {
        super(array);
    }

    public SnapshotArray(Class clazz) {
        super(clazz);
    }

    public SnapshotArray(boolean bl, int n) {
        super(bl, n);
    }

    public SnapshotArray(boolean bl, int n, Class clazz) {
        super(bl, n, clazz);
    }

    public SnapshotArray(boolean bl, T[] TArray, int n, int n2) {
        super(bl, TArray, n, n2);
    }

    public SnapshotArray(T[] TArray) {
        super(TArray);
    }

    private void modified() {
        T[] TArray = this.snapshot;
        if (TArray != null && TArray == this.items) {
            TArray = this.recycled;
            if (TArray != null && TArray.length >= this.size) {
                System.arraycopy(this.items, 0, this.recycled, 0, this.size);
                this.items = this.recycled;
                this.recycled = null;
            } else {
                this.resize(this.items.length);
            }
        }
    }

    public static <T> SnapshotArray<T> with(T ... TArray) {
        return new SnapshotArray<T>(TArray);
    }

    public T[] begin() {
        this.modified();
        this.snapshot = this.items;
        ++this.snapshots;
        return this.items;
    }

    @Override
    public void clear() {
        this.modified();
        super.clear();
    }

    public void end() {
        int n = this.snapshots;
        this.snapshots = Math.max(0, n - 1);
        T[] TArray = this.snapshot;
        if (TArray == null) {
            return;
        }
        if (TArray != this.items && this.snapshots == 0) {
            this.recycled = this.snapshot;
            n = this.recycled.length;
            for (int i = 0; i < n; ++i) {
                this.recycled[i] = null;
            }
        }
        this.snapshot = null;
    }

    @Override
    public void insert(int n, T t) {
        this.modified();
        super.insert(n, t);
    }

    @Override
    public T pop() {
        this.modified();
        return super.pop();
    }

    @Override
    public boolean removeAll(Array<? extends T> array, boolean bl) {
        this.modified();
        return super.removeAll(array, bl);
    }

    @Override
    public T removeIndex(int n) {
        this.modified();
        return super.removeIndex(n);
    }

    @Override
    public void removeRange(int n, int n2) {
        this.modified();
        super.removeRange(n, n2);
    }

    @Override
    public boolean removeValue(T t, boolean bl) {
        this.modified();
        return super.removeValue(t, bl);
    }

    @Override
    public void reverse() {
        this.modified();
        super.reverse();
    }

    @Override
    public void set(int n, T t) {
        this.modified();
        super.set(n, t);
    }

    @Override
    public T[] setSize(int n) {
        this.modified();
        return super.setSize(n);
    }

    @Override
    public void shuffle() {
        this.modified();
        super.shuffle();
    }

    @Override
    public void sort() {
        this.modified();
        super.sort();
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        this.modified();
        super.sort(comparator);
    }

    @Override
    public void swap(int n, int n2) {
        this.modified();
        super.swap(n, n2);
    }

    @Override
    public void truncate(int n) {
        this.modified();
        super.truncate(n);
    }
}

